<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Api extends CI_Controller {
	public function __construct() {
		parent::__construct();
		$this->load->model('model_crud');
		$this->load->model('model_laporan');
	}

	public function index() {
      	$method=$this->input->post('method');
		if ($method=='penjualan') {
			$this->penjualan();
		} else if ($method=='stok') {
			$this->stok();
		} else if ($method=='penjualanstruk') {
			$this->penjualanstruk();
		} else if ($method=='rekapjual') {
			$this->rekapjual();
		} else if ($method=='rekapjualdetail') {
			$this->rekapjualdetail();
		} else if ($method=='membuattagihan') {
			$this->membuattagihan();
		}
	}

	public function penjualan() {
		$awal=$this->input->post('awal');
        $akhir=$this->input->post('akhir');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
        $selek='tb_penjualan.faktur_jual,tb_penjualan.tanggal,tb_penjualanmeta.kode_barang,potongan,jumlah_jual,tb_penjualanmeta.konversi,tb_penjualanmeta.satuan_ecer,total_harga,barang,pegawai';
        $query=$this->model_laporan->datajualdetail($selek,$kunci);
        $datajual=$query->result();
        echo json_encode($datajual);
	}
	
	public function stok() {
        //mari kita ambil datanya
        $kunci=array('tb_barang.aktif'=>1);
        $selek='tb_barang.kode_barang,tb_barang.barcode,tb_barang.harga_beli,stok,barang';
        $query=$this->model_laporan->datajualdetail($selek,$kunci);
        $databarang=$query->result();
        echo json_encode($databarang);
	}
	
	public function penjualanstruk() {
		$awal=$this->input->post('awal');
        $akhir=$this->input->post('akhir');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
        $selek='tb_penjualan.faktur_jual,tb_penjualan.kode_pegawai,tb_penjualan.tanggal,tunai,non_tunai,metode,referensi,kembali,total,(poin*nilaipoin) AS poin,pegawai';
        $query=$this->model_laporan->datarekapjual($selek,$kunci);
        $datajual=$query->result();
        echo json_encode($datajual);
	}
	
	public function rekapjual() {
		$awal=$this->input->post('awal');
        $akhir=$this->input->post('akhir');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
        $selek='tb_penjualan.faktur_jual,tb_penjualan.kode_pegawai,tb_penjualan.tanggal,COUNT(tb_penjualanmeta.kode_barang) AS jumlah_barang,SUM(potongan) AS potongan,SUM(jumlah_jual) AS jumlah_jual,SUM(total_harga) total_harga,SUM(tb_penjualanmeta.harga_beli) AS harga_beli,pegawai';
        $query=$this->model_laporan->datarekapjual($selek,$kunci);
        $datajual=$query->result();
        echo json_encode($datajual);
	}
	
	public function rekapjualdetail() {
		$awal=$this->input->post('awal');
        $akhir=$this->input->post('akhir');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
        $selek='tb_penjualan.tanggal,tb_penjualan.faktur_jual,total,(tb_penjualanmeta.harga_beli*jumlah_jual) AS harga_beli';
        $query=$this->model_laporan->datajualdetail($selek,$kunci);
        $datajual=$query->result();
        echo json_encode($datajual);
	}
}