<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Master extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if ($this->session->userdata('kp')=='') {
			redirect('login');
		}
		if ($this->session->userdata('level')<>'Administrator') {
			redirect('beranda');
		}
		$this->load->model('model_crud');
		$this->load->model('model_master');
	}

	public function index() {
		redirect('master/kategori');
	}

	public function kategori() {
		$data['title']='Kategori Barang';
		$data['template']='master/view_kategori';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datakategori() {
		$req=$_REQUEST;
		$total=$this->model_master->datakategori($req,'jumlah');
		$datatab=$this->model_master->datakategori($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=$hasil->id_kategori;
			$datanya[]=$hasil->kategori;
			$datanya[]='<button type="button" class="btn btn-info btn-xs" title="Edit" onclick="tampilform(this.value)" value="'.$hasil->id_kategori.'"><i class="fa fa-edit"></i></button>';
			$datanya[]='<button type="button" title="Hapus" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->id_kategori.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_kategori() {
		$id=$this->input->post('id');
		$data['aksi']='Simpan';
		$kunci=array('id_kategori'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_kategori');
		$cek=$query->row();
		if ($cek) {
			$data['kategori']=$cek->kategori;
			$data['id']=$cek->id_kategori;
			$data['aksi']='Ubah';
		}
		$data['title']='Form Kategori Barang';
		$this->load->view('master/form_kategori',$data);
	}

	public function simpan_kategori() {
		$kategori=$this->input->post('kategori');
		$id=$this->input->post('id');
		$aksi=$this->input->post('aksi');
		if ($aksi=='Simpan') {
			//tambah data
			$kunci=array('kategori'=>$kategori,'aktif'=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_kategori');
			$cek=$query->num_rows();
			if ($cek) {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Kategori barang sudah ada!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Kategori barang sudah ada!';
				$ikon='error';
			} else {
				//baru tambahkan data
				$isi=array('kategori'=>$kategori,'aktif'=>1);
				$this->model_crud->tambah_data('tb_kategori',$isi);
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Kategori barang berhasil ditambahkan!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Kategori barang berhasil ditambahkan!';
				$ikon='success';
			}
		} else {
			//update data
			$kunci=array('id_kategori'=>$id);
			$isi=array('kategori'=>$kategori);
			$this->model_crud->update_data($kunci,'tb_kategori',$isi);
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Kategori barang berhasil diubah!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Kategori barang berhasil diubah!';
			$ikon='success';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function hapus_kategori() {
		$id=$this->input->post('id');
		$kunci=array('id_kategori'=>$id);
		$isi=array('aktif'=>0);
		$this->model_crud->update_data($kunci,'tb_kategori',$isi);
		$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
					Kategori barang berhasil dihapus
					<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>';
		$toas='Kategori barang berhasil dihapus';
		$ikon='warning';
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function barang() {
		$data['title']='Barang';
		$data['template']='master/view_barang';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function databarang() {
		$req=$_REQUEST;
		$total=$this->model_master->databarang($req,'jumlah');
		$datatab=$this->model_master->databarang($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			if ($hasil->harga_beli) {
				$hargabeli=$hasil->harga_beli;
			} else {
				$hargabeli=1;
			}
			$selisih=$hasil->harga_jual1-$hargabeli;
			$persen=$selisih/$hargabeli*100;
			$persen=round($persen,0);
			$datanya=array();
			$datanya[]=$hasil->kode_barang;
			$datanya[]=$hasil->barcode;
			$datanya[]=$hasil->barang;
			$datanya[]=number_format($hasil->harga_beli,0,',','.');
			$datanya[]=number_format($hasil->harga_jual1,0,',','.');
			$datanya[]=$persen.'%';
			$datanya[]=$hasil->kategori;
			$datanya[]=$hasil->suplier;
			$datanya[]=$hasil->stok;
			$datanya[]='<a href="'.base_url('master/form_barang?id='.$hasil->kode_barang).'" class="btn btn-info btn-xs" title="Edit"><i class="fa fa-edit"></i></a>';
			$datanya[]='<button type="button" title="Hapus" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->kode_barang.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_barang() {
		$id=$this->input->get('id');
		$data['aksi']='Simpan';
		$data['datapotongan']=array();
		$data['databonus']=array();
		$data['datatebus']=array();
		$kunci=array('kode_barang'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_barang');
		$cek=$query->row();
		if ($cek) {
			$this->load->model('model_laporan');
			//ambil pengaturan
			$kunci=array(1=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
			$datapengaturan=$query->result();
			$arropsi=array();
			foreach ($datapengaturan as $hasil) {
				$arropsi[$hasil->pengaturan]=$hasil->isi;
			}
			$data['kode']=$cek->kode_barang;
			$data['barcode']=$cek->barcode;
			$data['barcode2']=$cek->barcode2;
			$data['barcode3']=$cek->barcode3;
			$data['barang']=$cek->barang;
			$data['kategori']=$cek->id_kategori;
			$data['beli']=$cek->harga_beli;
			$data['minimal']=$cek->stok_minimal;
			$data['maksimal']=$cek->stok_maksimal;
			$data['stok']=$cek->stok;
			//cari persentase
			if ($cek->harga_beli) {
				$hargabeli=$cek->harga_beli;
			} else {
				$hargabeli=1;
			}
			//ambil data potongan
			$kunci=array('kode_barang'=>$cek->kode_barang);
			$query=$this->model_crud->ambil_data($kunci,'tb_potongan');
			$data['datapotongan']=$query->result();
			//ambil data bonus
			$kunci=array('kode_barang'=>$cek->kode_barang);
			$query=$this->model_crud->ambil_data($kunci,'tb_bonus');
			$data['databonus']=$query->result();
			//ambil data tebus
			$kunci=array('kode_barang'=>$cek->kode_barang);
			$query=$this->model_crud->ambil_data($kunci,'tb_tebusharga');
			$data['datatebus']=$query->result();
			//ambil data satuan
			$kunci=array('kode_barang'=>$cek->kode_barang);
			$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
			$ceker=$query->row();
			if ($ceker) {
				$data['satuan1']=$ceker->satuan1;
				$data['jual1']=$ceker->harga_jual1;
				$data['jual2']=$ceker->harga_jual2;
				$data['jual3']=$ceker->harga_jual3;
				$data['satuan2']=$ceker->satuan2;
				$data['konversi1']=$ceker->konversi1;
				$data['jual21']=$ceker->harga_jual21;
				$data['jual22']=$ceker->harga_jual22;
				$data['jual23']=$ceker->harga_jual23;
				$data['satuan3']=$ceker->satuan3;
				$data['konversi2']=$ceker->konversi2;
				$data['jual31']=$ceker->harga_jual31;
				$data['jual32']=$ceker->harga_jual32;
				$data['jual33']=$ceker->harga_jual33;
			}
			//ambil data PKM
			$kunci=array('pengaturan'=>'lt');
			$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
			$ceker=$query->row();
			if ($ceker) {
				$lt=$ceker->isi;
			} else {
				$lt=0;
			}
			$kunci=array('pengaturan'=>'ratajual');
			$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
			$ceker=$query->row();
			if ($ceker) {
				$ratajual=$ceker->isi;
			} else {
				$ratajual=0;
			}
			$tglakhir=date('Y-m-d');
			$tglawal=date('Y-m-d',strtotime('-'.$ratajual.' day',strtotime($tglakhir)));
			//sekarang kita hitung rata2 penjualan barang tersebut
			$kunci=array("DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="=>$tglawal,"DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="=>$tglakhir,'tb_penjualanmeta.kode_barang'=>$cek->kode_barang);
            $query=$this->model_laporan->datarekapjualbarang($kunci);
			$cekcok=$query->row();
			if ($cekcok) {
			    $jumba=$cekcok->jumlah;
			} else {
			    $jumba=0;
			}
			if ($jumba) {
				$ratabarang=round($jumba/$ratajual);
			} else {
				$ratabarang=0;
			}
			$pkm=$ratabarang*$lt+$cek->stok_minimal;
			$data['pkm']=$pkm;
			$data['aksi']='Ubah';
		}
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_kategori');
		$data['datakategori']=$query->result();
		//ambil pengaturan receh
		$kunci=array('pengaturan'=>'receh');
		$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
		$cek=$query->row();
		if ($cek) {
			$data['receh']=$cek->isi;
		} else {
			$data['receh']=1;
		}
		$data['awal']=date('Y-m').'-01';
		$data['akhir']=date('Y-m-d');
		$data['title']='Form Barang';
		$data['template']='master/form_barang';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function simpan_barang() {
		$kode=$this->input->post('kode');
		$barcode=$this->input->post('barcode');
		$barcode2=$this->input->post('barcode2');
		$barcode3=$this->input->post('barcode3');
		$barang=$this->input->post('barang');
		$kategori=$this->input->post('kategori');
		$beli=$this->input->post('beli');
		$minimal=$this->input->post('minimal');
		$pkm=$this->input->post('pkm');
		$stok=$this->input->post('stok');
		$satuan1=$this->input->post('satuan1');
		$satuan2=$this->input->post('satuan2');
		$satuan3=$this->input->post('satuan3');
		$konversi1=$this->input->post('konversi1');
		$konversi2=$this->input->post('konversi2');
		$jual1=$this->input->post('jual1');
		$jual2=$this->input->post('jual2');
		$jual3=$this->input->post('jual3');
		$jual21=$this->input->post('jual21');
		$jual22=$this->input->post('jual22');
		$jual23=$this->input->post('jual23');
		$jual31=$this->input->post('jual31');
		$jual32=$this->input->post('jual32');
		$jual33=$this->input->post('jual33');
		$mulai=$this->input->post('mulai');
		$selesai=$this->input->post('selesai');
		$potongan=$this->input->post('potongan');
		$jumlah=$this->input->post('jumlah');
		$berlaku=$this->input->post('berlaku');
		$idpot=$this->input->post('idpot');

		$mulaibonus=$this->input->post('mulaibonus');
		$selesaibonus=$this->input->post('selesaibonus');
		$jumbeli=$this->input->post('jumbeli');
		$bonus=$this->input->post('bonus');
		$idbonus=$this->input->post('idbonus');

		$mulai2=$this->input->post('mulai2');
		$selesai2=$this->input->post('selesai2');
		$belanja=$this->input->post('belanja');
		$harga=$this->input->post('harga');
		$berlaku2=$this->input->post('berlaku2');
		$idtebus=$this->input->post('idtebus');
		$id=$this->input->post('id');
		$aksi=$this->input->post('aksi');
		if ($aksi=='Simpan') {
			//tambah data
			$kunci=array('kode_barang'=>$kode,'aktif'=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_barang');
			$cek=$query->num_rows();
			if ($cek) {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Kode barang berhasil sudah ada!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Kode barang berhasil sudah ada!';
				$ikon='error';
			} else {
				//baru tambahkan data
				$isi=array('kode_barang'=>$kode,'barcode'=>$barcode,'barcode2'=>$barcode2,'barcode3'=>$barcode3,'barang'=>$barang,'harga_beli'=>$beli,'id_kategori'=>$kategori,'stok_minimal'=>$minimal,'stok_maksimal'=>$pkm,'stok'=>$stok,'aktif'=>1);
				$this->model_crud->tambah_data('tb_barang',$isi);
				//tambahkan ke tabel satuan
				$kunci=array('kode_barang'=>$kode);
				$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
				$cek=$query->num_rows();
				if ($cek) {
					$isi=array('satuan1'=>$satuan1,'harga_jual1'=>$jual1,'harga_jual2'=>$jual2,'harga_jual3'=>$jual3,'satuan2'=>$satuan2,'konversi1'=>$konversi1,'harga_jual21'=>$jual21,'harga_jual22'=>$jual22,'harga_jual23'=>$jual23,'satuan3'=>$satuan3,'konversi2'=>$konversi2,'harga_jual31'=>$jual31,'harga_jual32'=>$jual32,'harga_jual33'=>$jual33);
					$this->model_crud->update_data($kunci,'tb_satuanbarang',$isi);
				} else {
					$isi=array('kode_barang'=>$kode,'satuan1'=>$satuan1,'harga_jual1'=>$jual1,'harga_jual2'=>$jual2,'harga_jual3'=>$jual3,'satuan2'=>$satuan2,'konversi1'=>$konversi1,'harga_jual21'=>$jual21,'harga_jual22'=>$jual22,'harga_jual23'=>$jual23,'satuan3'=>$satuan3,'konversi2'=>$konversi2,'harga_jual31'=>$jual31,'harga_jual32'=>$jual32,'harga_jual33'=>$jual33);
					$this->model_crud->tambah_data('tb_satuanbarang',$isi);
				}
				//tambahkan ke tabel potongan
				if ($mulai) {
					foreach ($mulai as $key => $value) {
						if ($idpot[$key]) {
							$kunci=array('id_potongan'=>$idpot[$key]);
							$isi=array('kode_barang'=>$kode,'mulai'=>$value,'selesai'=>$selesai[$key],'jumlah_beli'=>$jumlah[$key],'potongan'=>$potongan[$key]);
							$this->model_crud->update_data($kunci,'tb_potongan',$isi);
						} else {
							$isi=array('kode_barang'=>$kode,'mulai'=>$value,'selesai'=>$selesai[$key],'jumlah_beli'=>$jumlah[$key],'potongan'=>$potongan[$key]);
							$this->model_crud->tambah_data('tb_potongan',$isi);
						}
					}
				}
				//tambahkan ke tabel bonus
				if ($mulaibonus) {
					foreach ($mulaibonus as $key => $value) {
						if ($idbonus[$key]) {
							$kunci=array('id_bonus'=>$idbonus[$key]);
							$isi=array('kode_barang'=>$kode,'mulai'=>$value,'selesai'=>$selesaibonus[$key],'jumlah_beli'=>$jumbeli[$key],'bonus'=>$bonus[$key]);
							$this->model_crud->update_data($kunci,'tb_bonus',$isi);
						} else {
							$isi=array('kode_barang'=>$kode,'mulai'=>$value,'selesai'=>$selesaibonus[$key],'jumlah_beli'=>$jumbeli[$key],'bonus'=>$bonus[$key]);
							$this->model_crud->tambah_data('tb_bonus',$isi);
						}
					}
				}
				//tambahkan ke tabel tebus harga
				if ($mulai2) {
					foreach ($mulai2 as $key => $value) {
						if ($idtebus[$key]) {
							$kunci=array('id_tebusharga'=>$idtebus[$key]);
							$isi=array('kode_barang'=>$kode,'mulai'=>$value,'selesai'=>$selesai2[$key],'minimal_belanja'=>$belanja[$key],'harga'=>$harga[$key]);
							$this->model_crud->update_data($kunci,'tb_tebusharga',$isi);
						} else {
							$isi=array('kode_barang'=>$kode,'mulai'=>$value,'selesai'=>$selesai2[$key],'minimal_belanja'=>$belanja[$key],'harga'=>$harga[$key]);
							$this->model_crud->tambah_data('tb_tebusharga',$isi);
						}
					}
				}
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Data barang berhasil ditambahkan
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Data barang berhasil ditambahkan';
				$ikon='success';
			}
		} else {
			//update data
			$kunci=array('kode_barang'=>$id);
			$isi=array('kode_barang'=>$kode,'barcode'=>$barcode,'barcode2'=>$barcode2,'barcode3'=>$barcode3,'barang'=>$barang,'harga_beli'=>$beli,'id_kategori'=>$kategori,'stok_minimal'=>$minimal,'stok_maksimal'=>$pkm);
			$this->model_crud->update_data($kunci,'tb_barang',$isi);
			//tambahkan ke tabel satuan
			$kunci=array('kode_barang'=>$kode);
			$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
			$cek=$query->num_rows();
			if ($cek) {
				$isi=array('satuan1'=>$satuan1,'harga_jual1'=>$jual1,'harga_jual2'=>$jual2,'harga_jual3'=>$jual3,'satuan2'=>$satuan2,'konversi1'=>$konversi1,'harga_jual21'=>$jual21,'harga_jual22'=>$jual22,'harga_jual23'=>$jual23,'satuan3'=>$satuan3,'konversi2'=>$konversi2,'harga_jual31'=>$jual31,'harga_jual32'=>$jual32,'harga_jual33'=>$jual33);
				$this->model_crud->update_data($kunci,'tb_satuanbarang',$isi);
			} else {
				$isi=array('kode_barang'=>$kode,'satuan1'=>$satuan1,'harga_jual1'=>$jual1,'harga_jual2'=>$jual2,'harga_jual3'=>$jual3,'satuan2'=>$satuan2,'konversi1'=>$konversi1,'harga_jual21'=>$jual21,'harga_jual22'=>$jual22,'harga_jual23'=>$jual23,'satuan3'=>$satuan3,'konversi2'=>$konversi2,'harga_jual31'=>$jual31,'harga_jual32'=>$jual32,'harga_jual33'=>$jual33);
				$this->model_crud->tambah_data('tb_satuanbarang',$isi);
			}
			//tambahkan ke tabel potongan
			if ($mulai) {
				foreach ($mulai as $key => $value) {
					if ($idpot[$key]) {
						$kunci=array('id_potongan'=>$idpot[$key]);
						$isi=array('kode_barang'=>$kode,'mulai'=>$value,'selesai'=>$selesai[$key],'jumlah_beli'=>$jumlah[$key],'potongan'=>$potongan[$key],);
						$this->model_crud->update_data($kunci,'tb_potongan',$isi);
					} else {
						$isi=array('kode_barang'=>$kode,'mulai'=>$value,'selesai'=>$selesai[$key],'jumlah_beli'=>$jumlah[$key],'potongan'=>$potongan[$key]);
						$this->model_crud->tambah_data('tb_potongan',$isi);
					}
				}
			}
			//tambahkan ke tabel bonus
			if ($mulaibonus) {
				foreach ($mulaibonus as $key => $value) {
					if ($idbonus[$key]) {
						$kunci=array('id_bonus'=>$idbonus[$key]);
						$isi=array('kode_barang'=>$kode,'mulai'=>$value,'selesai'=>$selesaibonus[$key],'jumlah_beli'=>$jumbeli[$key],'bonus'=>$bonus[$key]);
						$this->model_crud->update_data($kunci,'tb_bonus',$isi);
					} else {
						$isi=array('kode_barang'=>$kode,'mulai'=>$value,'selesai'=>$selesaibonus[$key],'jumlah_beli'=>$jumbeli[$key],'bonus'=>$bonus[$key]);
						$this->model_crud->tambah_data('tb_bonus',$isi);
					}
				}
			}
			if ($mulai2) {
				foreach ($mulai2 as $key => $value) {
					if ($idtebus[$key]) {
						$kunci=array('id_tebusharga'=>$idtebus[$key]);
						$isi=array('kode_barang'=>$kode,'mulai'=>$value,'selesai'=>$selesai2[$key],'minimal_belanja'=>$belanja[$key],'harga'=>$harga[$key],'berlaku_untuk'=>$berlaku2[$key]);
						$this->model_crud->update_data($kunci,'tb_tebusharga',$isi);
					} else {
						$isi=array('kode_barang'=>$kode,'mulai'=>$value,'selesai'=>$selesai2[$key],'minimal_belanja'=>$belanja[$key],'harga'=>$harga[$key],'berlaku_untuk'=>$berlaku2[$key]);
						$this->model_crud->tambah_data('tb_tebusharga',$isi);
					}
				}
			}
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Data barang berhasil diubah
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Data barang berhasil diubah';
			$ikon='success';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function hapus_potongan() {
		$id=$this->input->post('id');
		$kunci=array('id_potongan'=>$id);
		$this->model_crud->hapus_data($kunci,'tb_potongan');
	}

	public function hapus_tebus() {
		$id=$this->input->post('id');
		$kunci=array('id_tebusharga'=>$id);
		$this->model_crud->hapus_data($kunci,'tb_tebusharga');
	}

	public function hapus_barang() {
		$id=$this->input->post('id');
		$kdhapus=$id.md5(date('YmdHis'));
		$kunci=array('kode_barang'=>$id);
		$isi=array('kode_barang'=>$kdhapus,'aktif'=>0);
		$this->model_crud->update_data($kunci,'tb_barang',$isi);
		$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
					Data barang berhasil dihapus
					<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>';
		$toas='Data barang berhasil dihapus';
		$ikon='warning';
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}
	
	public function singkron_barang() {
		$kunci=array('pengaturan'=>'link');
		$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
		$cek=$query->row();
		if ($cek) {
			$ling=$cek->isi;
		} else {
			$ling='';
		}

		$url=$ling;
		$ch=curl_init($url);
		/* Array Parameter Data */
		$dataurl=array('method'=>'barang');
		curl_setopt($ch,CURLOPT_POSTFIELDS,$dataurl);
		curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
		$result=curl_exec($ch);
		curl_close($ch);
		$databarang=json_decode($result);
		if ($databarang) {
			$this->db->query("UPDATE tb_barang SET aktif=0 WHERE aktif=1");
			//$this->db->query("UPDATE tb_barang SET barcode='-' WHERE barcode IN (SELECT barcode FROM tb_barang GROUP BY barcode HAVING count(barcode)>1)");
			foreach ($databarang as $hasil) {
			    //cek kategori barang
				$kunci=array('id_kategori'=>$hasil->id_kategori);
				$query=$this->model_crud->ambil_data($kunci,'tb_kategori');
				$ceker=$query->num_rows();
				if ($ceker==0) {
					$isi=array('id_kategori'=>$hasil->id_kategori,'kategori'=>$hasil->kategori,'aktif'=>1);
					$this->model_crud->tambah_data('tb_kategori',$isi);
				} else {
					$kunci=array('id_kategori'=>$hasil->id_kategori);
					$isi=array('kategori'=>$hasil->kategori,'aktif'=>1);
					$this->model_crud->update_data($kunci,'tb_kategori',$isi);
				}
				//tambah data
				$kunci=array('kode_barang'=>$hasil->kode_barang);
				$query=$this->model_crud->ambil_data($kunci,'tb_barang');
				$cek=$query->num_rows();
				if ($cek) {
					//update data barang
					$isi=array('barcode'=>$hasil->barcode,'barcode2'=>$hasil->barcode2,'barcode3'=>$hasil->barcode3,'barang'=>$hasil->barang,'harga_beli'=>$hasil->harga_toko,'id_kategori'=>$hasil->id_kategori,'aktif'=>$hasil->aktif);
					$this->model_crud->update_data($kunci,'tb_barang',$isi);
					//tambahkan ke tabel satuan
					$kunci=array('kode_barang'=>$hasil->kode_barang);
					$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
					$cek=$query->num_rows();
					if ($cek) {
						$isi=array('satuan1'=>$hasil->satuan1,'satuan2'=>$hasil->satuan2,'konversi1'=>$hasil->konversi1,'satuan3'=>$hasil->satuan3,'konversi2'=>$hasil->konversi2);
							$this->model_crud->update_data($kunci,'tb_satuanbarang',$isi);
					} else {
						$isi=array('kode_barang'=>$hasil->kode_barang,'satuan1'=>$hasil->satuan1,'satuan2'=>$hasil->satuan2,'konversi1'=>$hasil->konversi1,'satuan3'=>$hasil->satuan3,'konversi2'=>$hasil->konversi2);
							$this->model_crud->tambah_data('tb_satuanbarang',$isi);
					}
				} else {
					//baru tambahkan data
					$isi=array('kode_barang'=>$hasil->kode_barang,'barcode'=>$hasil->barcode,'barcode2'=>$hasil->barcode2,'barcode3'=>$hasil->barcode3,'barang'=>$hasil->barang,'harga_beli'=>$hasil->harga_beli,'id_kategori'=>$hasil->id_kategori,'aktif'=>$hasil->aktif);
					$this->model_crud->tambah_data('tb_barang',$isi);
					//tambahkan ke tabel satuan
					$kunci=array('kode_barang'=>$hasil->kode_barang);
					$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
					$cek=$query->num_rows();
					if ($cek) {
						$isi=array('satuan1'=>$hasil->satuan1,'satuan2'=>$hasil->satuan2,'konversi1'=>$hasil->konversi1,'satuan3'=>$hasil->satuan3,'konversi2'=>$hasil->konversi2);
							$this->model_crud->update_data($kunci,'tb_satuanbarang',$isi);
					} else {
						$isi=array('kode_barang'=>$hasil->kode_barang,'satuan1'=>$hasil->satuan1,'satuan2'=>$hasil->satuan2,'konversi1'=>$hasil->konversi1,'satuan3'=>$hasil->satuan3,'konversi2'=>$hasil->konversi2);
							$this->model_crud->tambah_data('tb_satuanbarang',$isi);
					}
				}
			}
			//ambil data barang non aktif
			$kunci=array('aktif'=>0);
			$query=$this->model_crud->ambil_data($kunci,'tb_barang');
			$databarang=$query->result();
			$no=1;
			foreach ($databarang as $hasil) {
			    $kdhapus=$hasil->kode_barang.md5(date('YmdHis').$no);
	            $kunci=array('kode_barang'=>$hasil->kode_barang);
                $isi=array('kode_barang'=>$kdhapus,'aktif'=>0);
                $this->model_crud->update_data($kunci,'tb_barang',$isi);
		        $no++;
			}
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Data barang berhasil disingkron dengan DC!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Data barang berhasil disingkron dengan DC!';
			$ikon='success';
		} else {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Gagal melakukan singkronisasi baran dengan DC!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Gagal melakukan singkronisasi baran dengan DC!';
			$ikon='error';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function xls_barang() {
		$kunci=array('1'=>'1');
		$query=$this->model_crud->ambil_data($kunci,'tb_barang');
		$data['databarang']=$query->result();
		$this->load->view('master/xls_barang',$data);
	}

	public function edit_barang() {
		$data['title']='Edit Barang';
		$this->load->view('master/edit_barang',$data);
	}

	public function dataeditbarang() {
		//ambil data kategori
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_kategori');
		$datakategori=$query->result();
		//ambil data suplier
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_suplier');
		$datasuplier=$query->result();

		$req=$_REQUEST;
		$total=$this->model_master->dataeditbarang($req,'jumlah');
		$datatab=$this->model_master->dataeditbarang($req,'data');
		$isinya=array();
		$i=1;
		foreach ($datatab as $hasil) {
			$op='';
			foreach ($datakategori as $hasil2) {
				if ($hasil->id_kategori==$hasil2->id_kategori) {
					$selected='selected';
				} else {
					$selected='';
				}
				$op.='<option value="'.$hasil2->id_kategori.'" '.$selected.'>'.$hasil2->kategori.'</option>';
			}
			//ambil data suplier
			$kunci=array('kode_barang'=>$hasil->kode_barang);
			$query=$this->model_crud->ambil_data($kunci,'tb_supliermeta');
			$cek=$query->row();
			if ($cek) {
				$sup=$cek->kode_suplier;
			} else {
				$sup='';
			}
			$os='<option value="">-- pilih suplier --</option>';
			foreach ($datasuplier as $hasil2) {
				if ($sup==$hasil2->kode_suplier) {
					$selected='selected';
				} else {
					$selected='';
				}
				$os.='<option value="'.$hasil2->kode_suplier.'" '.$selected.'>'.$hasil2->suplier.'</option>';
			}
			$datanya=array();
			$datanya[]=$hasil->kode_barang.'<input type="hidden" name="kode'.$i.'" id="kode'.$i.'" value="'.$hasil->kode_barang.'">';
			$datanya[]=$hasil->barcode;
			$datanya[]=$hasil->barang;
			$datanya[]='<select class="form-control" name="kategori'.$i.'" id="kategori'.$i.'" onchange="simpan('.$i.')">'.$op.'</select>';
			$datanya[]='<input type="text" class="form-control" name="satuan'.$i.'" id="satuan'.$i.'" value="'.$hasil->satuan1.'" onkeyup="simpan('.$i.')">';
			$datanya[]='<input type="text" class="form-control" name="beli'.$i.'" id="beli'.$i.'" value="'.$hasil->harga_beli.'" onkeyup="simpan('.$i.')">';
			$datanya[]='<input type="text" class="form-control" name="jual'.$i.'" id="jual'.$i.'" value="'.$hasil->harga_jual1.'" onkeyup="simpan('.$i.')">';
			$datanya[]='<input type="text" class="form-control" name="jual2'.$i.'" id="jual2'.$i.'" value="'.$hasil->harga_jual2.'" onkeyup="simpan('.$i.')">';
			$datanya[]='<input type="text" class="form-control" name="jual3'.$i.'" id="jual3'.$i.'" value="'.$hasil->harga_jual3.'" onkeyup="simpan('.$i.')">';
			$datanya[]='<input type="number" class="form-control" name="minim'.$i.'" id="minim'.$i.'" value="'.$hasil->stok_minimal.'" onkeyup="simpan('.$i.')">';
			$datanya[]='<input type="number" class="form-control" name="maksimal'.$i.'" id="maksimal'.$i.'" value="'.$hasil->stok_maksimal.'" onkeyup="simpan('.$i.')">';
			$datanya[]='<select class="form-control" name="suplier'.$i.'" id="suplier'.$i.'" onchange="simpan('.$i.')">'.$os.'</select>';
			$isinya[]=$datanya;
			$i++;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function simpan_editbarang() {
		$kode=$this->input->post('kode');
		$kategori=$this->input->post('kategori');
		$beli=$this->input->post('beli');
		$satuan=$this->input->post('satuan');
		$jual=$this->input->post('jual');
		$jual2=$this->input->post('jual2');
		$jual3=$this->input->post('jual3');
		$minim=$this->input->post('minim');
		$maksimal=$this->input->post('maksimal');
		$suplier=$this->input->post('suplier');
		$kunci=array('kode_barang'=>$kode);
		$isi=array('kode_barang'=>$kode,'harga_beli'=>$beli,'id_kategori'=>$kategori,'stok_minimal'=>$minim,'stok_maksimal'=>$maksimal);
		$this->model_crud->update_data($kunci,'tb_barang',$isi);
		//simpan satuan dan harga jual
		$isi=array('satuan1'=>$satuan,'harga_jual1'=>$jual,'harga_jual2'=>$jual2,'harga_jual3'=>$jual3);
		$this->model_crud->update_data($kunci,'tb_satuanbarang',$isi);
		//edit data suplier
		if ($suplier) {
			$kunci=array('kode_barang'=>$kode);
			$query=$this->model_crud->ambil_data($kunci,'tb_supliermeta');
			$cek=$query->num_rows();
			if ($cek) {
				$isi=array('kode_suplier'=>$suplier);
				$this->model_crud->update_data($kunci,'tb_supliermeta',$isi);
			} else {
				$isi=array('kode_barang'=>$kode,'kode_suplier'=>$suplier);
				$this->model_crud->tambah_data('tb_supliermeta',$isi);
			}
		} else {
			$kunci=array('kode_barang'=>$kode);
			$this->model_crud->hapus_data($kunci,'tb_supliermeta');
		}
	}

	public function ajax_riwayatstok() {
		$kode=$this->input->post('kode');
		$awal=$this->input->post('awal');
		$akhir=$this->input->post('akhir');
		//mari kita ambil datanya
		$urut=array('tanggal'=>'ASC');
		$kunci['kode_barang']=$kode;
        if ($awal) {
			$kunci["DATE_FORMAT(tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tanggal,'%Y-%m-%d')<="]=$akhir;
		}
		$query=$this->model_crud->ambil_data($kunci,'tb_kartustok',$urut);
		$datakartu=$query->result();
		$data['datakartu']=$datakartu;
		$this->load->view('master/ajax_riwayatstok',$data);
	}

	public function suplier() {
		$data['title']='Suplier';
		$data['template']='master/view_suplier';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datasuplier() {
		$req=$_REQUEST;
		$total=$this->model_master->datasuplier($req,'jumlah');
		$datatab=$this->model_master->datasuplier($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=$hasil->kode_suplier;
			$datanya[]=$hasil->suplier;
			$datanya[]=$hasil->telepon;
			$datanya[]=$hasil->alamat;
			$datanya[]='<a href="'.base_url('master/barangsuplier?id='.$hasil->kode_suplier).'" class="btn btn-warning btn-xs" title="Daftar barang"><i class="fa fa-box"></i></a>';
			$datanya[]='<button type="button" class="btn btn-info btn-xs" title="Edit" onclick="tampilform(this.value)" value="'.$hasil->kode_suplier.'"><i class="fa fa-edit"></i></button>';
			$datanya[]='<button type="button" title="Hapus" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->kode_suplier.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_suplier() {
		$id=$this->input->post('id');
		$data['aksi']='Simpan';
		$kunci=array('kode_suplier'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_suplier');
		$cek=$query->row();
		if ($cek) {
			$data['kode']=$cek->kode_suplier;
			$data['suplier']=$cek->suplier;
			$data['telepon']=$cek->telepon;
			$data['alamat']=$cek->alamat;
			$data['aksi']='Ubah';
		}
		$data['title']='Form Suplier';
		$this->load->view('master/form_suplier',$data);
	}

	public function simpan_suplier() {
		$kode=$this->input->post('kode');
		$suplier=$this->input->post('suplier');
		$telepon=$this->input->post('telepon');
		$alamat=$this->input->post('alamat');
		$id=$this->input->post('id');
		$aksi=$this->input->post('aksi');
		if ($aksi=='Simpan') {
			//tambah data
			$kunci=array('kode_suplier'=>$kode);
			$query=$this->model_crud->ambil_data($kunci,'tb_suplier');
			$cek=$query->num_rows();
			if ($cek) {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Kode suplier sudah ada!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Kode suplier sudah ada!';
				$ikon='error';
			} else {
				//baru tambahkan data
				$isi=array('suplier'=>$suplier,'kode_suplier'=>$kode,'telepon'=>$telepon,'alamat'=>$alamat,'aktif'=>1);
				$this->model_crud->tambah_data('tb_suplier',$isi);
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Suplier berhasil ditambahkan
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Suplier berhasil ditambahkan';
				$ikon='success';
			}
		} else {
			//update data
			$kunci=array('kode_suplier'=>$id);
			$isi=array('suplier'=>$suplier,'kode_suplier'=>$kode,'telepon'=>$telepon,'alamat'=>$alamat);
			$this->model_crud->update_data($kunci,'tb_suplier',$isi);
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Suplier berhasil diubah
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Suplier berhasil diubah';
			$ikon='success';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function hapus_suplier() {
		$id=$this->input->post('id');
		$kdhapus=$id.md5(date('YmdHis'));
		$kunci=array('kode_suplier'=>$id);
		$isi=array('kode_suplier'=>$kdhapus,'aktif'=>0);
		$this->model_crud->update_data($kunci,'tb_suplier',$isi);
		$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
					Suplier berhasil dihapus
					<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>';
		$toas='Suplier berhasil dihapus';
		$ikon='warning';
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function barangsuplier() {
		$id=$this->input->get('id');
		//ambil data suplier
		$kunci=array('kode_suplier'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_suplier');
		$cek=$query->row();
		if ($cek) {
			$data['suplier']=$cek->suplier;
			$data['kode']=$cek->kode_suplier;
			$data['title']='Barang Suplier';
			$data['template']='master/view_barangsuplier';
			$data['footer']='layout/footer';
			$data['footerend']='layout/footerend';
			$this->load->view('layout/wrapper',$data);
		} else {
			redirect('master/suplier');
		}
	}

	public function ajax_barangsuplier() {
		$suplier=$this->input->post('suplier');
		$kunci=array('tb_supliermeta.kode_suplier'=>$suplier);
		$query=$this->model_master->databarangsuplier($kunci);
		$data['databarang']=$query->result();
		$this->load->view('master/ajax_barangsuplier',$data);
	}

	public function simpan_barangsuplier() {
		$kode=$this->input->post('kode');
		$suplier=$this->input->post('suplier');
		//cek kode barang
		$kunci=array('kode_barang'=>$kode,'aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_barang');
		$cek=$query->row();
		if ($cek) {
			$kode=$cek->kode_barang;
		} else {
			$kunci=array('barcode'=>$kode,'aktif'=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_barang');
			$cek=$query->row();
			if ($cek) {
				$kode=$cek->kode_barang;
			} else {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Data barang tidak ditemukan!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Data barang tidak ditemukan!';
				$ikon='error';
				$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
				echo json_encode($arr);
				die();
			}
		}
		//cek apakah barang sudah diinputkan
		$kunci=array('kode_barang'=>$kode,'kode_suplier'=>$suplier);
		$query=$this->model_crud->ambil_data($kunci,'tb_supliermeta');
		$cek=$query->row();
		if ($cek) {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Barang sudah dimasukan ke data suplier!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Barang sudah dimasukan ke data suplier!';
			$ikon='error';
			$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
			echo json_encode($arr);
		} else {
			$isi=array('kode_barang'=>$kode,'kode_suplier'=>$suplier);
			$this->model_crud->tambah_data('tb_supliermeta',$isi);
			$pesan='';
			$toas='Barang berhasil ditambahkan ke data suplier!';
			$ikon='success';
			$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
			echo json_encode($arr);
		}
	}

	public function hapus_barangsuplier() {
		$id=$this->input->post('id');
		$kunci=array('id_supliermeta'=>$id);
		$this->model_crud->hapus_data($kunci,'tb_supliermeta');
		$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
					Barang berhasil dihapus dari data suplier
					<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>';
		$toas='Barang berhasil dihapus dari data suplier';
		$ikon='warning';
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}


	public function toko() {
		$data['title']='Toko';
		$data['template']='master/view_toko';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datatoko() {
		$req=$_REQUEST;
		$total=$this->model_master->datatoko($req,'jumlah');
		$datatab=$this->model_master->datatoko($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=$hasil->kode_toko;
			$datanya[]=$hasil->toko;
			$datanya[]=$hasil->telepon;
			$datanya[]=$hasil->alamat;
			$datanya[]='<button type="button" class="btn btn-info btn-xs" title="Edit" onclick="tampilform(this.value)" value="'.$hasil->kode_toko.'"><i class="fa fa-edit"></i></button>';
			$datanya[]='<button type="button" title="Hapus" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->kode_toko.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_toko() {
		$id=$this->input->post('id');
		$data['aksi']='Simpan';
		$kunci=array('kode_toko'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_toko');
		$cek=$query->row();
		if ($cek) {
			$data['kode']=$cek->kode_toko;
			$data['toko']=$cek->toko;
			$data['telepon']=$cek->telepon;
			$data['alamat']=$cek->alamat;
			$data['aksi']='Ubah';
		}
		$data['title']='Form Toko';
		$this->load->view('master/form_toko',$data);
	}

	public function simpan_toko() {
		$kode=$this->input->post('kode');
		$toko=$this->input->post('toko');
		$telepon=$this->input->post('telepon');
		$alamat=$this->input->post('alamat');
		$id=$this->input->post('id');
		$aksi=$this->input->post('aksi');
		if ($aksi=='Simpan') {
			//tambah data
			$kunci=array('kode_toko'=>$kode);
			$query=$this->model_crud->ambil_data($kunci,'tb_toko');
			$cek=$query->num_rows();
			if ($cek) {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Kode toko sudah ada!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Kode toko sudah ada!';
				$ikon='error';
			} else {
				//baru tambahkan data
				$isi=array('toko'=>$toko,'kode_toko'=>$kode,'telepon'=>$telepon,'alamat'=>$alamat,'aktif'=>1);
				$this->model_crud->tambah_data('tb_toko',$isi);
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Cabang toko berhasil ditambahkan
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Cabang toko berhasil ditambahkan';
				$ikon='success';
			}
		} else {
			//update data
			$kunci=array('kode_toko'=>$id);
			$isi=array('toko'=>$toko,'kode_toko'=>$kode,'telepon'=>$telepon,'alamat'=>$alamat);
			$this->model_crud->update_data($kunci,'tb_toko',$isi);
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Cabang toko berhasil diubah
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Cabang toko berhasil diubah';
			$ikon='success';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function hapus_toko() {
		$id=$this->input->post('id');
		$kdhapus=$id.md5('YmdHis');
		$kunci=array('kode_toko'=>$id);
		$isi=array('kode_toko'=>$kdhapus,'aktif'=>0);
		$this->model_crud->update_data($kunci,'tb_toko',$isi);
		$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
					Cabang toko berhasil dihapus
					<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>';
		$toas='Cabang toko berhasil dihapus';
		$ikon='warning';
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}
	
	public function rak() {
		$data['title']='Rak';
		$data['template']='master/view_rak';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datarak() {
		$req=$_REQUEST;
		$total=$this->model_master->datarak($req,'jumlah');
		$datatab=$this->model_master->datarak($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=$hasil->rak;
			$datanya[]='<a href="'.base_url('master/barangrak?id='.$hasil->id_rak).'" class="btn btn-warning btn-xs" title="Daftar barang"><i class="fa fa-box"></i></a>';
			$datanya[]='<button type="button" class="btn btn-info btn-xs" title="Edit" onclick="tampilform(this.value)" value="'.$hasil->id_rak.'"><i class="fa fa-edit"></i></button>';
			$datanya[]='<button type="button" title="Hapus" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->id_rak.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_rak() {
		$id=$this->input->post('id');
		$data['aksi']='Simpan';
		$kunci=array('id_rak'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_rak');
		$cek=$query->row();
		if ($cek) {
			$data['rak']=$cek->rak;
			$data['id']=$cek->id_rak;
			$data['aksi']='Ubah';
		}
		$data['title']='Form Rak';
		$this->load->view('master/form_rak',$data);
	}

	public function simpan_rak() {
		$rak=$this->input->post('rak');
		$id=$this->input->post('id');
		$aksi=$this->input->post('aksi');
		if ($aksi=='Simpan') {
			//tambah data
			$kunci=array('rak'=>$rak);
			$query=$this->model_crud->ambil_data($kunci,'tb_rak');
			$cek=$query->num_rows();
			if ($cek) {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Nama rak sudah ada!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Nama rak sudah ada!';
				$ikon='error';
			} else {
				//baru tambahkan data
				$isi=array('rak'=>$rak);
				$this->model_crud->tambah_data('tb_rak',$isi);
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Rak berhasil ditambahkan
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Rak berhasil ditambahkan';
				$ikon='success';
			}
		} else {
			//update data
			$kunci=array('id_rak'=>$id);
			$isi=array('rak'=>$rak);
			$this->model_crud->update_data($kunci,'tb_rak',$isi);
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Rak berhasil diubah
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Rak berhasil diubah';
			$ikon='success';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function hapus_rak() {
		$id=$this->input->post('id');
		$kunci=array('id_rak'=>$id);
		$this->model_crud->hapus_data($kunci,'tb_rak');
		$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
					Rak berhasil diubah
					<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>';
		$toas='Rak berhasil diubah';
		$ikon='warning';
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function barangrak() {
		$id=$this->input->get('id');
		//ambil data rak
		$kunci=array('id_rak'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_rak');
		$cek=$query->row();
		if ($cek) {
			$data['rak']=$cek->rak;
			$data['id']=$cek->id_rak;
			$data['title']='Barang Rak';
			$data['template']='master/view_barangrak';
			$data['footer']='layout/footer';
			$data['footerend']='layout/footerend';
			$this->load->view('layout/wrapper',$data);
		} else {
			redirect('master/suplier');
		}
	}

	public function ajax_barangrak() {
		$rak=$this->input->post('rak');
		$kunci=array('tb_rakmeta.id_rak'=>$rak);
		$query=$this->model_master->databarangrak($kunci);
		$data['databarang']=$query->result();
		$this->load->view('master/ajax_barangrak',$data);
	}

	public function simpan_barangrak() {
		$kode=$this->input->post('kode');
		$rak=$this->input->post('rak');
		//cek kode barang
		$kunci=array('kode_barang'=>$kode,'aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_barang');
		$cek=$query->row();
		if ($cek) {
			$kode=$cek->kode_barang;
		} else {
			$kunci=array('barcode'=>$kode,'aktif'=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_barang');
			$cek=$query->row();
			if ($cek) {
				$kode=$cek->kode_barang;
			} else {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Nama barang tidak ditemukan!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Nama barang tidak ditemukan!';
				$ikon='error';
				$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
				echo json_encode($arr);
				die();
			}
		}
		//cek apakah barang sudah diinputkan
		$kunci=array('kode_barang'=>$kode,'id_rak'=>$rak);
		$query=$this->model_crud->ambil_data($kunci,'tb_rakmeta');
		$cek=$query->row();
		if ($cek) {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Nama barang sudah diinputkan ke rak sebelumnya!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Nama barang sudah diinputkan ke rak sebelumnya!';
			$ikon='error';
			$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
			echo json_encode($arr);
		} else {
			$isi=array('kode_barang'=>$kode,'id_rak'=>$rak);
			$this->model_crud->tambah_data('tb_rakmeta',$isi);
			$pesan='';
			$toas='Nama barang berhasil diinputkan ke rak';
			$ikon='success';
			$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
			echo json_encode($arr);
		}
	}

	public function hapus_barangrak() {
		$id=$this->input->post('id');
		$kunci=array('id_rakmeta'=>$id);
		$this->model_crud->hapus_data($kunci,'tb_rakmeta');
		$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
					Barang berhasil dihapus dari rak
					<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>';
		$toas='Barang berhasil dihapus dari rak';
		$ikon='warning';
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function nontunai() {
		$data['title']='Pembayaran Non Tunai';
		$data['template']='master/view_nontunai';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datanontunai() {
		$req=$_REQUEST;
		$total=$this->model_master->datanontunai($req,'jumlah');
		$datatab=$this->model_master->datanontunai($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=$hasil->nontunai;
			$datanya[]='<button type="button" class="btn btn-info btn-xs" title="Edit" onclick="tampilform(this.value)" value="'.$hasil->id_nontunai.'"><i class="fa fa-edit"></i></button>';
			$datanya[]='<button type="button" title="Hapus" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->id_nontunai.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_nontunai() {
		$id=$this->input->post('id');
		$data['aksi']='Simpan';
		$kunci=array('id_nontunai'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_nontunai');
		$cek=$query->row();
		if ($cek) {
			$data['nontunai']=$cek->nontunai;
			$data['id']=$cek->id_nontunai;
			$data['aksi']='Ubah';
		}
		$data['title']='Form Pembayaran Non Tunai';
		$this->load->view('master/form_nontunai',$data);
	}

	public function simpan_nontunai() {
		$nontunai=$this->input->post('nontunai');
		$id=$this->input->post('id');
		$aksi=$this->input->post('aksi');
		if ($aksi=='Simpan') {
			//tambah data
			$kunci=array('nontunai'=>$nontunai);
			$query=$this->model_crud->ambil_data($kunci,'tb_nontunai');
			$cek=$query->num_rows();
			if ($cek) {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Nama pembayaran non tunai sudah ada!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Nama pembayaran non tunai sudah ada!';
				$ikon='error';
			} else {
				//baru tambahkan data
				$isi=array('nontunai'=>$nontunai);
				$this->model_crud->tambah_data('tb_nontunai',$isi);
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Nama pembayaran non tunai berhasil ditambahkan
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Nama pembayaran non tunai berhasil ditambahkan';
				$ikon='success';
			}
		} else {
			//update data
			$kunci=array('id_nontunai'=>$id);
			$isi=array('nontunai'=>$nontunai);
			$this->model_crud->update_data($kunci,'tb_nontunai',$isi);
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Nama pembayaran non tunai berhasil diubah
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Nama pembayaran non tunai berhasil diubah';
			$ikon='success';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function hapus_nontunai() {
		$id=$this->input->post('id');
		$kunci=array('id_nontunai'=>$id);
		$this->model_crud->hapus_data($kunci,'tb_nontunai');
		$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
					Metode pembayaran non tunai berhasil dihapus
					<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>';
		$toas='Metode pembayaran non tunai berhasil dihapus';
		$ikon='warning';
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function member() {
		$data['title']='Member';
		$data['template']='master/view_member';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function	datamember() {
		$req=$_REQUEST;
		$total=$this->model_master->datamember($req,'jumlah');
		$datatab=$this->model_master->datamember($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=date('d-m-Y',strtotime($hasil->tanggal));
			$datanya[]=$hasil->kode_member;
			$datanya[]=$hasil->member;
			$datanya[]=$hasil->jekel;
			$datanya[]=$hasil->telepon;
			$datanya[]=$hasil->poin;
			$datanya[]=$hasil->koin;
			$datanya[]='<button class="btn btn-xs btn-info" value="'.$hasil->kode_member.'" onclick="tampilform(this.value)"><i class="fa fa-edit"></i></button>';
			$datanya[]='<button type="button" title="Hapus" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->kode_member.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_member() {
		$id=$this->input->post('id');
		$data['aksi']='Simpan';
		$kunci=array('kode_member'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_member');
		$cek=$query->row();
		if ($cek) {
			$data['kode']=$cek->kode_member;
			$data['member']=$cek->member;
			$data['jekel']=$cek->jekel;
			$data['tempat']=$cek->tempat_lahir;
			$data['tgl']=$cek->tgl_lahir;
			$data['telepon']=$cek->telepon;
			$data['email']=$cek->email;
			$data['alamat']=$cek->alamat;
			$data['jual']=$cek->berlaku_jual;
			$data['poin']=$cek->berlaku_poin;
			$data['aksi']='Ubah';
		}
		$data['title']='Form Member';
		$this->load->view('master/form_member',$data);
	}

	public function simpan_member() {
		if ($this->input->post('kode')) {
			$kode=$this->input->post('kode');
		} else {
			$kode=$this->kodemember();
		}
		$member=$this->input->post('member');
		$jekel=$this->input->post('jekel');
		$tgl=$this->input->post('tgl');
		$tempat=$this->input->post('tempat');
		$telepon=$this->input->post('telepon');
		$email=$this->input->post('email');
		$alamat=$this->input->post('alamat');
		$jual=$this->input->post('jual');
		$poin=$this->input->post('poin');
		$id=$this->input->post('id');
		$aksi=$this->input->post('aksi');
		if ($aksi=='Simpan') {
			//tambah data
			$kunci=array('kode_member'=>$kode,'aktif'=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_member');
			$cek=$query->num_rows();
			if ($cek) {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Kode member sudah ada!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Kode member sudah ada!';
				$ikon='error';
			} else {
				//baru tambahkan data
				$isi=array('kode_member'=>$kode,'member'=>$member,'jekel'=>$jekel,'tempat_lahir'=>$tempat,'tgl_lahir'=>$tgl,'email'=>$email,'telepon'=>$telepon,'alamat'=>$alamat,'berlaku_jual'=>$jual,'berlaku_poin'=>$poin,'aktif'=>1);
				$this->model_crud->tambah_data('tb_member',$isi);
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Member berhasil ditambahkan
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Member berhasil ditambahkan';
				$ikon='success';
			}
		} else {
			//update data
			$kunci=array('kode_member'=>$id);
			$isi=array('kode_member'=>$kode,'member'=>$member,'jekel'=>$jekel,'tempat_lahir'=>$tempat,'tgl_lahir'=>$tgl,'email'=>$email,'telepon'=>$telepon,'alamat'=>$alamat,'berlaku_jual'=>$jual,'berlaku_poin'=>$poin,'aktif'=>1);
			$this->model_crud->update_data($kunci,'tb_member',$isi);
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Member berhasil diubah
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Member berhasil diubah';
			$ikon='success';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function hapus_member() {
		$id=$this->input->post('id');
		$kdhapus=$id.md5('YmdHis');
		$kunci=array('kode_member'=>$id);
		$isi=array('kode_member'=>$kdhapus,'aktif'=>0);
		$this->model_crud->update_data($kunci,'tb_member',$isi);
		$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
					Member berhasil dihapus
					<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>';
		$toas='Member berhasil dihapus';
		$ikon='warning';
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function kodemember() {
		$bulan=date('Y-m');
		$kunci=array("DATE_FORMAT(tanggal,'%Y-%m')"=>$bulan);
		$urut=array('tanggal'=>'DESC');
		$query=$this->model_crud->ambil_data($kunci,'tb_member',$urut);
		$cek=$query->row();
		if ($cek) {
			$pecahno=explode('-',$cek->kode_member);
			$nomor=@$pecahno[1];
			if ($nomor) {
				$nourut=(int)$nomor+1;
			} else {
				$nourut=1;
			}
			if ($nourut<100) {
				$nourut='00'.$nourut;
			} else {
				$nourut=$nourut;
			}
			$kode=date('Ym').'-'.$nourut;
		} else {
			$kode=date('Ym').'-001';
		}
		return $kode;
	}

	public function pegawai() {
		$data['title']='Pegawai';
		$data['template']='master/view_pegawai';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datapegawai() {
		$req=$_REQUEST;
		$total=$this->model_master->datapegawai($req,'jumlah');
		$datatab=$this->model_master->datapegawai($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=$hasil->kode_pegawai;
			$datanya[]=$hasil->pegawai;
			$datanya[]=$hasil->jekel;
			$datanya[]=$hasil->telepon;
			$datanya[]=$hasil->level;
			$datanya[]='<button type="button" class="btn btn-info btn-xs" title="Edit" onclick="tampilform(this.value)" value="'.$hasil->kode_pegawai.'"><i class="fa fa-edit"></i></button>';
			$datanya[]='<button type="button" title="Hapus" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->kode_pegawai.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_pegawai() {
		$id=$this->input->post('id');
		$this->load->library('encryption');
		$data['aksi']='Simpan';
		$kunci=array('kode_pegawai'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_pegawai');
		$cek=$query->row();
		if ($cek) {
			$data['kode']=$cek->kode_pegawai;
			$data['pegawai']=$cek->pegawai;
			$data['jekel']=$cek->jekel;
			$data['email']=$cek->email;
			$data['telepon']=$cek->telepon;
			$data['alamat']=$cek->alamat;
			$data['level']=$cek->level;
			$data['password']=$this->encryption->decrypt($cek->password);
			$data['aksi']='Ubah';
		}
		$data['title']='Form Pegawai';
		$this->load->view('master/form_pegawai',$data);
	}

	public function simpan_pegawai() {
		$this->load->library('encryption');
		$kode=$this->input->post('kode');
		$pegawai=$this->input->post('pegawai');
		$jekel=$this->input->post('jekel');
		$telepon=$this->input->post('telepon');
		$email=$this->input->post('email');
		$alamat=$this->input->post('alamat');
		$level=$this->input->post('level');
		$password=$this->encryption->encrypt($this->input->post('password'));
		$id=$this->input->post('id');
		$aksi=$this->input->post('aksi');
		if ($aksi=='Simpan') {
			//tambah data
			$kunci=array('kode_pegawai'=>$kode,'aktif'=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_pegawai');
			$cek=$query->num_rows();
			if ($cek) {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Kode pegawai sudah ada!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Kode pegawai sudah ada!';
				$ikon='error';
			} else {
				//baru tambahkan data
				$isi=array('kode_pegawai'=>$kode,'pegawai'=>$pegawai,'jekel'=>$jekel,'email'=>$email,'telepon'=>$telepon,'alamat'=>$alamat,'level'=>$level,'password'=>$password,'aktif'=>1);
				$this->model_crud->tambah_data('tb_pegawai',$isi);
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Pegawai berhasil ditambahkan
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Pegawai berhasil ditambahkan';
				$ikon='success';
			}
		} else {
			//update data
			$kunci=array('kode_pegawai'=>$id);
			$isi=array('kode_pegawai'=>$kode,'pegawai'=>$pegawai,'jekel'=>$jekel,'email'=>$email,'telepon'=>$telepon,'alamat'=>$alamat,'level'=>$level,'password'=>$password);
			$this->model_crud->update_data($kunci,'tb_pegawai',$isi);
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Pegawai berhasil diubah
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Pegawai berhasil diubah';
			$ikon='success';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function hapus_pegawai() {
		$kp=$this->session->userdata('kp');
		$id=$this->input->post('id');
		if ($id==$kp) {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Pengguna sistem sedang login!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Pengguna sistem sedang login!';
			$ikon='error';
		} else {
			$kdhapus=$id.md5(date('YmdHis'));
			$kunci=array('kode_pegawai'=>$id);
			$isi=array('kode_pegawai'=>$kdhapus,'aktif'=>0);
			$this->model_crud->update_data($kunci,'tb_pegawai',$isi);
			$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
						Pegawai berhasil dihapus
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Pegawai berhasil dihapus';
			$ikon='warning';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function label() {
		$data['title']='Cetak Label Barang';
		$data['template']='master/view_label';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datalabel() {
		$req=$_REQUEST;
		$total=$this->model_master->datalabel($req,'jumlah');
		$datatab=$this->model_master->datalabel($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=date('d-m-Y',strtotime($hasil->tanggal));
			$datanya[]=$hasil->jumlah_barang;
			$datanya[]=$hasil->pegawai;
			$datanya[]='<a href="'.base_url('master/form_label?id='.$hasil->id_label).'" class="btn btn-info btn-xs" title="Edit" ><i class="fa fa-edit"></i></a>';
			$datanya[]='<a href="'.base_url('master/cetak_label?id='.$hasil->id_label).'" target="_blank" class="btn btn-secondary btn-xs" title="Edit" ><i class="fa fa-print"></i></a>';
			$datanya[]='<button title="Hapus" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->id_label.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_label() {
		$kp=$this->session->userdata('kp');
		$id=$this->input->get('id');
		$tgl=date('Y-m-d');
		$kunci=array('tanggal'=>$tgl,'kode_pegawai'=>$kp);
		$query=$this->model_crud->ambil_data($kunci,'tb_label');
		$cek=$query->num_rows();
		if ($cek==0) {
			$isi=array('tanggal'=>$tgl,'kode_pegawai'=>$kp);
			$this->model_crud->tambah_data('tb_label',$isi);
		}
		$data['id']=$id;
		$data['title']='Form Cetak Label Barang';
		$data['template']='master/form_label';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function simpan_label() {
		$kp=$this->session->userdata('kp');
		$id=$this->input->get('id');
		$kode=$this->input->post('kode');
		$harga=$this->input->post('harga');
		$jumlah=$this->input->post('jumlah');
		$tgl=date('Y-m-d');
		//cari id label dulu
		if ($id) {
			$idlabel=$id;
		} else {
			$kunci=array('tanggal'=>$tgl,'kode_pegawai'=>$kp);
			$query=$this->model_crud->ambil_data($kunci,'tb_label');
			$cek=$query->row();
			if ($cek) {
				$idlabel=$cek->id_label;
			} else {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Data label barang tidak tersedia!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Data label barang tidak tersedia!';
				$ikon='error';
				$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
				echo json_encode($arr);
				die();
			}
		}
		//ambil kode barang
		$kunci=array('kode_barang'=>$kode,'aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_barang');
		$cek=$query->row();
		if ($cek) {
			$kode=$cek->kode_barang;
		} else {
			$kunci=array('barcode'=>$kode,'aktif'=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_barang');
			$cek=$query->row();
			if ($cek) {
				$kode=$cek->kode_barang;
			} else {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Data barang tidak ditemukan!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Data barang tidak ditemukan!';
				$ikon='error';
				$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
				echo json_encode($arr);
				die();
			}
		}
		//input label barang meta
		//cek potongan umum dulu
		$this->db->select('potongan,jumlah_beli,selesai');
		$this->db->from('tb_potongan');
		$this->db->where('kode_barang',$kode);
		$this->db->where('jumlah_beli',1);
		$this->db->group_start();
		$this->db->where('mulai<=',$tgl);
		$this->db->where('selesai>=',$tgl);
		$this->db->group_end();
		$this->db->group_start();
		$this->db->where('berlaku_untuk','semua');
		$this->db->or_where('berlaku_untuk','umum');
		$this->db->or_where('berlaku_untuk','');
		$this->db->group_end();
		$query=$this->db->get();
		$cek=$query->row();
		if ($cek) {
			$potongan=$cek->potongan;
			$selesai=$cek->selesai;
		} else {
			$potongan=0;
		}
		//cari harga jual
		$kunci=array('kode_barang'=>$kode);
		$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
		$cek=$query->row();
		if ($cek) {
			if ($harga=='h3') {
				$hargajual=$cek->harga_jual31;
				$satuan=$cek->satuan3;
			} else if ($harga=='h2') {
				$hargajual=$cek->harga_jual21;
				$satuan=$cek->satuan2;
			} else {
				$hargajual=$cek->harga_jual1;
				$satuan=$cek->satuan1;
			}
		} else {
			echo '<div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
					Data barang tidak tersedia!
					<button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
				</div>';
			die();
		}
		if ($potongan) {
			$hargadiskon=$hargajual-$potongan;
		} else {
			$hargadiskon=0;
		}
		//masukan ke tabel label meta
		$isi=array('id_label'=>$idlabel,'kode_barang'=>$kode,'harga_jual'=>$hargajual,'harga_diskon'=>$hargadiskon,'jumlah_cetak'=>$jumlah,'satuan'=>$satuan,'tgl_akhirdiskon'=>@$selesai);
		$this->model_crud->tambah_data('tb_labelmeta',$isi);
		$pesan='';
		$toas='';
		$ikon='';
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}
	
	public function hapus_label() {
		$id=$this->input->post('id');
		$kunci=array('id_label'=>$id);
		$this->model_crud->hapus_data($kunci,'tb_label');
		$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
					Label barang berhasil dihapus
					<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>';
		$toas='Label barang berhasil dihapus';
		$ikon='warning';
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function datalabeldetail() {
		$id=$this->input->get('id');
		$req=$_REQUEST;
		$total=$this->model_master->datalabeldetail($req,'jumlah',$id);
		$datatab=$this->model_master->datalabeldetail($req,'data',$id);
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=$hasil->kode_barang;
			$datanya[]=$hasil->barang;
			$datanya[]=$hasil->harga_jual;
			$datanya[]=$hasil->harga_diskon;
			$datanya[]=$hasil->jumlah_cetak;
			$datanya[]='<button type="button" title="Hapus" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->id_labelmeta.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function hapus_labelbarang() {
		$id=$this->input->post('id');
		$kunci=array('id_labelmeta'=>$id);
		$this->model_crud->hapus_data($kunci,'tb_labelmeta');
		$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
					Barang berhasil dihapus dari daftar cetak label
					<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>';
		$toas='Barang berhasil dihapus dari daftar cetak label';
		$ikon='warning';
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function cetak_label() {
		$kp=$this->session->userdata('kp');
		$id=$this->input->get('id');
		$tgl=date('Y-m-d');
		$this->load->helper('umum');
		//ambil data label barang
		$selek='tb_label.tanggal,tb_labelmeta.kode_barang,tb_labelmeta.harga_jual,tb_labelmeta.harga_diskon,tgl_akhirdiskon,jumlah_cetak,tb_labelmeta.satuan,barcode,barang';
		if ($id) {
			$kunci=array('tb_label.id_label'=>$id);
		} else {
			$kunci=array('tb_label.tanggal'=>$tgl,'kode_pegawai'=>$kp);
		}
		$query=$this->model_master->labelbarang($selek,$kunci);
		$data['databarang']=$query->result();
		//ambil data pengaturan
		$kunci=array('1'=>'1');
		$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
		$datapengaturan=$query->result();
		foreach ($datapengaturan as $hasil) {
			$data[$hasil->pengaturan]=$hasil->isi;
		}
		$data['title']='Cetak Label Barang';
		$this->load->view('master/cetak_label',$data);
	}
	
	public function caribarang() {
		$id=$this->input->post('id');
		$data['aksi']='Simpan';
		$data['datapotongan']=array();
		$data['datatebus']=array();
		$kunci=array('barcode'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_barang');
		$cek=$query->row();
		if ($cek) {
			$data['kode']=$cek->kode_barang;
			$data['barcode']=$cek->barcode;
			$data['barang']=$cek->barang;
			$data['kategori']=$cek->id_kategori;
			$data['beli']=$cek->harga_beli;
			$data['jual']=$cek->harga_jual;
			$data['jual2']=$cek->harga_jual2;
			$data['jual3']=$cek->harga_jual3;
			$data['minimal']=$cek->stok_minimal;
			$data['maksimal']=$cek->stok_maksimal;
			$data['stok']=$cek->stok;
			//cari persentase
			if ($cek->harga_beli) {
				$hargabeli=$cek->harga_beli;
			} else {
				$hargabeli=1;
			}
			$selisih=$cek->harga_jual-$hargabeli;
			$persen=$selisih/$hargabeli*100;
			$data['persen']=round($persen,0);
			$selisih=$cek->harga_jual2-$hargabeli;
			$persen2=$selisih/$hargabeli*100;
			$data['persen2']=round($persen2,0);
			$selisih=$cek->harga_jual3-$hargabeli;
			$persen3=$selisih/$hargabeli*100;
			$data['persen3']=round($persen3,0);
			//ambil data potongan
			$kunci=array('kode_barang'=>$cek->kode_barang);
			$query=$this->model_crud->ambil_data($kunci,'tb_potongan');
			$data['datapotongan']=$query->result();
			//ambil data tebus
			$kunci=array('kode_barang'=>$cek->kode_barang);
			$query=$this->model_crud->ambil_data($kunci,'tb_tebusharga');
			$data['datatebus']=$query->result();
			$data['aksi']='Ubah';
			echo json_encode($data);
		}
	}
}