<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Stok extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if ($this->session->userdata('kp')=='') {
			redirect('login');
		}
		$this->load->model('model_crud');
		$this->load->model('model_stok');
	}

	public function index() {
		redirect('stok/opname');
	}

	public function opname() {
		$data['title']='Stok Opname';
		$data['template']='stok/view_opname';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function dataopname() {
		$req=$_REQUEST;
		$total=$this->model_stok->dataopname($req,'jumlah');
		$datatab=$this->model_stok->dataopname($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=date('d-m-Y',strtotime($hasil->tanggal));
			$datanya[]=$hasil->barang;
			$datanya[]=$hasil->pegawai;
			$datanya[]=date('d-m-Y H:i',strtotime($hasil->tgl_update));
			$datanya[]='<a href="'.base_url('stok/cetak_opname?id='.$hasil->id_stokopname).'" class="btn btn-primary btn-xs" title="Cetak Stok Opname" target="_blank"><i class="fa fa-print"></i></a>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_draftopname() {
		$id=$this->input->get('id');
		$data['aksi']='Simpan';
		$tanggal=date('Y-m-d');
		$data['tanggal']=$tanggal;
		//ambil data rak
		$kunci=array('1'=>'1');
		$query=$this->model_crud->ambil_data($kunci,'tb_rak');
		$data['datarak']=$query->result();
		$data['title']='Form Stok Opname';
		$data['template']='stok/form_drafopname';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_drafopname() {
		$rak=$this->input->post('rak');
		//ambil data barang draf stok opname
		$kunci['tb_barang.aktif']=1;
		if ($rak) {
			$kunci['tb_drafstokopnamemeta.nama_rak']=$rak;
		}
        $selek='tb_drafstokopnamemeta.id_drafstokopnamemeta,tb_drafstokopnamemeta.kode_barang,tb_drafstokopnamemeta.stok,tb_drafstokopnamemeta.satuan,tb_drafstokopnamemeta.stok_nyata,nama_rak,keterangan,barang';
        $query=$this->model_stok->datadrafstokopname($selek,$kunci);
        $databarang=$query->result();
        $data['databarang']=$databarang;
        $this->load->view('stok/ajax_drafopname',$data);
	}

	public function simpan_drafopnamemeta() {
		$rak=$this->input->post('rak');
		$id=$this->input->post('idopname');
		$tglupdate=date('Y-m-d H:i:s');
		$this->load->model('model_master');
		//ambil data barang dulu
		$kunci=array('rak'=>$rak,'tb_barang.aktif'=>'1');
		$query=$this->model_master->databarangrak($kunci);
		$databarang=$query->result();
		if ($rak) {
			if ($databarang) {
				foreach ($databarang as $hasil) {
					//ambil satuan 1 dan harga jual 1
					$kunci=array('kode_barang'=>$hasil->kode_barang);
					$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
					$cek=$query->row();
					if ($cek) {
						$jual=$cek->harga_jual1;
						$satuan=$cek->satuan1;
					} else {
						$jual=0;
						$satuan='';
					}
					//ambil data dari tabel draft stok opname
					$kunci=array('nama_rak'=>$rak,'kode_barang'=>$hasil->kode_barang);
					$query=$this->model_crud->ambil_data($kunci,'tb_drafstokopnamemeta');
					$cek=$query->num_rows();
					if ($cek==0) {
						//tambahkan data
						$isi=array('nama_rak'=>$rak,'kode_barang'=>$hasil->kode_barang,'harga_beli'=>$hasil->harga_beli,'harga_jual'=>$jual,'satuan'=>$satuan);
						$this->model_crud->tambah_data('tb_drafstokopnamemeta',$isi);
					}
					$pesan='';
					$toas='';
					$ikon='';
				}
			} else {
				$pesan='';
				$toas='';
				$ikon='';
			}
		} else {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Rak harus diisi!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Rak harus diisi!';
			$ikon='error';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function simpan_drafopname() {
		$rak=$this->input->post('rak');
		$kode=$this->input->post('kode');
		if ($kode && $rak) {
			//cek stok barang dengan kode
			$kunci=array('kode_barang'=>$kode,'aktif'=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_barang');
			$cek=$query->row();
			if ($cek) {
				$stok=$cek->stok;
				$kdbarang=$cek->kode_barang;
				$hargabeli=$cek->harga_beli;
			} else {
				//cek stok barang dengan barcode
				$kunci=array('barcode'=>$kode,'aktif'=>1);
				$query=$this->model_crud->ambil_data($kunci,'tb_barang');
				$cek=$query->row();
				if ($cek) {
					$stok=$cek->stok;
					$kdbarang=$cek->kode_barang;
					$hargabeli=$cek->harga_beli;
				} else {
					$stok=0;
					$kdbarang='';
					$hargabeli='';
					$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
								Data barang tidak ditemukan!
								<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
							</div>';
					$toas='Data barang tidak ditemukan!';
					$ikon='error';
					$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
					echo json_encode($arr);
					die();
				}
			}
			//ambil satuan 1 dan harga jual 1
			$kunci=array('kode_barang'=>$kdbarang);
			$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
			$cek=$query->row();
			if ($cek) {
				$jual=$cek->harga_jual1;
				$satuan=$cek->satuan1;
			} else {
				$jual=0;
				$satuan='';
			}
			//selanjutnya input ke tabel draf stok opname
			//tapi cek dulu apakah barang tersebut sudah dimasukan apa belum
			$kunci=array('kode_barang'=>$kdbarang,'nama_rak'=>$rak);	
			$query=$this->model_crud->ambil_data($kunci,'tb_drafstokopnamemeta');
			$cek=$query->row();
			if ($cek) {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Data barang sudah ada didaftar draf stok opname!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Data barang sudah ada didaftar draf stok opname!';
				$ikon='error';
			} else {
				//tambahkan data
				$isi=array('nama_rak'=>$rak,'kode_barang'=>$kdbarang,'stok'=>$stok,'harga_beli'=>$hargabeli,'harga_jual'=>$jual,'satuan'=>$satuan);
				$this->model_crud->tambah_data('tb_drafstokopnamemeta',$isi);
				$pesan='';
				$toas='';
				$ikon='';
			} 
		} else {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Kode barang dan nama rak harus diisi!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Kode barang dan nama rak harus diisi!';
			$ikon='error';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function update_drafopnamemeta() {
		$id=$this->input->post('id');
		$nyata=$this->input->post('nyata');
		$kunci=array('id_drafstokopnamemeta'=>$id);
		$isi=array('stok_nyata'=>$nyata);
		$this->model_crud->update_data($kunci,'tb_drafstokopnamemeta',$isi);
	}
	
	public function cetak_formopname() {
		$this->load->helper('umum');
		$tanggal=date('Y-m-d');
		//ambil data tabel draf stok opname
		$selek='tb_drafstokopnamemeta.id_drafstokopnamemeta,tb_drafstokopnamemeta.kode_barang,tb_drafstokopnamemeta.stok,tb_drafstokopnamemeta.satuan,tb_drafstokopnamemeta.stok_nyata,tb_drafstokopnamemeta.harga_beli,tb_drafstokopnamemeta.harga_jual,nama_rak,keterangan,barang';
		$kunci=array('tb_barang.aktif'=>1);
		$query=$this->model_stok->datadrafstokopname($selek,$kunci);
		$databarang=$query->result();
		$arrbarang=array();
		foreach ($databarang as $hasil) {
			$arrbarang[$hasil->kode_barang]['kode']=$hasil->kode_barang;
			$arrbarang[$hasil->kode_barang]['nama']=$hasil->barang;
			$arrbarang[$hasil->kode_barang]['stok']=$hasil->stok;
			$arrbarang[$hasil->kode_barang]['nyata'][]=$hasil->stok_nyata;
			$arrbarang[$hasil->kode_barang]['beli']=$hasil->harga_beli;
			$arrbarang[$hasil->kode_barang]['satuan']=$hasil->satuan;
		}
		$data['arrbarang']=$arrbarang;
		$data['tanggal']=tanggalindo($tanggal);
		$data['title']='Cetak Form Stok Opname';
		$this->load->view('stok/cetak_formopname',$data);
	}

	public function hapus_drafopname() {
		$this->db->query('TRUNCATE tb_drafstokopnamemeta');
		redirect('stok/opname');
	}

	public function cetak_selisihdrafopname() {
		$this->load->helper('umum');
		$tanggal=date('Y-m-d');
		//ambil data tabel draf stok opname
		$selek='tb_drafstokopnamemeta.id_drafstokopnamemeta,tb_drafstokopnamemeta.kode_barang,tb_drafstokopnamemeta.stok,tb_drafstokopnamemeta.satuan,tb_drafstokopnamemeta.stok_nyata,tb_drafstokopnamemeta.harga_beli,tb_drafstokopnamemeta.harga_jual,nama_rak,keterangan,barang';
		$kunci=array('tb_barang.aktif'=>1);
		$query=$this->model_stok->datadrafstokopname($selek,$kunci);
		$databarang=$query->result();
		$arrbarang=array();
		foreach ($databarang as $hasil) {
			$arrbarang[$hasil->kode_barang]['kode']=$hasil->kode_barang;
			$arrbarang[$hasil->kode_barang]['nama']=$hasil->barang;
			$arrbarang[$hasil->kode_barang]['stok']=$hasil->stok;
			$arrbarang[$hasil->kode_barang]['nyata'][]=$hasil->stok_nyata;
			$arrbarang[$hasil->kode_barang]['beli']=$hasil->harga_beli;
			$arrbarang[$hasil->kode_barang]['satuan']=$hasil->satuan;
		}
		$data['arrbarang']=$arrbarang;
		$data['tanggal']=tanggalindo($tanggal);
		$data['title']='Cetak Selisih Stok Opname';
		$this->load->view('stok/cetak_selisihdrafopname',$data);
	}

	public function form_opname() {
		$id=$this->input->get('id');
		$data['aksi']='Simpan';
		if ($id) {
			// code...
		} else {
			//ambil data tabel draf stok opname
			$selek='tb_drafstokopnamemeta.id_drafstokopnamemeta,tb_drafstokopnamemeta.kode_barang,tb_drafstokopnamemeta.stok,tb_drafstokopnamemeta.satuan,tb_drafstokopnamemeta.stok_nyata,tb_drafstokopnamemeta.harga_beli,tb_drafstokopnamemeta.harga_jual,nama_rak,keterangan,barang';
			$kunci=array('tb_barang.aktif'=>1);
			$query=$this->model_stok->datadrafstokopname($selek,$kunci);
			$databarang=$query->result();
			$arrbarang=array();
			foreach ($databarang as $hasil) {
				$arrbarang[$hasil->kode_barang]['kode']=$hasil->kode_barang;
				$arrbarang[$hasil->kode_barang]['nama']=$hasil->barang;
				$arrbarang[$hasil->kode_barang]['stok']=$hasil->stok;
				$arrbarang[$hasil->kode_barang]['nyata'][]=$hasil->stok_nyata;
				$arrbarang[$hasil->kode_barang]['beli']=$hasil->harga_beli;
				$arrbarang[$hasil->kode_barang]['jual']=$hasil->harga_jual;
				$arrbarang[$hasil->kode_barang]['satuan']=$hasil->satuan;
			}
			$data['arrbarang']=$arrbarang;
		}
		$data['title']='Form Stok Opname';
		$data['template']='stok/form_opname';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function simpan_opname() {
		$tanggal=date('Y-m-d');
		$kode=$this->input->post('kode');
		$beli=$this->input->post('beli');
		$jual=$this->input->post('jual');
		$stok=$this->input->post('stok');
		$satuan=$this->input->post('satuan');
		$nyata=$this->input->post('nyata');
		$kp=$this->session->userdata('kp');
		$tglupdate=date('Y-m-d H:i:s');
		//mari kita eksekusi proses simpan stok opname
		$isi=array('tanggal'=>$tanggal,'kode_pegawai'=>$kp,'tgl_update'=>$tglupdate);
		$this->model_crud->tambah_data('tb_stokopname',$isi);
		$id=$this->db->insert_id();
		if ($kode) {
			foreach ($kode as $key => $value) {
				//masukan ke tabel stok opname meta
				$isi=array('kode_barang'=>$value,'id_stokopname'=>$id,'stok'=>$stok[$key],'stok_nyata'=>$nyata[$key],'harga_beli'=>$beli[$key],'harga_jual'=>$jual[$key],'satuan'=>$satuan[$key]);
				$this->model_crud->tambah_data('tb_stokopnamemeta',$isi);
				//update stok barang
				$kunci=array('kode_barang'=>$value);
				$isi=array('stok'=>$nyata[$key]);
				$this->model_crud->update_data($kunci,'tb_barang',$isi);
				//masukan ke tabel kartu stok
				$isi=array('tanggal'=>$tglupdate,'kode_barang'=>$value,'keterangan'=>'Penyesuaian','penyesuaian'=>$nyata[$key],'saldo'=>$nyata[$key]);
				$this->model_crud->tambah_data('tb_kartustok',$isi);
			}
			$this->db->truncate('tb_drafstokopnamemeta');
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Stok opname berhasil disimpan. Silahkan buka menu Laporan untuk melihat datanya.
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Stok opname berhasil disimpan. Silahkan buka menu Laporan untuk melihat datanya.';
			$ikon='success';
		} else {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Tidak ada data barang stok opname!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Tidak ada data barang stok opname!';
			$ikon='error';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function ajax_opname() {
		$tanggal=$this->input->post('tanggal');
		$id=$this->input->post('id');
		//ambil data barang stok opname
		if ($id) {
			$kunci=array('tb_stokopname.id_stokopname'=>$id);
		} else {
			$kunci=array('tanggal'=>$tanggal,'apakah_draf'=>'Y');
		}
        $selek='tb_stokopname.id_stokopname,tb_stokopnamemeta.id_stokopnamemeta,tb_stokopnamemeta.kode_barang,tb_stokopnamemeta.stok,tb_stokopnamemeta.satuan,tb_stokopnamemeta.stok_nyata,nama_rak,keterangan,barang';
        $query=$this->model_stok->datastokopname($selek,$kunci);
        $databarang=$query->result();
        $data['databarang']=$databarang;
        $this->load->view('stok/ajax_opname',$data);
	}

	public function update_opnamemeta() {
		$id=$this->input->post('id');
		$nyata=$this->input->post('nyata');
		//$keterangan=$this->input->post('keterangan');
		$kunci=array('id_stokopnamemeta'=>$id);
		$isi=array('stok_nyata'=>$nyata);
		$this->model_crud->update_data($kunci,'tb_stokopnamemeta',$isi);
	}

	public function hapus_opnamemeta() {
		$id=$this->input->post('id');
		$kunci=array('id_stokopnamemeta'=>$id);
		$this->model_crud->hapus_data($kunci,'tb_stokopnamemeta');
		$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
					Item barang berhasil dihapus dari daftar stok opname
					<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>';
		$toas='Item barang berhasil dihapus dari daftar stok opname';
		$ikon='warning';
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function cetak_opname() {
		$this->load->helper('umum');
		$id=$this->input->get('id');
		//ambil nama pegawai dan tanggal stok opname
		$kunci=array('id_stokopname'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_stokopname');
		$cek=$query->row();
		if ($cek) {
			$data['tanggal']=tanggalindo($cek->tanggal);
			$data['tglupdate']=date('d-m-Y H:i:s',strtotime($cek->tgl_update));
			//nama pegawai
			$kunci=array('kode_pegawai'=>$cek->kode_pegawai);
			$query=$this->model_crud->ambil_data($kunci,'tb_pegawai');
			$ceker=$query->row();
			if ($ceker) {
				$data['pegawai']=$ceker->pegawai;
			}
		}
		//ambil data barang stok opname
        $kunci=array('tb_stokopname.id_stokopname'=>$id);
        $selek='tb_stokopname.id_stokopname,tb_stokopnamemeta.id_stokopnamemeta,tb_stokopnamemeta.kode_barang,tb_stokopnamemeta.stok,tb_stokopnamemeta.satuan,tb_stokopnamemeta.stok_nyata,tb_stokopnamemeta.harga_beli,tb_stokopnamemeta.harga_jual,barang';
        $query=$this->model_stok->datastokopname($selek,$kunci);
        $databarang=$query->result();
        $data['databarang']=$databarang;
		$data['title']='Cetak Stok Opname';
        $this->load->view('stok/cetak_opname',$data);
	}	
	
	public function kartu() {
		$data['awal']=date('Y-m-').'01';
		$data['akhir']=date('Y-m-d');
		$data['title']='Kartu Stok';
		$data['template']='stok/view_kartu';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_kartu() {
		$awal=$this->input->post('awal');
		$akhir=$this->input->post('akhir');
		$kode=$this->input->post('kode');
		$this->load->model('model_laporan');
		//ambil kode barang
		$kunci=array('kode_barang'=>$kode,'aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_barang');
		$cek=$query->row();
		if ($cek) {
			$kdbarang=$cek->kode_barang;
		} else {
			//cek stok barang dengan barcode
			$kunci=array('barcode'=>$kode);
			$query=$this->model_crud->ambil_data($kunci,'tb_barang');
			$cek=$query->row();
			if ($cek) {
				$kdbarang=$cek->kode_barang;
			} else {
				$kdbarang='';
			}
		}
		//ambil data kartu stok
		$urut=array('tanggal'=>'ASC');
		$kunci=array('kode_barang'=>$kdbarang);
		if ($awal) {
			$kunci["DATE_FORMAT(tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tanggal,'%Y-%m-%d')<="]=$akhir;
		}
		$query=$this->model_crud->ambil_data($kunci,'tb_kartustok',$urut);
		$datakartu=$query->result();
		$arrstok=array();
		$data['datakartu']=$datakartu;
		$data['awal']=$awal;
		$data['akhir']=$akhir;
		$this->load->view('stok/ajax_kartu',$data);
	}

	public function cetak_kartu() {
		$awal=$this->input->get('awal');
		$akhir=$this->input->get('akhir');
		$kode=$this->input->get('kode');
		$this->load->model('model_laporan');
		$this->load->helper('umum');
		//ambil kode barang
		$kunci=array('kode_barang'=>$kode,'aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_barang');
		$cek=$query->row();
		if ($cek) {
			$kdbarang=$cek->kode_barang;
			$data['kdbarang']=$cek->kode_barang;
			$data['barcode']=$cek->barcode;
			$data['barang']=$cek->barang;
		} else {
			//cek stok barang dengan barcode
			$kunci=array('barcode'=>$kode);
			$query=$this->model_crud->ambil_data($kunci,'tb_barang');
			$cek=$query->row();
			if ($cek) {
				$kdbarang=$cek->kode_barang;
				$data['kdbarang']=$cek->kode_barang;
				$data['barcode']=$cek->barcode;
				$data['barang']=$cek->barang;
			} else {
				$kdbarang='';
			}
		}
		//ambil satuan barang
		$kunci=array('kode_barang'=>$kdbarang);
		$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
		$cek=$query->row();
		if ($cek) {
			$data['satuan']=$cek->satuan1;
		}
		//ambil data kartu stok
		$urut=array('tanggal'=>'ASC');
		$kunci=array('kode_barang'=>$kdbarang);
		if ($awal) {
			$kunci["DATE_FORMAT(tanggal,'%Y-%m-%d')>="]=$awal;
			$data['awal']=tanggalindo($awal);
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tanggal,'%Y-%m-%d')<="]=$akhir;
			$data['akhir']=tanggalindo($akhir);
		}
		$query=$this->model_crud->ambil_data($kunci,'tb_kartustok',$urut);
		$datakartu=$query->result();
		$arrstok=array();
		$data['datakartu']=$datakartu;
		$data['title']='Cetak Kartu Stok';
		$this->load->view('stok/cetak_kartu',$data);
	}

	public function laporanopname() {
		$kp=$this->session->userdata('kp');
		$level=$this->session->userdata('level');
        $data['tanggal']=date('Y-m-d');
		$data['title']='Laporan Stok Opname';
		$data['template']='stok/view_laporanopname';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_lapopname() {
		$this->load->model('model_stok');
		$tanggal=$this->input->post('tanggal');
		$kunci=array("DATE_FORMAT(tb_stokopname.tanggal,'%Y-%m-%d')"=>$tanggal);
		$selek='tb_stokopname.id_stokopname,tb_stokopname.tanggal,tb_stokopnamemeta.kode_barang,tb_stokopnamemeta.stok,tb_stokopnamemeta.satuan,tb_stokopnamemeta.harga_beli,tb_stokopnamemeta.harga_jual,SUM(tb_stokopnamemeta.stok_nyata) AS stok_nyata,barcode,barang';
        $query=$this->model_stok->datastokopnamegroup($selek,$kunci);
        $databarang=$query->result();
		$data['databarang']=$databarang;
		$this->load->view('stok/ajax_lapopname',$data);
	}

	public function xls_lapopname() {
		$this->load->model('model_stok');
		$tanggal=$this->input->get('tanggal');
		$kunci=array("DATE_FORMAT(tb_stokopname.tanggal,'%Y-%m-%d')"=>$tanggal);
		$selek='tb_stokopname.id_stokopname,tb_stokopname.tanggal,tb_stokopnamemeta.kode_barang,tb_stokopnamemeta.stok,tb_stokopnamemeta.satuan,tb_stokopnamemeta.harga_beli,tb_stokopnamemeta.harga_jual,SUM(tb_stokopnamemeta.stok_nyata) AS stok_nyata,barcode,barang';
        $query=$this->model_stok->datastokopnamegroup($selek,$kunci);
        $databarang=$query->result();
		$data['databarang']=$databarang;
		$data['tanggal']=date('d-m-Y',strtotime($tanggal));
		$this->load->view('stok/xls_lapopname',$data);
	}

	public function laporantransaksiopname() {
		$kp=$this->session->userdata('kp');
		$level=$this->session->userdata('level');
		$data['awal']=date('Y-m').'-01';
        $data['akhir']=date('Y-m-d');
		$data['title']='Laporan Stok Opname Per Transaksi';
		$data['template']='stok/view_laporantransaksiopname';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_laptransaksiopname() {
		$awal=$this->input->post('awal');
		$akhir=$this->input->post('akhir');
		$kunci=array();
		//ambil data transaksi
		$selek='tb_stokopname.id_stokopname,tb_stokopname.tanggal,tb_stokopnamemeta.kode_barang,tb_stokopnamemeta.harga_beli,tb_stokopnamemeta.stok,stok_nyata,pegawai';
		if ($awal) {
			$kunci['tb_stokopname.tanggal>=']=$awal;
		}
		if ($akhir) {
			$kunci['tb_stokopname.tanggal<=']=$akhir;
		}
		$query=$this->model_stok->transaksiopname($selek,$kunci);
		$datatransaksi=$query->result();
		$arropname=array();
		foreach ($datatransaksi as $hasil) {
			$hrgsistem=$hasil->stok*$hasil->harga_beli;
			$hrgnyata=$hasil->stok_nyata*$hasil->harga_beli;
			$arropname['tanggal'][$hasil->id_stokopname]=$hasil->tanggal;
			$arropname['barang'][$hasil->id_stokopname][]=$hasil->kode_barang;
			$arropname['hrgsistem'][$hasil->id_stokopname][]=$hrgsistem;
			$arropname['hrgnyata'][$hasil->id_stokopname][]=$hrgnyata;
			$arropname['pegawai'][$hasil->id_stokopname]=$hasil->pegawai;
		}
		$data['arropname']=$arropname;
		$this->load->view('stok/ajax_laptransaksiopname',$data);
	}
	
	public function cetak_laptransaksiopname() {
		$awal=$this->input->get('awal');
		$akhir=$this->input->get('akhir');
		$this->load->helper('umum');
		$kunci=array();
		//ambil data transaksi
		$selek='tb_stokopname.id_stokopname,tb_stokopname.tanggal,tb_stokopnamemeta.kode_barang,tb_stokopnamemeta.harga_beli,tb_stokopnamemeta.stok,stok_nyata,pegawai';
		if ($awal) {
			$kunci['tb_stokopname.tanggal>=']=$awal;
			$data['awal']=tanggalindo($awal);
		}
		if ($akhir) {
			$kunci['tb_stokopname.tanggal<=']=$akhir;
			$data['akhir']=tanggalindo($akhir);
		}
		$query=$this->model_stok->transaksiopname($selek,$kunci);
		$datatransaksi=$query->result();
		$arropname=array();
		foreach ($datatransaksi as $hasil) {
			$hrgsistem=$hasil->stok*$hasil->harga_beli;
			$hrgnyata=$hasil->stok_nyata*$hasil->harga_beli;
			$arropname['tanggal'][$hasil->id_stokopname]=$hasil->tanggal;
			$arropname['barang'][$hasil->id_stokopname][]=$hasil->kode_barang;
			$arropname['hrgsistem'][$hasil->id_stokopname][]=$hrgsistem;
			$arropname['hrgnyata'][$hasil->id_stokopname][]=$hrgnyata;
			$arropname['pegawai'][$hasil->id_stokopname]=$hasil->pegawai;
		}
		$data['arropname']=$arropname;
		$data['title']='Rekap Stok Opname';
		$this->load->view('stok/cetak_laptransaksiopname',$data);
	}
}