<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Upload extends CI_Controller {
	public function __construct() {
		parent::__construct();
		$this->load->model('model_crud');
		require('./google/vendor/autoload.php');
	}

	public function index() {
		// setting config untuk layanan akses ke google drive
		$client=new Google_Client();
		$client->setAuthConfig("./google/client_secret.json");
		$client->addScope("https://www.googleapis.com/auth/drive");
		$service=new Google_Service_Drive($client);
		// proses membaca token pasca login
		if ($this->input->get('code')) {
			$token=$client->fetchAccessTokenWithAuthCode($this->input->get('code'));
			$this->session->set_userdata('upload_token',$token);
		}
		// mengecek keberadaan token session
		if ($this->session->userdata('upload_token')==''){
			// jika token belum ada, maka lakukan login via oauth
			$authUrl = $client->createAuthUrl();
			redirect($authUrl);
		}
		$data['title']='Upload Gdrive';
		$this->load->view('form_upload',$data);
	}

	public function simpan() {
		// setting config untuk layanan akses ke google drive
		$client=new Google_Client();
		$client->setAuthConfig("./google/client_secret.json");
		$client->addScope("https://www.googleapis.com/auth/drive");
		$service=new Google_Service_Drive($client);
		// menggunakan token untuk mengakses google drive  
		$client->setAccessToken($this->session->userdata('upload_token'));
		// membaca token respon dari google drive
		$client->getAccessToken();		
		// instansiasi obyek file yg akan diupload ke Google Drive
		$file = new Google_Service_Drive_DriveFile();
		// set nama file di Google Drive disesuaikan dg nama file aslinya
		$file->setName($_FILES["pile"]["name"]);
		// proses upload file ke Google Drive dg multipart
		$result = $service->files->create($file, array('data' => file_get_contents($_FILES["pile"]["tmp_name"]),'mimeType' => 'application/octet-stream','uploadType' => 'multipart','dir'=>'SIAKAD'));	
		// menampilkan nama file yang sudah diupload ke google drive
		echo $result->name."<br>";
	}

	public function password() {
		$this->session->unset_userdata('upload_token');
		$data['title']="Ganti Password";
		$data['template']='panel/beranda/form_password';
		$data['footer']='panel/layout/footer';
		$data['footerend']='panel/layout/footerend';
		$this->load->view('panel/layout/wrapper',$data);
	}

	public function simpan_password() {
		$pass1=$this->input->post('pass1');
		$pass2=$this->input->post('pass2');
		$pass3=$this->input->post('pass3');
		$admin=$this->session->userdata('nanda');
		if ($pass2==$pass3) {
			$kunci=array('username'=>$admin,'password'=>md5($pass1));
			$query=$this->model_crud->ambil_data($kunci,'tb_admin');
			$cek=$query->num_rows();
			if ($cek) {
				$isi=array('password'=>md5($pass2));
				$simpan=$this->model_crud->update_data($kunci,'tb_admin',$isi);
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Password berhasil diubah
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Password berhasil diubah';
				$ikon='success';
			} else {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Password lama masih salah!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Password lama masih salah!';
				$ikon='error';
			}
		} else {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Password baru belum cocok!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Password baru belum cocok!';
			$ikon='error';
		}
		$arr=array('pesan'=>$pesan, 'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}
}