<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Form Barang</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item active"><a href="#">Barang</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <form method="post" id="formdata">
                            <div class="card-header">
                                <ul class="nav nav-tabs" id="tabs-home" role="tablist">
                                    <li class="nav-item">
                                        <a href="#barang-home" class="nav-link active" data-toggle="pill" role="tab" aria-controls="barang-home" aria-selected="true">Barang</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="#satuan-home" class="nav-link" data-toggle="pill" role="tab" aria-controls="satuan-home" aria-selected="true">Satuan dan Harga Jual</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="#potongan-home" class="nav-link" data-toggle="pill" role="tab" aria-controls="potongan-home" aria-selected="true">Potongan Harga</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="#bonus-home" class="nav-link" data-toggle="pill" role="tab" aria-controls="bonus-home" aria-selected="true">Bonus Jumlah</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="#stok-home" class="nav-link" data-toggle="pill" role="tab" aria-controls="stok-home" aria-selected="true">Riwayat Stok</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="card-body">
                                <div class="tab-content">
                                    <div class="tab-pane fade active show" id="barang-home" role="tabpanel" aria-labelledby="barang-home">
                                        <div class="form-group row">
                                            <label class="col-sm-3 col-form-label">Kode Barang</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" id="kode" name="kode" value="<?php echo @$kode ?>" required>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-3 col-form-label">Barcode</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" id="barcode" name="barcode" onblur="caribarang(this.value)" onchange="caribarang(this.value)" value="<?php echo @$barcode ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-3 col-form-label">Barcode 2</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" id="barcode2" name="barcode2" value="<?php echo @$barcode2 ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-3 col-form-label">Barcode 3</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" id="barcode3" name="barcode3" value="<?php echo @$barcode3 ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-3 col-form-label">Nama Barang</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" id="barang" name="barang" value="<?php echo @$barang ?>" required>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-3 col-form-label">Kategori Barang</label>
                                            <div class="col-sm-9">
                                                <select class="form-control" id="kategori" name="kategori" required>
                                                    <option value="">-- pilih kategori --</option>
                                                    <?php
                                                    foreach ($datakategori as $hasil) {
                                                        ?>
                                                        <option value="<?php echo $hasil->id_kategori ?>" <?php if (@$kategori==$hasil->id_kategori) echo 'selected' ?>><?php echo $hasil->kategori ?></option>
                                                        <?php
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-3 col-form-label">Harga Pembelian</label>
                                            <div class="col-sm-9">
                                                <input type="number" class="form-control" id="beli" name="beli" step="any" value="<?php echo @$beli ?>">
                                                <span style="color: red"><i>harga pembelian adalah harga per item menggunakan satuan eceran</i></span>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-3 col-form-label">Minimal Order ke Suplier</label>
                                            <div class="col-sm-9">
                                                <input type="number" class="form-control" id="minimal" step="any" name="minimal" value="<?php echo @$minimal ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-3 col-form-label">Stok Maksimal (PKM)</label>
                                            <div class="col-sm-9">
                                                <input type="number" class="form-control" id="pkm" name="pkm" step="any" value="<?php echo @$pkm ?>" readonly>
                                                <span style="color: red;"><i>Otomatis dihitung dari sistem</i></span>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-3 col-form-label">Stok Tersedia</label>
                                            <div class="col-sm-9">
                                                <input type="number" class="form-control" id="stok" name="stok" step="any" value="<?php echo @$stok ?>" <?php if (@$kode) echo 'readonly' ?>>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="satuan-home" role="tabpanel" aria-labelledby="satuan-home">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>Satuan 1</label>
                                                    <input type="text" class="form-control" id="satuan1" name="satuan1" value="<?php echo @$satuan1 ?>" onblur="satuanisi()">
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>Harga Jual 1</label>
                                                    <input type="number" class="form-control" id="jual1" name="jual1" value="<?php echo @$jual1 ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>Harga Jual 2</label>
                                                    <input type="number" class="form-control" id="jual2" name="jual2" value="<?php echo @$jual2 ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>Harga Jual 3</label>
                                                    <input type="number" class="form-control" id="jual3" name="jual3" value="<?php echo @$jual3 ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>Satuan 2</label>
                                                    <input type="text" class="form-control" id="satuan2" name="satuan2" value="<?php echo @$satuan2 ?>" onblur="satuanisi()">
                                                </div>
                                            </div>
                                            <div class="col-sm-2">
                                                <div class="form-group">
                                                    <label>Isi</label>
                                                    <div class="input-group mb-3">
                                                        <input type="number" class="form-control" id="konversi1" name="konversi1" step="any" value="<?php echo @$konversi1 ?>">
                                                        <span class="input-group-text" id="lbl1"><?php echo @$satuan1 ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Harga Jual 1</label>
                                                    <input type="number" class="form-control" id="jual21" name="jual21" value="<?php echo @$jual21 ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Harga Jual 2</label>
                                                    <input type="number" class="form-control" id="jual22" name="jual22" value="<?php echo @$jual22 ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Harga Jual 3</label>
                                                    <input type="number" class="form-control" id="jual23" name="jual23" value="<?php echo @$jual23 ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>Satuan 3</label>
                                                    <input type="text" class="form-control" id="satuan3" name="satuan3" value="<?php echo @$satuan3 ?>">
                                                </div>
                                            </div>
                                            <div class="col-sm-2">
                                                <div class="form-group">
                                                    <label>Isi</label>
                                                    <div class="input-group mb-3">
                                                        <input type="number" class="form-control" id="konversi2" name="konversi2" step="any" value="<?php echo @$konversi2 ?>">
                                                        <span class="input-group-text" id="lbl2"><?php echo @$satuan1 ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Harga Jual 1</label>
                                                    <input type="number" class="form-control" id="jual31" name="jual31" value="<?php echo @$jual31 ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Harga Jual 2</label>
                                                    <input type="number" class="form-control" id="jual32" name="jual32" value="<?php echo @$jual32 ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Harga Jual 3</label>
                                                    <input type="number" class="form-control" id="jual33" name="jual33" value="<?php echo @$jual33 ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="potongan-home" role="tabpanel" aria-labelledby="potongan-home">
                                        <table class="table table-bordered table-hover" id="tabelpot">
                                        <thead>
                                        <tr>
                                            <th>Mulai</th>
                                            <th>Selesai</th>
                                            <th>Potongan (Rp)</th>
                                            <th>Minimal Beli</th>
                                            <th width="2%"></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        foreach ($datapotongan as $hasil) {
                                            ?>
                                            <tr>
                                                <td>
                                                    <input type="date" name="mulai[]" class="form-control" value="<?php echo $hasil->mulai ?>">
                                                </td>
                                                <td>
                                                    <input type="date" name="selesai[]" class="form-control" value="<?php echo $hasil->selesai ?>">
                                                </td>
                                                <td>
                                                    <input type="number" name="potongan[]" class="form-control" step="0.01" value="<?php echo $hasil->potongan ?>">
                                                </td>
                                                <td>
                                                    <input type="number" name="jumlah[]" class="form-control" step="0.01" value="<?php echo $hasil->jumlah_beli ?>">
                                                </td>
                                                <td>
                                                    <input type="hidden" name="idpot[]" value="<?php echo $hasil->id_potongan ?>">
                                                    <button type="button" title="Hapus" onclick="hapus(this,this.value)" class="btn btn-danger btn-sm" value="<?php echo $hasil->id_potongan ?>"><i class="fa fa-trash"></i></button>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                        ?>
                                        </tbody>
                                        <tfoot>
                                        <tr>
                                            <th colspan="4"></th>
                                            <th>
                                                <button type="button" title="Tambah" class="btn btn-success btn-sm" value="" onclick="tambah()"><i class="fa fa-plus"></i></button>
                                            </th>
                                        </tr>
                                        </tfoot>
                                        </table>
                                    </div>
                                    <div class="tab-pane fade" id="bonus-home" role="tabpanel" aria-labelledby="bonus-home">
                                        <table class="table table-bordered table-hover" id="tabelbonus">
                                        <thead>
                                        <tr>
                                            <th>Mulai</th>
                                            <th>Selesai</th>
                                            <th>Minimal Beli</th>
                                            <th>Jumlah Bonus</th>
                                            <th width="2%"></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        foreach ($databonus as $hasil) {
                                            ?>
                                            <tr>
                                                <td>
                                                    <input type="date" name="mulaibonus[]" class="form-control" value="<?php echo $hasil->mulai ?>">
                                                </td>
                                                <td>
                                                    <input type="date" name="selesaibonus[]" class="form-control" value="<?php echo $hasil->selesai ?>">
                                                </td>
                                                <td>
                                                    <input type="number" name="jumbeli[]" class="form-control" step="0.01" value="<?php echo $hasil->jumlah_beli ?>">
                                                </td>
                                                <td>
                                                    <input type="number" name="bonus[]" class="form-control" step="0.01" value="<?php echo $hasil->bonus ?>">
                                                </td>
                                                <td>
                                                    <input type="hidden" name="idbonus[]" value="<?php echo $hasil->id_bonus ?>">
                                                    <button type="button" title="Hapus" onclick="hapusbonus(this,this.value)" class="btn btn-danger btn-sm" value="<?php echo $hasil->id_bonus ?>"><i class="fa fa-trash"></i></button>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                        ?>
                                        </tbody>
                                        <tfoot>
                                        <tr>
                                            <th colspan="4"></th>
                                            <th>
                                                <button type="button" title="Tambah" class="btn btn-success btn-sm" value="" onclick="tambahbonus()"><i class="fa fa-plus"></i></button>
                                            </th>
                                        </tr>
                                        </tfoot>
                                        </table>
                                    </div>
                                    <div class="tab-pane fade" id="stok-home" role="tabpanel" aria-labelledby="stok-home">
                                        <div class="row">
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Tanggal Awal</label>
                                                    <input type="date" class="form-control" id="awal" name="awal" value="<?php echo @$awal ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Tanggal Akhir</label>
                                                    <input type="date" class="form-control" id="akhir" name="akhir" value="<?php echo @$akhir ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label style="color: white;">&nbsp;</label>
                                                    <button type="button" class="btn btn-primary" style="width: 100%;" onclick="tampilkan()"><i class="fa fa-search"></i> Tampilkan</button>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="konten"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer" style="text-align: right;">
                                <input type="hidden" name="id" id="id" value="<?php echo @$kode ?>">
                                <input type="hidden" name="aksi" id="aksi" value="<?php echo @$aksi ?>">
                                <button type="submit" class="btn bg-gradient-success"><i class="fa fa-save"></i> <?php echo @$aksi ?></button>
                                <a href="<?php echo base_url('master/barang') ?>" class="btn bg-gradient-danger"><i class="fa fa-times"></i> Batal</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End #main -->
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    tampilkan();
});

$(function(){
    $("#formdata").submit(function(event){
        event.preventDefault();
        $.ajax({
            url:"<?php echo base_url('master/simpan_barang') ?>",
            cache: false,
            type:"POST",
            data:$(this).serialize(),
            dataType:"JSON",
            success:function(result) {
                $("#peringatan").html(result.pesan);
                $("#peringatan2").html(result.pesan);
                if (result.ikon=='success') {
                    toastr.success(result.toas);
                } else if (result.ikon=='warning') {
                    toastr.warning(result.toas);
                } else if (result.ikon=='error') {
                    toastr.error(result.toas);
                }
                <?php
                if (@$kode==false) {
                    ?>
                    $("#formdata").trigger("reset");
                    <?php
                }
                ?>
            }
        });
    });
});

function tambah() {
    $("#tabelpot").find("tbody").append('<tr><td><input type="date" name="mulai[]" class="form-control"></td><td><input type="date" name="selesai[]" class="form-control"></td><td><input type="number" name="potongan[]" step="0.01" class="form-control"></td><td><input type="number" name="jumlah[]" step="0.01" class="form-control"></td><td><input type="hidden" name="idpot[]" value=""><button type="button" title="Hapus" onclick="hapus(this,this.value)" class="btn btn-danger btn-sm" name="hapus[]" value=""><i class="fa fa-trash"></i></button></td></tr>');
}

function tambahbonus() {
    $("#tabelbonus").find("tbody").append('<tr><td><input type="date" name="mulaibonus[]" class="form-control"></td><td><input type="date" name="selesaibonus[]" class="form-control"></td><td><input type="number" name="jumbeli[]" step="0.01" class="form-control"></td><td><input type="number" name="bonus[]" step="0.01" class="form-control"></td><td><input type="hidden" name="idbonus[]" value=""><button type="button" title="Hapus" onclick="hapusbonus(this,this.value)" class="btn btn-danger btn-sm" name="hapusbonus[]" value=""><i class="fa fa-trash"></i></button></td></tr>');
}

function tambahtebus() {
    $("#tabelpot").find("tbody").append('<tr><td><input type="date" name="mulai2[]" class="form-control"></td><td><input type="date" name="selesai2[]" class="form-control"></td><td><input type="number" name="belanja[]" step="0.01" class="form-control"></td><td><input type="number" name="harga[]" step="0.01" class="form-control"></td><td><select class="form-select" name="berlaku2[]"><option value="semua">Semua</option><option value="member">Member</option><option value="umum">Umum</option></select></td><td><input type="hidden" name="idtebus[]" value=""><button type="button" title="Hapus" onclick="hapustebus(this,this.value)" class="btn btn-danger btn-sm" name="hapus[]" value=""><i class="bi bi-trash"></i></button></td></tr>');
}

function hapus(i,str) {
    $.ajax({
        url:"<?php echo base_url('master/hapus_potongan') ?>",
        cache: false,
        type:"POST",
        data:{id:str},
        success:function(result) {
            $("#peringatan").html(result);
            $("#peringatan2").html(result);
            $(i).closest('tr').remove();
        }
    });
}

function hapusbonus(i,str) {
    $.ajax({
        url:"<?php echo base_url('master/hapus_bonus') ?>",
        cache: false,
        type:"POST",
        data:{id:str},
        success:function(result) {
            $("#peringatan").html(result);
            $("#peringatan2").html(result);
            $(i).closest('tr').remove();
        }
    });
}

function hapustebus(i,str) {
    $.ajax({
        url:"<?php echo base_url('master/hapus_tebus') ?>",
        cache: false,
        type:"POST",
        data:{id:str},
        success:function(result) {
            $("#peringatan").html(result);
            $("#peringatan2").html(result);
            $(i).closest('tr').remove();
        }
    });
}

function hargajual() {
    var receh="<?php echo @$receh ?>";
    var beli=$("#beli").val();
    var persen=$("#persen").val();
    var persen2=$("#persen2").val();
    var persen3=$("#persen3").val();
    //harga jual satu
    margin=Number(beli)*Number(persen)/100;
    jual=Number(beli)+Math.ceil(margin);
    bagi=jual/receh;
    bulat=Math.ceil(bagi);
    kali=bulat*receh;
    $("#jual").val(kali);
    //harga jual dua
    margin2=Number(beli)*Number(persen2)/100;
    jual2=Number(beli)+Math.ceil(margin2);
    bagi2=jual2/receh;
    bulat2=Math.ceil(bagi2);
    kali2=bulat2*receh;
    $("#jual2").val(kali2);
    //harga jual tiga
    margin3=Number(beli)*Number(persen3)/100;
    jual3=Number(beli)+Math.ceil(margin3);
    bagi3=jual3/receh;
    bulat3=Math.ceil(bagi3);
    kali3=bulat3*receh;
    $("#jual3").val(kali3);
}

function tampilkan() {
    var kode=$("#kode").val();
    var awal=$("#awal").val();
    var akhir=$("#akhir").val();
    $.ajax({
        url:"<?php echo base_url('master/ajax_riwayatstok') ?>",
        cache:false,
        type:"POST",
        data:{awal:awal,akhir:akhir,kode:kode},
        beforeSend: function(){
            $("#konten").html('<center><img src="<?php echo base_url('assets/img/loading.gif') ?>"></center>');
        },
        success:function(result){
            $("#konten").html(result);
        }
    });
}

function caribarang(str) {
    $.ajax({
        url:"<?php echo base_url('master/caribarang') ?>",
        cache:false,
        type:"POST",
        data:{id:str},
        dataType:"JSON",
        success:function(result){
            $("#barang").val(result.barang);
        }
    });
}

function satuanisi() {
    var sat1=$("#satuan1").val();
    var sat2=$("#satuan2").val();
    $("#lbl1").html(sat1);
    $("#lbl2").html(sat1);
}
</script>
<?php @$this->load->view($footerend) ?>
<!-- Page specific script -->
