<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Barang</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item active"><a href="#">Barang</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <div class="card-header">
                            <a href="<?php echo base_url('master/form_barang') ?>" class="btn btn-success"><i class="fa fa-plus"></i> Tambah</a>
                            <button class="btn btn-primary" onclick="represh()"><i class="fa fa-sync"></i> Refresh</button>
                            <!--<a href="<?php echo base_url('master/xls_barang') ?>" class="btn btn-secondary" target="_blank"><i class="bi bi-file-excel"></i> Ekspor Excel</a>-->
                            <a href="<?php echo base_url('master/edit_barang') ?>" class="btn btn-danger" target="_blank"><i class="fa fa-pencil-alt"></i> Edit Barang</a>
                            <button class="btn btn-warning" onclick="singkron()"><i class="fa fa-laptop"></i> Singkronkan Barang</button>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered datatable dt-responsive" id="tabelku" style="width: 100%;">
                            <thead>
                            <tr>
                                <th>Kode Barang</th>
                                <th>Barcode</th>
                                <th>Nama Barang</th>
                                <th>Harga Beli</th>
                                <th>Harga Jual</th>
                                <th>Persen Margin</th>
                                <th>Kategori</th>
                                <th>Suplier</th>
                                <th>Stok</th>
                                <th width="2%"></th>
                                <th width="2%"></th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- modal utama -->
<div class="modal fade" id="modalform">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <form id="formdata" method="post"></form>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal hapus -->
<div class="modal fade" id="modalhapus">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-body">
                <h4>Apakah akan menghapus barang ini?</h4>
            </div>
            <div class="modal-footer right-content-between">
                <button type="button" id="hapus" value="" onclick="hapusdata(this.value)" class="btn bg-gradient-danger"><i class="fa fa-trash"></i> Hapus</button>
                <button type="button" class="btn bg-gradient-primary" data-dismiss="modal"><i class="fa fa-times"></i> Batal</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- End #main -->
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    $("#tabelku").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "ajax":{
                url:"<?php echo base_url('master/databarang') ?>",
                type:"post",
        },
    });
});

$(function(){
    $("#formdata").submit(function(event){
        event.preventDefault();
        $.ajax({
            url:"<?php echo base_url('master/simpan_barang') ?>",
            cache: false,
            type:"POST",
            data:$(this).serialize(),
            dataType:"JSON",
            success:function(result) {
                $("#peringatan").html(result.pesan);
                if (result.ikon=='success') {
                    toastr.success(result.toas);
                } else if (result.ikon=='warning') {
                    toastr.warning(result.toas);
                } else if (result.ikon=='error') {
                    toastr.error(result.toas);
                }
                $("#tabelku").DataTable().draw();
                $("#modalform").modal('hide');
            }
        });
    });
});

function represh() {
    $("#tabelku").DataTable().draw();
}

function konfirhapus(i) {
    $("#hapus").val(i);
    $("#modalhapus").modal("show");
}

function hapusdata(str) {
    $.ajax({
        url:"<?php echo base_url('master/hapus_barang') ?>",
        cache:false,
        type:"POST",
        data:{id:str},
        dataType:"JSON",
        success:function(result){
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            $("#modalhapus").modal("hide");
            $("#tabelku").DataTable().draw();
        }
    });
}

function singkron() {
    $.ajax({
        url:"<?php echo base_url('master/singkron_barang') ?>",
        cache:false,
        type:"POST",
        dataType:"JSON",
        beforeSend: function(){
            $("#peringatan").html('<center><img src="<?php echo base_url('assets/images/loading.gif') ?>"></center>');
        },
        success:function(result){
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            $("#modalhapus").modal("hide");
            $("#tabelku").DataTable().draw();
        }
    });
}
</script>
<?php @$this->load->view($footerend) ?>