<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Form Stok Opname</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item">Manajemen Stok</li>
                        <li class="breadcrumb-item active"><a href="#">Stok Opname</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <form method="post" id="formdata">
                            <div class="card-body">
                                <table class="table table-hover table-bordered" id="tabelstokis">
                                <thead>
                                <tr>
                                    <th scope="col">Kode Barang</th>
                                    <th scope="col">Nama Barang</th>
                                    <th scope="col">Satuan</th>
                                    <th scope="col" width="15%">Stok Fisik</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                foreach ($arrbarang as $key => $value) {
                                    $nyata=array_sum($value['nyata']);
                                    ?>
                                    <tr>
                                        <td>
                                            <?php echo $key ?>
                                            <input type="hidden" name="kode[]" value="<?php echo $key ?>">
                                            <input type="hidden" name="beli[]" value="<?php echo $value['beli'] ?>">
                                            <input type="hidden" name="jual[]" value="<?php echo $value['jual'] ?>">
                                            <input type="hidden" name="stok[]" value="<?php echo $value['stok'] ?>">
                                        </td>
                                        <td><?php echo $value['nama'] ?></td>
                                        <td>
                                            <?php echo $value['satuan'] ?>
                                            <input type="hidden" name="satuan[]" value="<?php echo $value['satuan'] ?>">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control" name="nyata[]" value="<?php echo $nyata ?>">
                                        </td>
                                    </tr>
                                    <?php
                                }
                                ?>
                                </tbody>
                                </table>
                            </div>
                            <div class="card-footer">
                                <a href="<?php echo base_url('stok/form_draftopname') ?>" class="btn bg-gradient-danger"><i class="fa fa-times"></i> Kembali ke Draf</a>
                                <button type="button" class="btn bg-gradient-success" onclick="konfirsimpan()"><i class="fa fa-save"></i> Simpan</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- modal konfirmasi -->
<div class="modal fade" id="modalkonfir">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-body">
                <h4>Apakah yakin akan menyimpan data stok opname ini?</h4>
                <span style="color: red;">Jika sudah disimpan tidak bisa diubah kembali</span>
            </div>
            <div class="modal-footer">
                <button type="button" value="" class="btn btn-danger" onclick="ajusmen()"><i class="fa fa-check"></i> Yakin</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Tidak</button>
            </div>
        </div>
    </div>
</div>
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
function konfirsimpan() {
    $("#modalkonfir").modal("show");
}

function ajusmen() {
    event.preventDefault();
    $.ajax({
        url:"<?php echo base_url('stok/simpan_opname') ?>",
        cache: false,
        type:"POST",
        data:$("#formdata").serialize(),
        dataType:"JSON",
        success:function(result) {
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            $("#modalkonfir").modal("hide");
            window.setTimeout(function () {
                location.href="<?php echo base_url('stok/opname') ?>";
            },5000);
        }
    });  
}
</script>
<?php @$this->load->view($footerend) ?>
<!-- Page specific script -->