<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo @$title ?></title>
    <!-- Vendor CSS Files -->
    <link href="<?php echo base_url('assets/vendor/bootstrap/css/bootstrap.min.css') ?>" rel="stylesheet">
    <link href="<?php echo base_url('assets/vendor/bootstrap-icons/bootstrap-icons.css') ?>" rel="stylesheet">
</head>
<body>
<div class="container">
    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-4">
                    <strong>Tanggal:</strong>
                    <?php echo @$tanggal ?>
                </div>
                <div class="col-md-4">
                    <center>
                        <h4>SURAT BARANG KELUAR</h4>
                    </center>
                </div>
                <div class="col-md-4" style="text-align: right;">
                    <strong>Nomor:</strong>
                    <?php echo @$kode ?>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row mb-4">
                <div class="col-sm-6">
                    <h6 class="mb-3">Dari:</h6>
                    <div><strong>Gudang Kabita</strong></div>
                    <div>Jl. Paningkaban</div>
                    <div>Telepon: +48 444 666 3333</div>
                </div>
                <div class="col-sm-6">
                    <h6 class="mb-3">Kepada:</h6>
                    <div><strong><?php echo @$toko ?></strong></div>
                    <div><?php echo @$alamattoko ?></div>
                    <div>Telepon: <?php echo @$telepontoko ?></div>
                </div>
            </div>
            <div class="table-responsive-sm">
                <table class="table table-striped">
                <thead>
                <tr>
                    <th class="center">#</th>
                    <th>Kode Barang</th>
                    <th>Nama Barang</th>
                    <th style="text-align: center;">Jumlah</th>
                    <th style="text-align: right;">Harga Satuan</th>
                    <th style="text-align: right;">Total Harga</th>
                </tr>
                </thead>
                <tbody>
                <?php
                $no=1;
                $sub=0;
                $ongkir=0;
                foreach ($databarang as $hasil) {
                    ?>
                    <tr>
                        <td><?php echo $no ?></td>
                        <td><?php echo $hasil->kode_barang ?></td>
                        <td><?php echo $hasil->barang ?></td>
                        <td style="text-align: center;"><?php echo $hasil->jumlah_keluar ?></td>
                        <td style="text-align: right;"><?php echo 'Rp '.number_format($hasil->harga_satuan,0,',','.') ?></td>
                        <td style="text-align: right;"><?php echo 'Rp '.number_format($hasil->total_harga,0,',','.') ?></td>
                    </tr>
                    <?php
                    $no++;
                    $sub=$sub+$hasil->total_harga;
                    $ongkir=$ongkir+($hasil->fee/100*$hasil->total_harga);
                }
                ?>
                </tbody>
                </table>
            </div>
            <div class="row">
                <div class="col-lg-7 col-sm-7">

                </div>
                <div class="col-lg-5 col-sm-5 ml-auto">
                    <table class="table table-clear">
                    <tbody>
                    <tr>
                        <td><strong>Subtotal</strong></td>
                        <td style="text-align: right;"><?php echo 'Rp '.number_format($sub,0,',','.') ?></td>
                    </tr>
                    <tr>
                        <td><strong>Biaya Kirim</strong></td>
                        <td style="text-align: right;"><?php echo 'Rp '.number_format($ongkir,0,',','.') ?></td>
                    </tr>
                    <?php
                    $total=$sub+$ongkir;
                    ?>
                    <tr>
                        <td><strong>total</strong></td>
                        <td style="text-align: right;"><?php echo 'Rp '.number_format($total,0,',','.') ?></td>
                    </tr>
                    </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    window.print();
</script>
</body>
</html>