<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo @$title ?></title>
    <style type="text/css">
    body {
        font-family: tahoma;
        font-size: 8pt;
    }
    hr { 
        display: block;
        margin-top: 0.5em;
        margin-bottom: 0.5em;
        margin-left: auto;
        margin-right: auto;
        border-style: inset;
        border-width: 1px;
    } 
    .container {
        padding: 10px 15px 10px 15px;
        aspect-ratio: 100 / 29;
    }
    .tabelku {
        width: 100%;
        font-size: 8pt;
        font-family: calibri; 
        border-collapse: collapse;
    }
    .tabelku  td {
        padding-left:5px;
        border-bottom: 1px double black;
    }
    </style>
</head>
<body>
<div class="container">
    <table width="100%">
    <tr>
        <td width="15%">Tanggal: <?php echo @$tanggal ?></td>
        <th>BARANG MASUK</th>
        <td width="15%">Kode: <?php echo @$kode ?></td>
    </tr>
    </table>
    <hr>
    <table width="100%">
    <tr>
        <td width="65%"></td>
        <td>
            <h3>Dari:</h3>
            <strong><?php echo @$suplier ?></strong><br>
            <?php echo @$alamatsuplier ?><br>
            <?php echo @$teleponsuplier ?>
        </td>
    </tr> 
    </table>
    <br>
    <table class="tabelku" border="0">
    <thead>
    <tr>
        <th class="center">#</th>
        <th>Kode Barang</th>
        <th>Barcode</th>
        <th>Nama Barang</th>
        <th style="text-align: center;">Jumlah Permintaan</th>
        <th style="text-align: center;">Jumlah Masuk</th>
        <th style="text-align: right;">Harga Satuan</th>
        <th style="text-align: right;">Harga Eceran</th>
        <th style="text-align: right;">Total Harga</th>
    </tr>
    </thead>
    <tbody>
    <?php
    $no=1;
    $total=0;
    foreach ($databarang as $hasil) {
        ?>
        <tr>
            <td><?php echo $no ?></td>
            <td><?php echo $hasil->kode_barang ?></td>
            <td><?php echo $hasil->barcode ?></td>
            <td><?php echo $hasil->barang ?></td>
            <td style="text-align: center;"><?php echo $hasil->jumlah.' '.$hasil->satuan ?></td>
            <td style="text-align: center;"><?php echo $hasil->jumlah_diterima.' '.$hasil->satuan_diterima ?></td>
            <td style="text-align: right;"><?php echo 'Rp '.number_format($hasil->harga_satuan_diterima,0,',','.') ?></td>
            <td style="text-align: right;"><?php echo 'Rp '.number_format($hasil->harga_eceran_diterima,0,',','.') ?></td>
            <td style="text-align: right;"><?php echo 'Rp '.number_format($hasil->total_harga_diterima,0,',','.') ?></td>
        </tr>
        <?php
        $no++;
        $total=$total+$hasil->total_harga_diterima;
    }
    ?>
    </tbody>
    <tfoot>
    <tr>
        <th colspan="8">Total Harga</th>
        <th style="text-align: right;"><?php echo 'Rp '.number_format($total,0,',','.') ?></th>
    </tr>
    </tfoot>
    </table>
    <div style="font-size: 5pt;">Diinput pada: <?php echo @date('d-m-Y H:i:s',strtotime($input)) ?></div>
</div>
<script type="text/javascript">
    window.print();
</script>
</body>
</html>