<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Transaksi Barang Masuk</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item">Transaksi</li>
                        <li class="breadcrumb-item active"><a href="#">Barang Masuk</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-10">
                                    <div class="form-group">
                                        <label>Kode Permintaan</label>
                                        <div class="input-group mb-3">
                                            <button type="button" class="input-group-text btn btn-secondary" title="Cari kode permintaan" onclick="tampilminta()"><i class="fa fa-search"></i></button>
                                            <input type="text" class="form-control" id="kode" name="kode" autocomplete="0" autofocus>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label style="color: white;">&nbsp;</label>
                                        <button type="button" class="btn bg-gradient-primary" onclick="tampilkan()" style="width: 100%;"><i class="fa fa-search"></i> Cari</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="konten"></div>
                        </div>
                        <div class="card-footer">
                            <form method="post" id="formasuk">
                                <div class="row">
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Tanggal Datang</label>
                                            <input type="date" class="form-control" id="tanggal" name="tanggal" value="<?php echo @$tanggal ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Nomor Nota</label>
                                            <input type="text" class="form-control" id="nota" name="nota" value="<?php echo @$nota ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Telah Dibayar</label>
                                            <input type="number" class="form-control" id="terbayar" name="terbayar" value="<?php echo @$terbayar ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Belum Dibayar</label>
                                            <input type="number" class="form-control" id="utang" name="utang" value="<?php echo @$utang ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Tanggal Tempo</label>
                                            <input type="date" class="form-control" id="tempo" name="tempo" value="<?php echo @$tempo ?>" required>
                                        </div>
                                    </div>
                                    <input type="hidden" name="po" id="po" value="">
                                    <input type="hidden" name="catatan" id="catatan" value="">
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="submit" class="btn bg-gradient-success" style="width: 100%;"><i class="fa fa-save"></i> Simpan</button>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <a href="<?php echo base_url('transaksi/masuk') ?>" style="width: 100%;" class="btn btn-danger"><i class="fa fa-times"></i> Kembali</a>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- modal permintaan -->
<div class="modal fade" id="modalminta">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Permintaan Barang</h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <table class="table table-hover datatable" style="width: 100%" id="tabelku">
                <thead>
                <tr>
                    <th>Kode Permintaan</th>
                    <th>Suplier</th>
                    <th>Jumlah Item</th>
                    <th>Status</th>
                    <th width="2%"></th>
                </tr>
                </thead>
                <tbody></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" onclick="represh()"><i class="fa fa-sync"></i> Refresh</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-times"></i> Tutup</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal konfirmasi -->
<div class="modal fade" id="modalkonfirmasi">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-body">
                <h4>Apakah akan menyimpan barang masuk ini?</h4>
            </div>
            <div class="modal-footer right-content-between">
                <button type="button" id="hapus" value="" onclick="ajusmen()" class="btn bg-gradient-success"><i class="fa fa-save"></i> Simpan</button>
                <button type="button" class="btn bg-gradient-danger" data-dismiss="modal"><i class="fa fa-times"></i> Batal</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- End #main -->
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    tampilkan();
    $("#tabelku").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "ajax":{
                url:"<?php echo base_url('transaksi/dataminta') ?>",
                type:"post",
        },
    });
});

$(function(){
    $("#formasuk").submit(function(event) {
        $("#modalkonfirmasi").modal("show");
        return false;
    });
});

function tampilminta() {
    $("#modalminta").modal("show");
}

function represh() {
    $("#tabelku").DataTable().draw();
}

function pilihminta(i) {
    $("#kode").val(i);
    $("#modalminta").modal("hide");
    tampilkan();
}

function ajusmen() {
    $("#modalkonfirmasi").modal("hide");
    $.ajax({
        url:"<?php echo base_url('transaksi/simpan_ajusmenmasuk') ?>",
        cache: false,
        type:"POST",
        data:$("#formasuk").serialize(),
        dataType:"JSON",
        beforeSend: function(){
            $("#konten").html('<center><img src="<?php echo base_url('assets/images/loading.gif') ?>"></center>');
        },
        success:function(result) {
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            $("#kode").val("");
            $("#nota").val("");
            $("#terbayar").val("");
            $("#utang").val("");
            $("#tempo").val("");
            $("#tabelku").DataTable().draw();
            tampilkan();
        }
    });
}

function tampilkan() {
    var kode=$("#kode").val();
    $.ajax({
        url:"<?php echo base_url('transaksi/ajax_masuk') ?>",
        cache: false,
        type:"POST",
        data:{kode:kode},
        beforeSend: function(){
            $("#konten").html('<center><img src="<?php echo base_url('assets/images/loading.gif') ?>"></center>');
        },
        success:function(result) {
            $("#konten").html(result);
            $("#po").val(kode);
        }
    });
}

function simpan(i) {
    var id=$("#id"+i).val();
    var diterima=$("#diterima"+i).val();
    var hargabeli=$("#hargabeli"+i).val();
    var hargaecer=$("#hargaecer"+i).val();
    var satuan=$("#satuan"+i).val();
    totalharga=diterima*hargabeli;
    rupiah=new Intl.NumberFormat("id-ID",{
            style:"decimal",
            currency:"IDR"
            }).format(totalharga);
    $("#tot"+i).html(rupiah);
    $.ajax({
        url:"<?php echo base_url('transaksi/simpan_masuk') ?>",
        cache: false,
        type:"POST",
        data:{id:id,diterima:diterima,hargabeli:hargabeli,hargaecer:hargaecer,satuan:satuan},
        success:function(result) {
            $("#peringatan").html(result);
        }
    })
}
</script>
<?php @$this->load->view($footerend) ?>