<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Transaksi Mutasi Barang Keluar</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item">Transaksi</li>
                        <li class="breadcrumb-item active"><a href="#">Mutasi Barang Keluar</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <div class="card-header">
                            <form method="post" id="formdata">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Kode Barang</label>
                                            <div class="input-group mb-3">
                                                <button type="button" class="input-group-text btn btn-secondary" title="Cari barang" onclick="tampilbarang()"><i class="fa fa-search"></i></button>
                                                <input type="text" class="form-control" id="kode" name="kode" onblur="ubahbarcode(this.value)" autocomplete="0" autofocus>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Jumlah</label>
                                            <input type="text" name="jumlah" id="jumlah" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Satuan</label>
                                            <select name="satuan" id="satuan" class="form-control"></select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label style="color: white;">&nbsp;</label>
                                            <button type="submit" class="btn btn-success" style="width: 100%;"><i class="fa fa-plus"></i> Tambah</button>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="form-label"><strong>Total Harga</strong></label>
                                            <h3 id="toha" style="color: black; font-weight: bold; text-align: right;">-</h3>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="card-body">
                            <table class="table table-hover" id="tabelkeranjang" style="width: 100%;">
                            <thead>
                            <tr>
                                <th>Kode Barang</th>
                                <th>Barcode</th>
                                <th>Nama Barang</th>
                                <th>Jumlah</th>
                                <th>Total Harga</th>
                                <th width="2%"></th>
                            </tr>
                            </thead>
                            <tbody></tbody>
                            </table>
                        </div>
                        <div class="card-footer">
                            <form method="post" id="formjual">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Toko Tujuan</label>
                                            <div class="input-group">
                                                <select class="form-control" id="toko" name="toko" required>
                                                    <option value="">-- pilih toko --</option>
                                                    <?php
                                                    foreach ($datatoko as $hasil) {
                                                        ?>
                                                        <option value="<?php echo $hasil->kode_toko ?>"><?php echo $hasil->toko ?></option>
                                                        <?php
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Total Harga</label>
                                            <input type="text" name="total" id="total" class="form-control" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="submit" class="btn btn-primary" style="width: 100%;" id="btnbayar" value="simpan" title="Simpan"><i class="fa fa-save"></i> Simpan</button>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <a href="<?php echo base_url('transaksi/mutasikeluar') ?>" style="width: 100%;" class="btn btn-danger"><i class="fa fa-times"></i> Batal</a>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- modal utama -->
<div class="modal fade" id="modalbarang">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Transaksi Penjualan</h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <table class="table table-hover datatable" style="width: 100%" id="tabelbarang">
                <thead>
                <tr>
                    <th>Kode Barang</th>
                    <th>Barcode</th>
                    <th>Nama Barang</th>
                    <th>Harga</th>
                    <th>Stok</th>
                    <th width="2%"></th>
                </tr>
                </thead>
                <tbody></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" onclick="represh()"><i class="fa fa-refresh"></i> Refresh</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-times"></i> Tutup</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal hapus -->
<div class="modal fade" id="modalhapus">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-body">
                <h4>Apakah akan menghapus barang dari daftar transaksi?</h4>
            </div>
            <div class="modal-footer right-content-between">
                <button type="button" id="hapus" value="" onclick="hapusdata(this.value)" class="btn bg-gradient-danger"><i class="fa fa-trash"></i> Hapus</button>
                <button type="button" class="btn bg-gradient-primary" data-dismiss="modal"><i class="fa fa-times"></i> Batal</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- End #main -->
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    totalharga();
    $("#tabelbarang").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "ajax":{
                url:"<?php echo base_url('transaksi/databarang') ?>",
                type:"post",
        },
    });

    $("#tabelkeranjang").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "searching": false,
        "paging": false,
        "bInfo" : false,
        "sDom": 't',
        "ajax":{
                url:"<?php echo base_url('transaksi/datakeranjangmutasikeluar') ?>",
                type:"post",
        },
    });
    
    //tombol keyboard untuk pindah satuan
    $("#jumlah").keydown(function(e){
        if (e.which==39) {
           $("#satuan").focus();
        } else if (e.which==37) {
            $("#kode").focus();
        }
    });
    
    $("#kode").keydown(function(e){
        if (e.which==39 || e.which==13) {
           $("#jumlah").focus();
           ubahbarcode(this);
        }
    });
    
    $("#satuan").keypress(function(e){
        if (e.which==13) {
            event.preventDefault();
            $("#formdata").submit();
        } else if (e.which==37) {
            $("#jumlah").focus();
        }
    });
    
    $("#satuan").keydown(function(e){
        if (e.which==37) {
           $("#jumlah").focus();
        }
    });
});

$(function(){
    $("#formdata").submit(function(event){
        var jumlah=$("#jumlah").val();
        event.preventDefault();
        if (jumlah==0 || jumlah=='') {
            $("#jumlah").focus();
        } else {
            $.ajax({
                url:"<?php echo base_url('transaksi/simpan_keranjangmutasikeluar') ?>",
                cache: false,
                type:"POST",
                data:$(this).serialize(),
                dataType:"JSON",
                success:function(result) {
                    $("#peringatan").html(result.pesan);
                    if (result.ikon=='success') {
                        toastr.success(result.toas);
                    } else if (result.ikon=='warning') {
                        toastr.warning(result.toas);
                    } else if (result.ikon=='error') {
                        toastr.error(result.toas);
                    }
                    $("#tabelku").DataTable().draw();
                    $("#tabelkeranjang").DataTable().draw();
                    $("#formdata").trigger("reset");
                    $("#kode").focus();
                    $("#satuan").html("");
                    totalharga();
                }
            })
        }
    });
});

$(function(){
    $("#formjual").submit(function(event){
        event.preventDefault();
        $.ajax({
            url:"<?php echo base_url('transaksi/simpan_mutasikeluar') ?>",
            cache: false,
            type:"POST",
            data:$(this).serialize(),
            dataType:"JSON",
            success:function(result) {
                $("#peringatan").html(result.pesan);
                if (result.ikon=='success') {
                    toastr.success(result.toas);
                } else if (result.ikon=='warning') {
                    toastr.warning(result.toas);
                } else if (result.ikon=='error') {
                    toastr.error(result.toas);
                }
                $("#tabelku").DataTable().draw();
                $("#tabelkeranjang").DataTable().draw();
                $("#modalform").modal("hide");
                $("#toko").val("");
                $("#kode").focus();
                if (result.faktur) {
                    window.open("<?php echo base_url('transaksi/cetak_mutasikeluar?id=') ?>"+result.faktur)
                }
                totalharga();
            }
        });
    });
});

$(function() { 
    $("#kode").autocomplete({
        source: function(request,response) {
            $.ajax({
                url:"<?php echo base_url('transaksi/jbarang') ?>",
                dataType:"JSON",
                data:{id:request.term},
                type:"POST",
                success: function(data) {
                    response(data);
                }
            });
        },
        minLength:3
    });
});

$(".modal").on("shown.bs.modal", function(e) {
   $("div.dataTables_filter input").focus();
});

function carisatuan() {
    var kode=$("#kode").val();
    $.ajax({
        url:"<?php echo base_url('transaksi/jsatuanbarang') ?>",
        cache:false,
        type:"POST",
        data:{id:kode},
        success:function(result){
            $("#satuan").html(result);
        }
    });
}

function tampilbarang() {
    $("#modalbarang").modal("show");
}

function represh() {
    $("#tabelku").DataTable().draw();
    $("#tabelkeranjang").DataTable().draw();
    $("#tabelmember").DataTable().draw();
    totalharga();
}

function pilihbarang(i) {
    $("#kode").val(i);
    $("#modalbarang").modal("hide");
    $("#jumlah").focus();
}

function konfirhapus(i) {
    $("#hapus").val(i);
    $("#modalhapus").modal("show");
}

function hapusdata(str) {
    $.ajax({
        url:"<?php echo base_url('transaksi/hapus_keranjang') ?>",
        cache:false,
        type:"POST",
        data:{id:str},
        dataType:"JSON",
        success:function(result){
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            $("#modalhapus").modal("hide");
            $("#tabelku").DataTable().draw();
            $("#tabelkeranjang").DataTable().draw();
            $("#kode").focus();
            totalharga();
        }
    });
}

function totalharga() {
    var toko=$("#toko").val();
    $.ajax({
        url:"<?php echo base_url('transaksi/harga_mutasikeluar') ?>",
        cache:false,
        type:"POST",
        data:{toko:toko},
        success:function(result){
            rupiah=new Intl.NumberFormat("id-ID",{
                        style:"decimal",
                        currency:"IDR"
                    }).format(result);
            $("#total").val(result);
            $("#toha").html("Rp "+rupiah);
        }
    });
}

function ubahbarcode(i) {
    brcd=i.split(" - ");
    $("#kode").val(brcd[0]);
    carisatuan();
}
</script>
<?php @$this->load->view($footerend) ?>