<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Form Permintaan Barang</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item">Transaksi</li>
                        <li class="breadcrumb-item active"><a href="#">Permintaan Barang</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Tanggal</label>
                                        <input type="date" class="form-control" id="tanggal" name="tanggal" value="<?php echo @$tanggal ?>">
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label>Suplier</label>
                                        <select class="form-control" id="suplier" name="suplier" required>
                                            <option value="">-- pilih suplier --</option>
                                            <?php
                                            foreach ($datasuplier as $hasil) {
                                                ?>
                                                <option value="<?php echo $hasil->kode_suplier ?>"><?php echo $hasil->suplier ?></option>
                                                <?php
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label style="color: white;">&nbsp;</label>
                                        <button type="button" class="btn btn-primary" style="width: 100%;" onclick="tampilkan()"><i class="fa fa-sync"></i> Tampilkan</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" id="formbarang"></form>
                        </div>
                        <div class="card-footer">
                            <input type="hidden" name="id" id="id" value="<?php echo @$kode ?>">
                            <button type="button" class="btn btn-success" onclick="simpan()"><i class="fa fa-save"></i> Simpan</button>
                            <a href="<?php echo base_url('transaksi/permintaan') ?>" class="btn btn-danger"><i class="fa fa-times"></i> Kembali</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End #main -->
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(function(){
    $("#formdata").submit(function(event){
        event.preventDefault();
        $.ajax({
            url:"<?php echo base_url('transaksi/simpan_keranjangpermintaan') ?>",
            cache: false,
            type:"POST",
            data:$(this).serialize(),
            dataType:"JSON",
            success:function(result) {
                $("#peringatan").html(result.pesan);
                if (result.ikon=='success') {
                    toastr.success(result.toas);
                } else if (result.ikon=='warning') {
                    toastr.warning(result.toas);
                } else if (result.ikon=='error') {
                    toastr.error(result.toas);
                }
                $("#tabelku").DataTable().draw();
                $("#tabelkeranjang").DataTable().draw();
                $("#formdata").trigger("reset");
                $("#kode").focus();
            }
        })
    });
});

function tampilkan() {
    var suplier=$("#suplier").val();
    $.ajax({
        url:"<?php echo base_url('transaksi/ajax_permintaan') ?>",
        cache:false,
        type:"POST",
        data:{id:suplier},
        beforeSend: function(){
            $("#formbarang").html('<center><img src="<?php echo base_url('assets/images/loading.gif') ?>"></center>');
        },
        success:function(result) {
            $("#formbarang").html(result);
        }
    });
}

function simpan() {
    var tanggal=$("#tanggal").val();
    var suplier=$("#suplier").val();
    event.preventDefault();
    $.ajax({
        url:"<?php echo base_url('transaksi/simpan_permintaan') ?>",
        cache: false,
        type:"POST",
        data:$("#formbarang").serialize()+"&suplier="+suplier+"&tanggal="+tanggal,
        dataType:"JSON",
        beforeSend: function(){
            $("#formbarang").html('<center><img src="<?php echo base_url('assets/images/loading.gif') ?>"></center>');
        },
        success:function(result) {
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            $("#suplier").val("");
            $("#suplier").focus();
            tampilkan();
        }
    })
}
</script>
<?php @$this->load->view($footerend) ?>