<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Retur Penjualan</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item">Transaksi</li>
                        <li class="breadcrumb-item active"><a href="#">Retur Penjualan</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-10">
                                    <div class="form-group">
                                        <label>Nomor Nota Penjualan</label>
                                        <div class="input-group mb-3">
                                            <button type="button" class="input-group-text btn btn-secondary" title="Cari nota" onclick="tampilnota()"><i class="fa fa-search"></i></button>
                                            <input type="text" class="form-control" id="nota" name="nota" autofocus>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label style="color: white;">&nbsp;</label>
                                        <button type="submit" class="btn btn-primary" style="width: 100%;" onclick="tampilkan()"><i class="fa fa-search"></i> Tampilkan</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="konten"></div>
                        </div>
                        <div class="card-footer">
                            <button type="button" class="btn btn-success" onclick="simpan()"><i class="fa fa-save"></i> Simpan</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modalnota">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Nota Penjualan</h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <table class="table table-hover datatable" style="width: 100%" id="tabelku">
                <thead>
                <tr>
                    <th>Nomor Nota</th>
                    <th>Tanggal</th>
                    <th>Jumlah Barang</th>
                    <th>Total Harga</th>
                    <th width="2%"></th>
                </tr>
                </thead>
                <tbody></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" onclick="represh()"><i class="fa fa-refresh"></i> Refresh</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-times"></i> Tutup</button>
            </div>
        </div>
    </div>
</div>
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    tampilkan();
    $("#tabelku").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "ajax":{
                url:"<?php echo base_url('transaksi/datanota') ?>",
                type:"post",
        },
    });
});

function simpan() {
    var nota=$("#nota").val();
    $.ajax({
        url:"<?php echo base_url('transaksi/simpan_returjual') ?>",
        cache: false,
        type:"POST",
        data:$("#barangretur").serialize(),
        dataType:"JSON",
        beforeSend: function(){
            $("#konten").html('<center><img src="<?php echo base_url('assets/images/loading.gif') ?>"></center>');
        },
        success:function(result) {
            $("#peringatan").html(result.pesan);
            $("#nota").val("");
            $("#tabelku").DataTable().draw();
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            window.open("<?php echo base_url('transaksi/cetak_returjual?id=') ?>"+result.id);
            tampilkan();
        }
    });
}

function tampilnota() {
    $("#modalnota").modal("show");
}

function pilihnota(i) {
    $("#nota").val(i);
    $("#modalnota").modal("hide");
    tampilkan();
}

function represh() {
    $("#tabelku").DataTable().draw();
}

function tampilkan() {
    var nota=$("#nota").val();
    $.ajax({
        url:"<?php echo base_url('transaksi/ajax_returjual') ?>",
        cache: false,
        type:"POST",
        data:{nota:nota},
        beforeSend: function(){
            $("#konten").html('<center><img src="<?php echo base_url('assets/images/loading.gif') ?>"></center>');
        },
        success:function(result) {
            $("#konten").html(result);
        }
    });
}
</script>
<?php @$this->load->view($footerend) ?>
<!-- Page specific script -->