<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Api extends CI_Controller {
	public function __construct() {
		parent::__construct();
		$this->load->model('model_crud');
		$this->load->model('model_laporan');
	}

	public function index() {
      	$method=$this->input->post('method');
		if ($method=='penjualan') {
			$this->penjualan();
		} else if ($method=='riwayat') {
			$this->riwayat();
		} else if ($method=='simpan_transaksi') {
			$this->simpan_transaksi();
		} else if ($method=='cek_status') {
			$this->cek_status();
		} else if ($method=='penangguhan') {
			$this->penangguhan();
		} else if ($method=='membuattagihan') {
			$this->membuattagihan();
		}
	}

	public function penjualan() {
		$awal=$this->input->post('awal');
        $akhir=$this->input->post('akhir');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
        $selek='tb_penjualan.faktur_jual,tb_penjualan.tanggal,tb_penjualanmeta.kode_barang,potongan,jumlah_jual,tb_penjualanmeta.konversi,tb_penjualanmeta.satuan_ecer,total_harga,barang,pegawai';
        $query=$this->model_laporan->datajualdetail($selek,$kunci);
        $datajual=$query->result();
        echo json_encode($datajual);
	}
}