<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Beranda extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if ($this->session->userdata('kp')=='') {
			redirect('login');
		}
		$this->load->model('model_crud');
	}

	public function index() {
	    $this->load->helper('umum');
	    $this->load->model('model_laporan');
	    $tanggal=date('Y-m-d');
	    $tglupdate=date('Y-m-d H:i:s');
	    $kunci=array('stok>='=>0,'aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_barang');
		$databarang=$query->result();
		$totinv=0;
		foreach ($databarang as $hasil) {
			$totinv=$totinv+($hasil->stok*$hasil->harga_beli);
		}
		//masukan ke tabel inventori
		$kunci=array('tanggal'=>$tanggal);
		$query=$this->model_crud->ambil_data($kunci,'tb_inventori');
		$cek=$query->num_rows();
		if ($cek) {
			//update data
			$isi=array('total'=>$totinv,'tgl_update'=>$tglupdate);
			$this->model_crud->update_data($kunci,'tb_inventori',$isi);
		} else {
			$isi=array('tanggal'=>$tanggal,'total'=>$totinv,'tgl_update'=>$tglupdate);
			$this->model_crud->tambah_data('tb_inventori',$isi);
		}
        $data['totinv']=$totinv;
        //ambil data penjualan
        $kunci=array("DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')"=>$tanggal);
        $selek='tb_penjualan.faktur_jual,tb_penjualan.tanggal,tb_penjualanmeta.kode_barang,potongan,jumlah_jual,tb_penjualanmeta.konversi,tb_penjualanmeta.satuan_jual,tb_penjualanmeta.harga_beli,total_harga,barang,pegawai';
        $query=$this->model_laporan->datajualdetail($selek,$kunci);
        $datajual=$query->result();
        $totpendapatan=0;
        $tothpp=0;
        foreach ($datajual as $hasil) {
            $totpendapatan=$totpendapatan+$hasil->total_harga;
            $tothpp=$tothpp+(($hasil->jumlah_jual*$hasil->konversi)*$hasil->harga_beli);
        }
        $data['totpendapatan']=$totpendapatan;
        $data['untung']=$totpendapatan-$tothpp;
        $data['tanggal']=tanggalindo($tanggal);
        $data['tahun']=date('Y');
		$data['title']='Aplikasi Kasir Toko';
		$data['template']='beranda/view_beranda';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_grafikjual() {
		$tahun=$this->input->post('tahun');
		$data['tahun']=$tahun;
		$this->load->view('beranda/ajax_grafikjual',$data);
	}

	public function password() {
		$data['title']="Ganti Password";
		$data['template']='panel/beranda/form_password';
		$data['footer']='panel/layout/footer';
		$data['footerend']='panel/layout/footerend';
		$this->load->view('panel/layout/wrapper',$data);
	}

	public function simpan_password() {
		$pass1=$this->input->post('pass1');
		$pass2=$this->input->post('pass2');
		$pass3=$this->input->post('pass3');
		$admin=$this->session->userdata('nanda');
		if ($pass2==$pass3) {
			$kunci=array('username'=>$admin,'password'=>md5($pass1));
			$query=$this->model_crud->ambil_data($kunci,'tb_admin');
			$cek=$query->num_rows();
			if ($cek) {
				$isi=array('password'=>md5($pass2));
				$simpan=$this->model_crud->update_data($kunci,'tb_admin',$isi);
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Password berhasil diubah
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Password berhasil diubah';
				$ikon='success';
			} else {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Password lama masih salah!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Password lama masih salah!';
				$ikon='error';
			}
		} else {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Password baru belum cocok!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Password baru belum cocok!';
			$ikon='error';
		}
		$arr=array('pesan'=>$pesan, 'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}
}