<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Laporan extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if ($this->session->userdata('kp')=='') {
			redirect('login');
		}
		$this->load->model('model_crud');
		$this->load->model('model_laporan');
	}

	public function index() {
		redirect('laporan/masuk');
	}

	public function setoran() {
		$kp=$this->session->userdata('kp');
		$level=$this->session->userdata('level');
		//ambil data pegawai
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_pegawai');
		$data['datapegawai']=$query->result();
		$data['level']=$level;
        $data['awal']=date('Y-m').'-01';
        $data['akhir']=date('Y-m-d');
		$data['title']='Laporan Setoran Penjualan';
		$data['template']='laporan/view_setoran';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_setoran() {
		$awal=$this->input->post('awal');
		$akhir=$this->input->post('akhir');
		$pegawai=$this->input->post('pegawai');
		//ambil data setoran
		$kunci=array();
		if ($awal) {
			$kunci['tanggal>=']=$awal;
		}
		if ($akhir) {
			$kunci['tanggal<=']=$akhir;
		}
		if ($pegawai) {
			$kunci['kode_pegawai']=$pegawai;
		}
		$query=$this->model_crud->ambil_data($kunci,'tb_setoran');
		$datasetor=$query->result();
		$data['datasetor']=$datasetor;
		$this->load->view('laporan/ajax_setoran',$data);
	}

	public function masuk() {
		$kp=$this->session->userdata('kp');
		$level=$this->session->userdata('level');
		//ambil data suplier
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_suplier');
		$data['datasuplier']=$query->result();
		$data['level']=$level;
        $data['awal']=date('Y-m').'-01';
        $data['akhir']=date('Y-m-d');
		$data['title']='Laporan Barang Masuk';
		$data['template']='laporan/view_masuk';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_masuk() {
		$kp=$this->session->userdata('kp');
		$awal=$this->input->post('awal');
        $akhir=$this->input->post('akhir');
        $suplier=$this->input->post('suplier');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_masuk.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_masuk.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
        if ($suplier) {
            $kunci['tb_permintaan.kode_suplier']=$suplier;
        }
        $selek='tb_masuk.no_nota,tb_masuk.tanggal,tb_permintaanmeta.kode_barang,jumlah_diterima,tb_permintaanmeta.satuan,total_harga_diterima,harga_satuan_diterima,barang,suplier';
        $query=$this->model_laporan->datamasukdetail($selek,$kunci);
        $data['datamasuk']=$query->result();
        $this->load->view('laporan/ajax_masuk',$data);
	}

	public function xls_masuk() {
		$kp=$this->session->userdata('kp');
		$awal=$this->input->get('awal');
        $akhir=$this->input->get('akhir');
        $suplier=$this->input->get('suplier');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_masuk.tanggal,'%Y-%m-%d')>="]=$awal;
			$data['awal']=date('d-m-Y',strtotime($awal));
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_masuk.tanggal,'%Y-%m-%d')<="]=$akhir;
			$data['akhir']=date('d-m-Y',strtotime($akhir));
		}
        if ($suplier) {
			$kunci['tb_permintaan.kode_suplier']=$suplier;
        }
		$selek='tb_masuk.no_nota,tb_masuk.kode_permintaan,tb_masuk.tanggal,tb_permintaanmeta.kode_barang,jumlah_diterima,tb_permintaanmeta.satuan,total_harga_diterima,harga_satuan_diterima,barang,suplier';
        $query=$this->model_laporan->datamasukdetail($selek,$kunci);
        $data['datamasuk']=$query->result();
        $this->load->view('laporan/xls_masuk',$data);
	}

	public function beli() {
        $data['awal']=date('Y-m').'-01';
        $data['akhir']=date('Y-m-d');
        //ambil data suplier
        $kunci=array('aktif'=>1);
        $query=$this->model_crud->ambil_data($kunci,'tb_suplier');
        $data['datasuplier']=$query->result();
		$data['title']='Laporan Pembelian';
		$data['template']='laporan/view_beli';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_beli() {
		$kp=$this->session->userdata('kp');
		$awal=$this->input->post('awal');
        $akhir=$this->input->post('akhir');
        $suplier=$this->input->post('suplier');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_pembelian.tgl_beli,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_pembelian.tgl_beli,'%Y-%m-%d')<="]=$akhir;
		}
        if ($suplier) {
            $kunci['tb_pembelian.kode_suplier']=$suplier;
        }
        $selek='tb_pembelian.nota_beli,tb_pembelian.tgl_beli,tb_pembelianmeta.kode_barang,jumlah_beli,tb_pembelianmeta.konversi,tb_pembelianmeta.satuan_grosir,total_harga,barang,suplier,pegawai';
        $query=$this->model_laporan->databelidetail($selek,$kunci);
        $data['databeli']=$query->result();
        $this->load->view('laporan/ajax_beli',$data);
	}

	public function xls_beli() {
		$kp=$this->session->userdata('kp');
		$awal=$this->input->get('awal');
        $akhir=$this->input->get('akhir');
        $suplier=$this->input->get('suplier');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_pembelian.tgl_beli,'%Y-%m-%d')>="]=$awal;
			$data['awal']=date('d-m-Y',strtotime($awal));
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_pembelian.tgl_beli,'%Y-%m-%d')<="]=$akhir;
			$data['akhir']=date('d-m-Y',strtotime($akhir));
		}
        if ($suplier) {
            $kunci['tb_pembelian.kode_suplier']=$suplier;
        }
        $selek='tb_pembelian.nota_beli,tb_pembelian.tgl_beli,tb_pembelianmeta.kode_barang,jumlah_beli,tb_pembelianmeta.konversi,tb_pembelianmeta.satuan_grosir,total_harga,barang,suplier,pegawai';
        $query=$this->model_laporan->databelidetail($selek,$kunci);
        $data['databeli']=$query->result();
        $this->load->view('laporan/xls_beli',$data);
	}

	public function jual() {
		$kp=$this->session->userdata('kp');
		$level=$this->session->userdata('level');
		//ambil data pegawai
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_pegawai');
		$data['datapegawai']=$query->result();
		$data['level']=$level;
        $data['awal']=date('Y-m').'-01';
        $data['akhir']=date('Y-m-d');
		$data['title']='Laporan Penjualan';
		$data['template']='laporan/view_jual';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_jual() {
		$kp=$this->session->userdata('kp');
		$level=$this->session->userdata('level');
		$awal=$this->input->post('awal');
        $akhir=$this->input->post('akhir');
		$pegawai=$this->input->post('pegawai');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
		if ($level=='Administrator') {
			if ($pegawai) {
				$kunci['tb_penjualan.kode_pegawai']=$pegawai;
			}
		} else {
			$kunci['tb_penjualan.kode_pegawai']=$kp;
		}
        $selek='tb_penjualan.faktur_jual,tb_penjualan.tanggal,tb_penjualanmeta.kode_barang,potongan,jumlah_jual,tb_penjualanmeta.konversi,tb_penjualanmeta.satuan_jual,total_harga,barang,pegawai';
        $query=$this->model_laporan->datajualdetail($selek,$kunci);
        $data['datajual']=$query->result();
        $this->load->view('laporan/ajax_jual',$data);
	}

	public function xls_jual() {
		$kp=$this->session->userdata('kp');
		$level=$this->session->userdata('level');
		$awal=$this->input->get('awal');
        $akhir=$this->input->get('akhir');
		$pegawai=$this->input->get('pegawai');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="]=$awal;
			$data['awal']=date('d-m-Y',strtotime($awal));
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="]=$akhir;
			$data['akhir']=date('d-m-Y',strtotime($akhir));
		}

		if ($level=='Administrator') {
			if ($pegawai) {
				$kunci['kode_pegawai']=$pegawai;
			}
		} else {
			$kunci['kode_pegawai']=$kp;
		}
        $selek='tb_penjualan.faktur_jual,tb_penjualan.tanggal,tb_penjualanmeta.kode_barang,potongan,jumlah_jual,tb_penjualanmeta.bonus,tb_penjualanmeta.konversi,tb_penjualanmeta.satuan_jual,total_harga,barang,pegawai';
        $query=$this->model_laporan->datajualdetail($selek,$kunci);
        $data['datajual']=$query->result();
        $this->load->view('laporan/xls_jual',$data);
	}

	public function rekapjual() {
		$kp=$this->session->userdata('kp');
		$level=$this->session->userdata('level');
		//ambil data pegawai
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_pegawai');
		$data['datapegawai']=$query->result();
		$data['level']=$level;
        $data['awal']=date('Y-m').'-01';
        $data['akhir']=date('Y-m-d');
		$data['title']='Laporan Rekap Penjualan';
		$data['template']='laporan/view_rekapjual';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_rekapjual() {
		$kp=$this->session->userdata('kp');
		$level=$this->session->userdata('level');
		$awal=$this->input->post('awal');
        $akhir=$this->input->post('akhir');
		$pegawai=$this->input->post('pegawai');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
		if ($level=='Administrator') {
			if ($pegawai) {
				$kunci['tb_penjualan.kode_pegawai']=$pegawai;
			}
		} else {
			$kunci['tb_penjualan.kode_pegawai']=$kp;
		}
        $selek='tb_penjualan.faktur_jual,tb_penjualan.kode_pegawai,tb_penjualan.tanggal,COUNT(tb_penjualanmeta.kode_barang) AS jumlah_barang,SUM(potongan) AS potongan,SUM(jumlah_jual*tb_penjualanmeta.konversi) AS jumlah_jual,SUM(total_harga) total_harga,SUM(tb_penjualanmeta.harga_beli) AS harga_beli,pegawai';
        $query=$this->model_laporan->datarekapjual($selek,$kunci);
        $datajual=$query->result();
		$arrpegawai=array();
		$arrjualrinci=array();
		foreach ($datajual as $hasil) {
			$tgl=date('d-m-Y',strtotime($hasil->tanggal));
			$arrpegawai[$tgl][$hasil->kode_pegawai]=$hasil->pegawai;
			$arrjualrinci[$tgl][$hasil->kode_pegawai]['jumbarang'][$hasil->faktur_jual]=$hasil->jumlah_barang;
			$arrjualrinci[$tgl][$hasil->kode_pegawai]['jumjual'][$hasil->faktur_jual]=$hasil->jumlah_jual;
			$arrjualrinci[$tgl][$hasil->kode_pegawai]['harga'][$hasil->faktur_jual]=$hasil->total_harga;
		}
		$data['arrpegawai']=$arrpegawai;
		$data['arrjualrinci']=$arrjualrinci;
        $this->load->view('laporan/ajax_rekapjual',$data);
	}

	public function xls_rekapjual() {
		$kp=$this->session->userdata('kp');
		$level=$this->session->userdata('level');
		$awal=$this->input->get('awal');
        $akhir=$this->input->get('akhir');
		$pegawai=$this->input->get('pegawai');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
		if ($level=='Administrator') {
			if ($pegawai) {
				$kunci['tb_penjualan.kode_pegawai']=$pegawai;
			}
		} else {
			$kunci['tb_penjualan.kode_pegawai']=$kp;
		}
        $selek='tb_penjualan.faktur_jual,tb_penjualan.kode_pegawai,tb_penjualan.tanggal,COUNT(tb_penjualanmeta.kode_barang) AS jumlah_barang,SUM(potongan) AS potongan,SUM(jumlah_jual*tb_penjualanmeta.konversi) AS jumlah_jual,SUM(total_harga) total_harga,SUM(tb_penjualanmeta.harga_beli) AS harga_beli,pegawai';
        $query=$this->model_laporan->datarekapjual($selek,$kunci);
        $datajual=$query->result();
		$arrpegawai=array();
		$arrjualrinci=array();
		foreach ($datajual as $hasil) {
			$tgl=date('d-m-Y',strtotime($hasil->tanggal));
			$arrpegawai[$tgl][$hasil->kode_pegawai]=$hasil->pegawai;
			$arrjualrinci[$tgl][$hasil->kode_pegawai]['jumbarang'][$hasil->faktur_jual]=$hasil->jumlah_barang;
			$arrjualrinci[$tgl][$hasil->kode_pegawai]['jumjual'][$hasil->faktur_jual]=$hasil->jumlah_jual;
			$arrjualrinci[$tgl][$hasil->kode_pegawai]['harga'][$hasil->faktur_jual]=$hasil->total_harga;
		}
		$data['arrpegawai']=$arrpegawai;
		$data['arrjualrinci']=$arrjualrinci;
		if ($awal) {
			$data['awal']=$awal;
		} else {
			$kunci=array('1'=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_penjualan');
			$cek=$query->row();
			if ($cek) {
				$data['awal']=$cek->tanggal;
			} else {
				$data['awal']=date('Y-m-d');
			}
		}

		if ($akhir) {
			$data['akhir']=$akhir;
		} else {
			$data['akhir']=date('Y-m-d');
		}
        $this->load->view('laporan/xls_rekapjual',$data);
	}

	public function xls_rekapjualdetail() {
		$kp=$this->session->userdata('kp');
		$level=$this->session->userdata('level');
		$awal=$this->input->get('awal');
        $akhir=$this->input->get('akhir');
		$pegawai=$this->input->get('pegawai');
        //mari kita ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
		if ($level=='Administrator') {
			if ($pegawai) {
				$kunci['tb_penjualan.kode_pegawai']=$pegawai;
			}
		} else {
			$kunci['tb_penjualan.kode_pegawai']=$kp;
		}
        $selek='tb_penjualan.tanggal,tb_penjualan.faktur_jual,total,(tb_penjualanmeta.harga_beli*(jumlah_jual*tb_penjualanmeta.konversi)) AS harga_beli';
        $query=$this->model_laporan->datajualdetail($selek,$kunci);
        $datajual=$query->result();
		$arrjualrinci=array();
		foreach ($datajual as $hasil) {
			$tgl=date('d-m-Y',strtotime($hasil->tanggal));
			$arrjualrinci['faktur'][$tgl][$hasil->faktur_jual]=1;
			$arrjualrinci['penjualan'][$tgl][$hasil->faktur_jual]=$hasil->total;
			$arrjualrinci['hpp'][$tgl][]=$hasil->harga_beli;
		}
		if ($awal) {
			$data['awal']=$awal;
		} else {
			$kunci=array('1'=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_penjualan');
			$cek=$query->row();
			if ($cek) {
				$data['awal']=$cek->tanggal;
			} else {
				$data['awal']=date('Y-m-d');
			}
		}

		if ($akhir) {
			$data['akhir']=$akhir;
		} else {
			$data['akhir']=date('Y-m-d');
		}
		$data['arrjualrinci']=$arrjualrinci;
        $this->load->view('laporan/xls_rekapjualrinci',$data);
	}

	public function harga_beli() {
		$kp=$this->session->userdata('kp');
		$member=$this->input->post('member');
		$req=$_REQUEST;
		$kunci=array('tb_keranjang.kode_pegawai'=>$kp,'status'=>'beli');
		$datatab=$this->model_transaksi->datakerjang($req,'data',$kunci,$member);
		$total=0;
		foreach ($datatab as $hasil) {
			$total=$total+$hasil->jum_harga;
		}
		echo $total;
	}
	
	public function rekapjualbarang() {
		$kp=$this->session->userdata('kp');
		$level=$this->session->userdata('level');
		//ambil data pegawai
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_pegawai');
		$data['datapegawai']=$query->result();
		$data['level']=$level;
        $data['awal']=date('Y-m').'-01';
        $data['akhir']=date('Y-m-d');
		$data['title']='Laporan Rekap Penjualan Barang';
		$data['template']='laporan/view_rekapjualbarang';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_rekapjualbarang() {
		$awal=$this->input->post('awal');
		$akhir=$this->input->post('akhir');
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
		$query=$this->model_laporan->datarekapjualbarang($kunci);
		$data['databarang']=$query->result();
		$this->load->view('laporan/ajax_rekapjualbarang',$data);
	}

	public function xls_rekapjualbarang() {
		$awal=$this->input->get('awal');
		$akhir=$this->input->get('akhir');
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="]=$awal;
			$data['awal']=date('d-m-Y',strtotime($awal));
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="]=$akhir;
			$data['akhir']='Sampai '.date('d-m-Y',strtotime($akhir));
		}
		$query=$this->model_laporan->datarekapjualbarang($kunci);
		$data['databarang']=$query->result();
		$this->load->view('laporan/xls_rekapjualbarang',$data);
	}

	public function piutang() {
		$kp=$this->session->userdata('kp');
        $data['awal']=date('Y-m').'-01';
        $data['akhir']=date('Y-m-d');
        //ambil data member
        $kunci=array('aktif'=>1);
        $query=$this->model_crud->ambil_data($kunci,'tb_member');
        $data['datamember']=$query->result();
		$data['title']='Laporan Piutang';
		$data['template']='laporan/view_piutang';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_piutang() {
		$awal=$this->input->post('awal');
		$akhir=$this->input->post('akhir');
		$member=$this->input->post('member');
		//ambil data penjualan member
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_piutang.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_piutang.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
		if ($member) {
			$kunci['tb_penjualan.kode_member']=$member;
		}
        $selek='tb_penjualan.faktur_jual,tb_penjualan.kode_member,tb_piutang.tanggal,piutang,tb_piutang.sisa,tb_piutang.tempo,member';
        $query=$this->model_laporan->datapiutang($selek,$kunci);
        $data['datapiutang']=$query->result();
        $this->load->view('laporan/ajax_piutang',$data);
	}

	public function xls_piutang() {
		$awal=$this->input->get('awal');
		$akhir=$this->input->get('akhir');
		$member=$this->input->get('member');
		//ambil data penjualan member
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_piutang.tanggal,'%Y-%m-%d')>="]=$awal;
			$data['awal']=date('d-m-Y',strtotime($awal));
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_piutang.tanggal,'%Y-%m-%d')<="]=$akhir;
			$data['akhir']=date('d-m-Y',strtotime($akhir));
		}
		if ($member) {
			$kunci['tb_penjualan.kode_member']=$member;
		}
        $selek='tb_penjualan.faktur_jual,tb_penjualan.kode_member,tb_piutang.tanggal,piutang,tb_piutang.sisa,tb_piutang.tempo,member';
        $query=$this->model_laporan->datapiutang($selek,$kunci);
        $data['datapiutang']=$query->result();
        $this->load->view('laporan/xls_piutang',$data);
	}

	public function hutang() {
		$kp=$this->session->userdata('kp');
        $data['awal']=date('Y-m').'-01';
        $data['akhir']=date('Y-m-d');
        //ambil data suplier
        $kunci=array('aktif'=>1);
        $query=$this->model_crud->ambil_data($kunci,'tb_suplier');
        $data['datasuplier']=$query->result();
		$data['title']='Laporan Hutang';
		$data['template']='laporan/view_hutang';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_hutang() {
		$awal=$this->input->post('awal');
		$akhir=$this->input->post('akhir');
		$suplier=$this->input->post('suplier');
		//ambil data hutang ke suplier
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_hutang.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_hutang.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
		if ($suplier) {
			$kunci['tb_permintaan.kode_suplier']=$suplier;
		}
        $selek='tb_masuk.no_nota,suplier,tb_hutang.tanggal,hutang,tb_hutang.sisa,tb_hutang.tempo,tb_hutang.kode_masuk';
        $query=$this->model_laporan->datahutang($selek,$kunci);
        $data['datahutang']=$query->result();
        $this->load->view('laporan/ajax_hutang',$data);
	}

	public function xls_hutang() {
		$awal=$this->input->get('awal');
		$akhir=$this->input->get('akhir');
		$suplier=$this->input->get('suplier');
		//ambil data hutang ke suplier
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_hutang.tanggal,'%Y-%m-%d')>="]=$awal;
			$data['awal']=date('d-m-Y',strtotime($awal));
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_hutang.tanggal,'%Y-%m-%d')<="]=$akhir;
			$data['akhir']=date('d-m-Y',strtotime($akhir));
		}
		if ($suplier) {
			$kunci['tb_permintaan.kode_suplier']=$suplier;
		}
        $selek='tb_masuk.no_nota,suplier,tb_hutang.tanggal,hutang,tb_hutang.sisa,tb_hutang.tempo,tb_hutang.kode_masuk';
        $query=$this->model_laporan->datahutang($selek,$kunci);
        $data['datahutang']=$query->result();
        $this->load->view('laporan/xls_hutang',$data);
	}
	
	public function koinmember() {
		$kp=$this->session->userdata('kp');
        $data['awal']=date('Y-m').'-01';
        $data['akhir']=date('Y-m-d');
		$data['title']='Laporan Koin Member';
		$data['template']='laporan/view_koinmember';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_koinmember() {
		$awal=$this->input->post('awal');
		$akhir=$this->input->post('akhir');
		$jenis=$this->input->post('jenis');
		//ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_riwayatkoin.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_riwayatkoin.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
		if ($jenis=='pendapatan') {
			$kunci['jumlah_koin>=']=0;
		} else if ($jenis=='penukaran') {
			$kunci['jumlah_koin<']=0;
		}
        $selek='tb_riwayatkoin.tanggal,tb_riwayatkoin.faktur_jual,tb_riwayatkoin.kode_member,jumlah_koin,transaksi,member';
        $query=$this->model_laporan->datariwayatkoin($selek,$kunci);
        $datakoin=$query->result();
        $data['datakoin']=$datakoin;
        $this->load->view('laporan/ajax_koinmember',$data);
	}

	public function xls_koinmember() {
		$awal=$this->input->get('awal');
		$akhir=$this->input->get('akhir');
		$jenis=$this->input->get('jenis');
		//ambil datanya
		$kunci=array();
        if ($awal) {
			$kunci["DATE_FORMAT(tb_riwayatkoin.tanggal,'%Y-%m-%d')>="]=$awal;
			$data['awal']=date('d-m-Y',strtotime($awal));
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_riwayatkoin.tanggal,'%Y-%m-%d')<="]=$akhir;
			$data['akhir']=date('d-m-Y',strtotime($akhir));
		}
		if ($jenis=='pendapatan') {
			$kunci['jumlah_koin>=']=0;
		} else if ($jenis=='penukaran') {
			$kunci['jumlah_koin<']=0;
		}
        $selek='tb_riwayatkoin.tanggal,tb_riwayatkoin.faktur_jual,tb_riwayatkoin.kode_member,jumlah_koin,transaksi,member';
        $query=$this->model_laporan->datariwayatkoin($selek,$kunci);
        $datakoin=$query->result();
        $data['datakoin']=$datakoin;
        $this->load->view('laporan/xls_koinmember',$data);
	}

	public function rekapmember() {
		$kp=$this->session->userdata('kp');
        $data['awal']=date('Y-m').'-01';
        $data['akhir']=date('Y-m-d');
		$data['title']='Laporan Rekap Belanja Member';
		$data['template']='laporan/view_rekapmember';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_rekapmember() {
		$awal=$this->input->post('awal');
		$akhir=$this->input->post('akhir');
		//ambil data penjualan member
		$kunci['tb_penjualan.kode_member<>']=Null;
        if ($awal) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci["DATE_FORMAT(tb_penjualan.tanggal,'%Y-%m-%d')<="]=$akhir;
		}
        $selek='tb_penjualan.faktur_jual,tb_penjualan.poin,tb_penjualan.kode_member,tb_penjualan.tanggal,COUNT(tb_penjualanmeta.kode_barang) AS jumlah_barang,SUM(potongan) AS potongan,SUM(jumlah_jual) AS jumlah_jual,SUM(total_harga) total_harga,pegawai';
        $query=$this->model_laporan->datarekapjual($selek,$kunci);
        $datajual=$query->result();
        $arrmember=array();
        $arrkodemember=array();
        foreach ($datajual as $hasil) {
        	$arrmember[$hasil->kode_member]['poin'][$hasil->faktur_jual]=$hasil->poin;
        	$arrmember[$hasil->kode_member]['total'][$hasil->faktur_jual]=$hasil->total_harga;
        	$arrkodemember[$hasil->kode_member]=$hasil->kode_member;
        }
        //ambil nama member
        $kunci=array('aktif'=>1);
        $query=$this->model_crud->ambil_data($kunci,'tb_member');
        $datamember=$query->result();
        $arrnama=array();
        foreach ($datamember as $hasil) {
        	$arrnama[$hasil->kode_member]=$hasil->member;
        }
        //ambil data riwayat poin
        $kunci2['transaksi']='Pembelian';
        if ($awal) {
			$kunci2["DATE_FORMAT(tanggal,'%Y-%m-%d')>="]=$awal;
		}
		if ($akhir) {
			$kunci2["DATE_FORMAT(tanggal,'%Y-%m-%d')<="]=$akhir;
		}
		$query=$this->model_crud->ambil_data($kunci2,'tb_riwayatpoin');
		$datapoin=$query->result();
		$arrpoin=array();
		foreach ($datapoin as $hasil) {
			$arrpoin[$hasil->kode_member][]=$hasil->jumlah_poin;
		}
        $data['arrnama']=$arrnama;
        $data['arrmember']=$arrmember;
        $data['arrkodemember']=$arrkodemember;
        $data['arrpoin']=$arrpoin;
        $this->load->view('laporan/ajax_rekapmember',$data);
	}

	public function databarang() {
		$req=$_REQUEST;
		$total=$this->model_transaksi->databarang($req,'jumlah');
		$datatab=$this->model_transaksi->databarang($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=$hasil->kode_barang;
			$datanya[]=$hasil->barcode;
			$datanya[]=$hasil->barang;
			$datanya[]=number_format($hasil->harga_jual,0,',','.');
			$datanya[]=$hasil->stok;
			$datanya[]='<button type="button" title="Pilih" onclick="pilihbarang(this.value)" class="btn btn-primary btn-xs" value="'.$hasil->kode_barang.'"><i class="fa fa-pencil-alt"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}
}