<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Login extends CI_Controller {
	public function __construct() {
		parent::__construct();
		$this->load->model('model_crud');
	}

	public function index() {
		$data['title']='Aplikasi Kasir Toko';
		$this->load->view('form_login',$data);
	}

	public function auth() {
		$this->load->library('encryption');
		$username=$this->input->post('username');
		$password=$this->input->post('password');
		//mari kita cek login
		$kunci=array('kode_pegawai'=>$username);
		$query=$this->model_crud->ambil_data($kunci,'tb_pegawai');
		$cek=$query->row();
		if ($cek) {
			$pass=$this->encryption->decrypt($cek->password);
			if (md5($pass)==md5($password)) {
				$this->session->set_userdata('kp',$cek->kode_pegawai);
				$this->session->set_userdata('pegawai',$cek->pegawai);
				$this->session->set_userdata('level',$cek->level);
				redirect('beranda');
			} else {
				if (md5($password)==md5($cek->password)) {
					//update data
					$pass=$this->encryption->encrypt($password);
					$kunci=array('kode_pegawai'=>$username);
					$isi=array('password'=>$pass);
					$this->model_crud->update_data($kunci,'tb_pegawai',$isi);
					$this->session->set_userdata('kp',$cek->kode_pegawai);
					$this->session->set_userdata('pegawai',$cek->pegawai);
					$this->session->set_userdata('level',$cek->level);
					redirect('beranda');
				} else {
					$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
								Nama pengguna dan kata sandi tidak sesuai!
								<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
							</div>';
					$this->session->set_flashdata('login',$pesan);
					redirect('login');
				}
			}
		} else {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Nama pengguna dan kata sandi tidak sesuai!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$this->session->set_flashdata('login',$pesan);
			redirect('login');
		}
	}

	public function out() {
		$array=array('kp','pegawai','level');
		$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
					Anda telah berhasil keluar dari sistem
					<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>';
		$this->session->unset_userdata($array);
		$this->session->set_flashdata('login',$pesan);
		redirect('login');
	}

	public function updatejam() {
		$kunci=array('1'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_penjualan');
		$datajual=$query->result();
		foreach ($datajual as $hasil) {
		    $jam=str_replace('-',' ',$hasil->faktur_jual);
		    $tgl=date('Y-m-d H:i:s',strtotime($jam));
		    echo $tgl.'<br>';
		    $kunci=array('faktur_jual'=>$hasil->faktur_jual);
		    $isi=array('tanggal'=>$tgl);
		    $this->model_crud->update_data($kunci,'tb_penjualan',$isi);
		}
	}
}