<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Pengaturan extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if ($this->session->userdata('kp')=='') {
			redirect('login');
		}
		$this->load->model('model_crud');
	}

	public function index() {
		redirect('pengaturan/umum');
	}

	public function umum() {
        $data['awal']=date('Y-m').'-01';
        $data['akhir']=date('Y-m-d');
        //ambil data suplier
        $kunci=array(1=>1);
        $query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
        $datapengaturan=$query->result();
        foreach ($datapengaturan as $hasil) {
            $data[$hasil->pengaturan]=$hasil->isi;
        }
		$data['title']='Pengaturan Umum';
		$data['template']='pengaturan/form_umum';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

    public function simpan_umum() {
        foreach ($this->input->post() as $key => $value) {
            $kunci=array('pengaturan'=>$key);
            $query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
            $cek=$query->row();
            if ($cek) {
                $isi=array('isi'=>$value);
                $this->model_crud->update_data($kunci,'tb_pengaturan',$isi);
            } else {
                $isi=array('isi'=>$value,'pengaturan'=>$key);
                $this->model_crud->tambah_data('tb_pengaturan',$isi);
            }
        }
        $pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
                    Pengaturan berhasil disimpan
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>';
        $toas='Pengaturan berhasil disimpan';
        $ikon='success';
        $arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
        echo json_encode($arr);
    }

    public function profil() {
        $kp=$this->session->userdata('kp');
        $kunci=array('kode_pegawai'=>$kp);
        $query=$this->model_crud->ambil_data($kunci,'tb_pegawai');
        $cek=$query->row();
        if ($cek) {
            $data['kode']=$cek->kode_pegawai;
            $data['pegawai']=$cek->pegawai;
            $data['jekel']=$cek->jekel;
            $data['email']=$cek->email;
            $data['telepon']=$cek->telepon;
            $data['alamat']=$cek->alamat;
            $data['level']=$cek->level;
            $data['aksi']='Ubah';
        }
        $data['title']='Profil';
        $data['template']='pengaturan/form_profil';
        $data['footer']='layout/footer';
        $data['footerend']='layout/footerend';
        $this->load->view('layout/wrapper',$data);
    }

    public function simpan_profil() {
       $kp=$this->session->userdata('kp');
       $pegawai=$this->input->post('pegawai');
        $jekel=$this->input->post('jekel');
        $telepon=$this->input->post('telepon');
        $email=$this->input->post('email');
        $alamat=$this->input->post('alamat');
       //update data
        $kunci=array('kode_pegawai'=>$kp);
        $isi=array('pegawai'=>$pegawai,'jekel'=>$jekel,'email'=>$email,'telepon'=>$telepon,'alamat'=>$alamat);
        $this->model_crud->update_data($kunci,'tb_pegawai',$isi);
        $pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
                    Profil pengguna berhasil diubah
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>';
        $toas='Profil pengguna berhasil diubah';
        $ikon='success';
        $arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
        echo json_encode($arr); 
    }

    public function password() {
        $kp=$this->session->userdata('kp');
        $data['title']='Ganti Kata Sandi';
        $data['template']='pengaturan/form_password';
        $data['footer']='layout/footer';
        $data['footerend']='layout/footerend';
        $this->load->view('layout/wrapper',$data);
    }

    public function simpan_password() {
        $this->load->library('encryption');
        $kp=$this->session->userdata('kp');
        $pass=$this->input->post('pass');
        $pass2=$this->input->post('pass2');
        $pass3=$this->input->post('pass3');
        //cek password lama dulu
        $kunci=array('kode_pegawai'=>$kp);
        $query=$this->model_crud->ambil_data($kunci,'tb_pegawai');
        $cek=$query->row();
        if ($cek) {
            $passlama=$this->encryption->decrypt($cek->password);
            if (md5($pass)==md5($passlama)) {
                //cek password baru
                if (md5($pass2)==md5($pass3)) {
                    $pwd=$this->encryption->encrypt($pass2);
                    $kunci=array('kode_pegawai'=>$kp);
                    $isi=array('password'=>$pwd);
                    $this->model_crud->update_data($kunci,'tb_pegawai',$isi);
                    $pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
                                Kata sandi berhasil diubah
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>';
                    $toas='Kata sandi berhasil diubah';
                    $ikon='success';
                } else {
                    $pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
                                Kata sandi yang baru masih belum cocok!
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>';
                    $toas='Kata sandi yang baru masih belum cocok!';
                    $ikon='error';
                }
            } else {
               $pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
                    Kata sandi lama masih salah!
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>';
                $toas='Kata sandi lama masih salah!';
                $ikon='error'; 
            }
        } else {
            $pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
                        Nama pengguna tidak ditemukan!
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>';
            $toas='Nama pengguna tidak ditemukan!';
            $ikon='error';
        }
        $arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
        echo json_encode($arr); 
    }
}