<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Transaksi extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if ($this->session->userdata('kp')=='') {
			redirect('login');
		}
		$this->load->model('model_crud');
		$this->load->model('model_transaksi');
		$this->load->model('model_laporan');
	}

	public function index() {
		redirect('transaksi/penjualan');
	}

	public function penjualan() {
		//ambil pengaturan
		$kunci=array('pengaturan'=>'nilaipoin');
		$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
		$cek=$query->row();
		if ($cek) {
			$data['nilaipoin']=$cek->isi;
		} else {
			$data['nilaipoin']=0;
		}
		//ambil data member
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_member');
		$data['datamember']=$query->result();
		//ambil data pembayaran non tunai
		$query=$this->model_crud->ambil_data('1=1','tb_nontunai');
		$data['datanontunai']=$query->result();
		$data['title']='Transaksi Penjualan';
		$data['template']='transaksi/view_penjualan';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datakeranjangjual() {
		$kp=$this->session->userdata('kp');
		$level=$this->session->userdata('level');
		$member=$this->input->get('member');
		$this->update_keranjangmember($member);
		$req=$_REQUEST;
		$kunci=array('tb_keranjang.kode_pegawai'=>$kp,'status'=>'jual');
		$datatab=$this->model_transaksi->datakerjang($kunci);
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			if ($hasil->bonus>0) {
				$bonus='+'.$hasil->bonus;
			} else {
				$bonus='';
			}
			$datanya[]=$hasil->kode_barang;
			$datanya[]=$hasil->barcode;
			$datanya[]=$hasil->barang;
			$datanya[]=$hasil->jumlah.$bonus.' '.$hasil->satuan_jual;
			$datanya[]=number_format($hasil->jum_harga,0,',','.');
			if ($level=='Administrator') {
				$datanya[]='<button type="button" title="Pilih" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->token.'"><i class="fa fa-trash"></i></button>';
			} else {
				//$datanya[]='';
				$datanya[]='<button type="button" title="Pilih" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->token.'"><i class="fa fa-trash"></i></button>';
			}
			$isinya[]=$datanya;
		}
		$result=array('data'=>$isinya);
		echo json_encode($result);
	}

	public function update_keranjangmember($member) {
		$kp=$this->session->userdata('kp');
		$tanggal=date('Y-m-d');
		//cari member dulu
		$kunci=array('kode_member'=>$member);
		$query=$this->model_crud->ambil_data($kunci,'tb_member');
		$cek=$query->row();
		if ($cek) {
			if ($cek->berlaku_jual==3) {
				$kunci=array('kode_pegawai'=>$kp,'status'=>'jual');
				$query=$this->model_crud->ambil_data($kunci,'tb_keranjang');
				$datakeranjang=$query->result();
				foreach ($datakeranjang as $hasil) {
					$satuan=$hasil->satuan_jual;
					$kunci=array('kode_barang'=>$hasil->kode_barang);
					$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
					$cekrek=$query->row();
					if ($cekrek->satuan3==$satuan) {
						if ($cekrek->harga_jual33) {
							$jumharga=$hasil->jumlah*$cekrek->harga_jual33;
							//$kunci=array('kode_pegawai'=>$kp,'kode_barang'=>$hasil->kode_barang,'status'=>'jual');
							$kunci=array('token'=>$hasil->token);
							$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
							$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
						} else {
							$jumharga=$hasil->jumlah*$cekrek->harga_jual31;
							$kunci=array('token'=>$hasil->token);
							$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
							$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
						}
					} else if ($cekrek->satuan2==$satuan) {
						if ($cekrek->harga_jual32) {
							$jumharga=$hasil->jumlah*$cekrek->harga_jual32;
							$kunci=array('token'=>$hasil->token);
							$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
							$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
						} else {
							$jumharga=$hasil->jumlah*$cekrek->harga_jual31;
							$kunci=array('token'=>$hasil->token);
							$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
							$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
						}
					} else {
						$jumharga=$hasil->jumlah*$cekrek->harga_jual3;
						$kunci=array('token'=>$hasil->token);
						$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
						$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
					}
				}
			} else if ($cek->berlaku_jual==2) {
				$kunci=array('kode_pegawai'=>$kp,'status'=>'jual');
				$query=$this->model_crud->ambil_data($kunci,'tb_keranjang');
				$datakeranjang=$query->result();
				foreach ($datakeranjang as $hasil) {
					$satuan=$hasil->satuan_jual;
					$kunci=array('kode_barang'=>$hasil->kode_barang);
					$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
					$cekrek=$query->row();
					if ($cekrek->satuan3==$satuan) {
						if ($cekrek->harga_jual23) {
							$jumharga=$hasil->jumlah*$cekrek->harga_jual23;
							$kunci=array('token'=>$hasil->token);
							$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
							$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
						} else {
							$jumharga=$hasil->jumlah*$cekrek->harga_jual21;
							$kunci=array('token'=>$hasil->token);
							$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
							$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
						}
					} else if ($cekrek->satuan2==$satuan) {
						if ($cekrek->harga_jual22) {
							$jumharga=$hasil->jumlah*$cekrek->harga_jual22;
							$kunci=array('token'=>$hasil->token);
							$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
							$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
						} else {
							$jumharga=$hasil->jumlah*$cekrek->harga_jual21;
							$kunci=array('token'=>$hasil->token);
							$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
							$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
						}
					} else {
						$jumharga=$hasil->jumlah*$cekrek->harga_jual2;
						$kunci=array('token'=>$hasil->token);
						$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
						$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
					}
				}
			} else {
				$kunci=array('kode_pegawai'=>$kp,'status'=>'jual');
				$query=$this->model_crud->ambil_data($kunci,'tb_keranjang');
				$datakeranjang=$query->result();
				foreach ($datakeranjang as $hasil) {
					$satuan=$hasil->satuan_jual;
					$kunci=array('kode_barang'=>$hasil->kode_barang);
					$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
					$cekrek=$query->row();
					if ($cekrek->satuan3==$satuan) {
						if ($cekrek->harga_jual31) {
							$jumharga=$hasil->jumlah*$cekrek->harga_jual31;
							$kunci=array('token'=>$hasil->token);
							$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
							$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
						} else {
							$jumharga=$hasil->jumlah*$cekrek->harga_jual1;
							$kunci=array('token'=>$hasil->token);
							$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
							$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
						}
					} else if ($cekrek->satuan2==$satuan) {
						if ($cekrek->harga_jual21) {
							$jumharga=$hasil->jumlah*$cekrek->harga_jual21;
							$kunci=array('token'=>$hasil->token);
							$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
							$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
						} else {
							$jumharga=$hasil->jumlah*$cekrek->harga_jual1;
							$kunci=array('token'=>$hasil->token);
							$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
							$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
						}
					} else {
						$jumharga=$hasil->jumlah*$cekrek->harga_jual1;
						$kunci=array('token'=>$hasil->token);
						$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
						$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
						//cek potongan umum dulu
						$kunci=array('kode_barang'=>$hasil->kode_barang,'jumlah_beli<='=>$hasil->jumlah);
						$query=$this->model_transaksi->caripotongan($kunci,$tanggal);
						$pot=$query->row();
						if ($pot) {
							$potongan=$hasil->jumlah*$pot->potongan;
						} else {
							$potongan=0;
						}
						$jumharga=($cekrek->harga_jual1*$hasil->jumlah)-$potongan;
						//cek bonus
						$kunci=array('kode_barang'=>$hasil->kode_barang,'jumlah_beli<='=>$hasil->jumlah);
						$query=$this->model_transaksi->caribonus($kunci,$tanggal);
						$bonus=$query->row();
						if ($bonus) {
							if ($bonus->jumlah_beli) {
								$jumbelbonus=$bonus->jumlah_beli;
							} else {
								$jumbelbonus=1;
							}
							$jumbonus=floor($hasil->jumlah/$jumbelbonus);
							$bonus=$jumbonus;
						} else {
							$bonus=0;
						}
						$kunci=array('token'=>$hasil->token);
						$isi=array('bonus'=>$bonus,'jum_harga'=>$jumharga,'potongan'=>$potongan);
						$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
					}
				}
			}
		} else {
			$kunci=array('kode_pegawai'=>$kp,'status'=>'jual');
			$query=$this->model_crud->ambil_data($kunci,'tb_keranjang');
			$datakeranjang=$query->result();
			foreach ($datakeranjang as $hasil) {
				$satuan=$hasil->satuan_jual;
				$kunci=array('kode_barang'=>$hasil->kode_barang);
				$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
				$cekrek=$query->row();
				if ($cekrek->satuan3==$satuan) {
					if ($cekrek->harga_jual31) {
						$jumharga=$hasil->jumlah*$cekrek->harga_jual31;
						$kunci=array('token'=>$hasil->token);
						$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
						$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
					} else {
						$jumharga=$hasil->jumlah*$cekrek->harga_jual1;
						$kunci=array('token'=>$hasil->token);
						$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
						$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
					}
				} else if ($cekrek->satuan2==$satuan) {
					if ($cekrek->harga_jual21) {
						$jumharga=$hasil->jumlah*$cekrek->harga_jual21;
						$kunci=array('token'=>$hasil->token);
						$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
						$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
					} else {
						$jumharga=$hasil->jumlah*$cekrek->harga_jual1;
						$kunci=array('token'=>$hasil->token);
						$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
						$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
					}
				} else {
					$jumharga=$hasil->jumlah*$cekrek->harga_jual1;
					$kunci=array('token'=>$hasil->token);
					$isi=array('jum_harga'=>$jumharga,'potongan'=>0);
					$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
					//cek potongan umum dulu
					$kunci=array('kode_barang'=>$hasil->kode_barang,'jumlah_beli<='=>$hasil->jumlah);
					$query=$this->model_transaksi->caripotongan($kunci,$tanggal);
					$pot=$query->row();
					if ($pot) {
						$potongan=$hasil->jumlah*$pot->potongan;
					} else {
						$potongan=0;
					}
					$jumharga=($cekrek->harga_jual1*$hasil->jumlah)-$potongan;
					//cek bonus
					$kunci=array('kode_barang'=>$hasil->kode_barang,'jumlah_beli<='=>$hasil->jumlah);
					$query=$this->model_transaksi->caribonus($kunci,$tanggal);
					$bonus=$query->row();
					if ($bonus) {
						if ($bonus->jumlah_beli) {
							$jumbelbonus=$bonus->jumlah_beli;
						} else {
							$jumbelbonus=1;
						}
						$jumbonus=floor($hasil->jumlah/$jumbelbonus);
						$bonus=$jumbonus;
					} else {
						$bonus=0;
					}
					$kunci=array('token'=>$hasil->token);
					$isi=array('bonus'=>$bonus,'jum_harga'=>$jumharga,'potongan'=>$potongan);
					$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
				}
			}
		}
	}

	public function simpan_keranjang() {
		$kode=$this->input->post('kode');
		$jumlah=$this->input->post('jumlah');
		$satuan=$this->input->post('satuan');
		$tanggal=date('Y-m-d');
		$kp=$this->session->userdata('kp');
		if ($kode && $jumlah) {
			//cek stok barang dengan kode
			$kunci=array('kode_barang'=>$kode,'aktif'=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_barang');
			$cek=$query->row();
			if ($cek) {
				$stok=$cek->stok;
				$stokminim=$cek->stok_minimal;
				$kdbarang=$cek->kode_barang;
			} else {
				//cek stok barang dengan barcode
				$kunci=array('barcode'=>$kode,'aktif'=>1);
				$query=$this->model_crud->ambil_data($kunci,'tb_barang');
				$cek=$query->row();
				if ($cek) {
					$stok=$cek->stok;
					$stokminim=$cek->stok_minimal;
					$kdbarang=$cek->kode_barang;
				} else {
					//cek stok barang dengan barcode2
					$kunci=array('barcode2'=>$kode,'aktif'=>1);
					$query=$this->model_crud->ambil_data($kunci,'tb_barang');
					$cek=$query->row();
					if ($cek) {
						$stok=$cek->stok;
						$stokminim=$cek->stok_minimal;
						$kdbarang=$cek->kode_barang;
					} else {
						//cek stok barang dengan barcode3
						$kunci=array('barcode3'=>$kode,'aktif'=>1);
						$query=$this->model_crud->ambil_data($kunci,'tb_barang');
						$cek=$query->row();
						if ($cek) {
							$stok=$cek->stok;
							$stokminim=$cek->stok_minimal;
							$kdbarang=$cek->kode_barang;
						} else {
							$stok=0;
							$stokminim=0;
							echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
									Data barang tidak ditemukan!
									<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
								</div>';
							die();
						}
					}
				}
			}
			//cari harga jual
			$kunci=array('kode_barang'=>$kdbarang);
			$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
			$cek=$query->row();
			if ($cek) {
				$sateceran=$cek->satuan1;
				if ($satuan==$cek->satuan3) {
					$hargajual=$cek->harga_jual31;
					$hargajual2=$cek->harga_jual32;
					$hargajual3=$cek->harga_jual33;
					$konversi=$cek->konversi2;
				} else if ($satuan==$cek->satuan2) {
					$hargajual=$cek->harga_jual21;
					$hargajual2=$cek->harga_jual22;
					$hargajual3=$cek->harga_jual23;
					$konversi=$cek->konversi1;
				} else {
					$hargajual=$cek->harga_jual1;
					$hargajual2=$cek->harga_jual2;
					$hargajual3=$cek->harga_jual3;
					$konversi=1;
				}
			} else {
				$sateceran='';
				$hargajual=0;
				$hargajual2=0;
				$hargajual3=0;
				$konversi=1;
			}
			//selanjutnya input transaksi penjualan
			//if ($jumlah<=$stok && $stok>$stokminim) {
			if ($jumlah) {
				//cek potongan umum dulu
				$kunci=array('kode_barang'=>$kdbarang,'jumlah_beli<='=>$jumlah);
				$query=$this->model_transaksi->caripotongan($kunci,$tanggal);
				$pot=$query->row();
				if ($pot) {
				    if ($pot->jumlah_beli) {
				       $jumbelpot=$pot->jumlah_beli;
				    } else {
				        $jumbelpot=1;
				    }
				    $jumpot=floor($jumlah/$jumbelpot);
					$potongan=$jumlah*$pot->potongan;
				} else {
					$potongan=0;
				}
				//cek bonus jumlah beli dan hanya untuk satuan 1
				if ($satuan==$sateceran) {
					$kunci=array('kode_barang'=>$kdbarang,'jumlah_beli<='=>$jumlah);
					$query=$this->model_transaksi->caribonus($kunci,$tanggal);
					$bonus=$query->row();
					if ($bonus) {
					    if ($bonus->jumlah_beli) {
					       $jumbelbonus=$bonus->jumlah_beli;
					    } else {
					        $jumbelbonus=1;
					    }
					    $jumbonus=floor($jumlah/$jumbelbonus);
						$bonus=$jumbonus;
					} else {
						$bonus=0;
					}
				} else {
					$bonus=0;
				}
				//pemberlakuan harga jual
				if ($konversi==0) {
					$konversi=1;
				}
				//potongan hanya berlaku untuk harga jual 1
				$totharga=($hargajual*$jumlah)-$potongan;
				//tambahkan ke tabel keranjang
				//cek tabel keranjang dulu
				$kunci=array('kode_barang'=>$kdbarang,'satuan_jual'=>$satuan,'status'=>'jual','kode_pegawai'=>$kp);
				$query=$this->model_crud->ambil_data($kunci,'tb_keranjang');
				$cek=$query->row();
				if ($cek) {
					$jumada=$cek->jumlah+$jumlah;
					//cari potongan
					$kunci2=array('kode_barang'=>$kdbarang,'jumlah_beli<='=>$jumada);
					$query=$this->model_transaksi->caripotongan($kunci2,$tanggal);
					$pot=$query->row();
					if ($pot) {
						$jumpot=floor($jumada/$pot->jumlah_beli);
						$potongan=$jumada*$pot->potongan;
					} else {
						$potongan=0;
					}
					//pemberlakuan harga jual
					//potongan hanya berlaku untuk harga jual 1
					$totharga=($hargajual*$jumada)-$potongan;
					//cari bonus jumlah beli
					if ($satuan==$sateceran) {
						$kunci3=array('kode_barang'=>$kdbarang,'jumlah_beli<='=>$jumada);
						$query=$this->model_transaksi->caribonus($kunci3,$tanggal);
						$bonus=$query->row();
						if ($bonus) {
						    if ($bonus->jumlah_beli) {
						       $jumbelbonus=$bonus->jumlah_beli;
						    } else {
						        $jumbelbonus=1;
						    }
						    $jumbonus=floor($jumada/$jumbelbonus);
							$bonus=$jumbonus;
						} else {
							$bonus=0;
						}
					} else {
						$bonus=0;
					}
					//update tabel keranjang
					$isi=array('jumlah'=>$jumada,'bonus'=>$bonus,'potongan'=>$potongan,'jum_harga'=>$totharga);
					$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
				} else {
					$isi=array('token'=>date('YmdHis'),'kode_barang'=>$kdbarang,'jumlah'=>$jumlah,'bonus'=>$bonus,'satuan_jual'=>$satuan,'satuan_konversi'=>$sateceran,'konversi'=>$konversi,'potongan'=>$potongan,'jum_harga'=>$totharga,'status'=>'jual','kode_pegawai'=>$kp);
					$this->model_crud->tambah_data('tb_keranjang',$isi);
				}
			} else {
				echo '<div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
						Stok barang tidak tersedia!
						<button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
					</div>';
				die();
			}
		} else {
			echo '<div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
					Barang dan jumlah penjualan belum diisi!
					<button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
				</div>';
		}
	}

	public function hapusjual() {
		//ambil data pegawai
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_pegawai');
		$data['datapegawai']=$query->result();
		$data['title']='Hapus Transaksi Penjualan';
		$data['template']='transaksi/view_hapusjual';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_hapusjual() {
		$pegawai=$this->input->post('pegawai');
		$kunci['status']='jual';
		if ($pegawai) {
			$kunci['tb_keranjang.kode_pegawai']=$pegawai;
		}
		$data['databarang']=$this->model_transaksi->datakerjang($kunci);
		$this->load->view('transaksi/ajax_hapusjual',$data);
	}

	public function hapus_keranjang() {
		$level=$this->session->userdata('level');
		$id=$this->input->post('id');
		if ($level) {
			$kunci=array('token'=>$id);
			$query=$this->model_crud->ambil_data($kunci,'tb_keranjang');
			$cek=$query->row();
			if ($cek) {
				$kunci=array('kode_barang'=>$cek->kode_barang,'kode_pegawai'=>$cek->kode_pegawai,'status'=>$cek->status);
				$this->model_crud->hapus_data($kunci,'tb_keranjang');
				$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
							Item barang berhasil dihapus.
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Item barang berhasil dihapus.';
				$ikon='warning';
			}
		} else {
			$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
						Silahkan menghubungi Administrator untuk menghapus item transaksi!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Silahkan menghubungi Administrator untuk menghapus item transaksi!';
			$ikon='warning';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function harga_jual() {
		$kp=$this->session->userdata('kp');
		$member=$this->input->post('member');
		$this->update_keranjangmember($member);
		$kunci=array('tb_keranjang.kode_pegawai'=>$kp,'status'=>'jual');
		$query=$this->model_crud->ambil_data($kunci,'tb_keranjang');
		$datatab=$query->result();
		$total=0;
		if ($datatab) {
			foreach ($datatab as $hasil) {
				$total=$total+$hasil->jum_harga;
			}
		}
		echo $total;
	}

	public function form_bayar() {
		$kp=$this->session->userdata('kp');
		$member=$this->input->post('member');
		$this->update_keranjangmember($member);
		//ambil pengaturan
		$kunci=array('pengaturan'=>'nilaipoin');
		$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
		$cek=$query->row();
		if ($cek) {
			$nilaipoin=$cek->isi;
		} else {
			$nilaipoin=0;
		}
		$kunci=array('pengaturan'=>'receh');
		$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
		$cek=$query->row();
		if ($cek) {
			$receh=$cek->isi;
		} else {
			$receh=0;
		}
		//ambil data pembayaran non tunai
		$query=$this->model_crud->ambil_data('1=1','tb_nontunai');
		$data['datanontunai']=$query->result();
		$kunci=array('tb_keranjang.kode_pegawai'=>$kp,'status'=>'jual');
		$query=$this->model_crud->ambil_data($kunci,'tb_keranjang');
		$datatab=$query->result();
		$total=0;
		if ($datatab) {
			foreach ($datatab as $hasil) {
				$total=$total+$hasil->jum_harga;
			}
		}
		//tampilkan poin dan koin
		$kunci=array('kode_member'=>$member);
		$query=$this->model_crud->ambil_data($kunci,'tb_member');
		$cek=$query->row();
		if ($cek) {
			$poin=$cek->poin;
			$koin=$cek->koin;
			//poin tidak boleh lebih besar dari pada total bayar
			$besarpoin=$nilaipoin*$poin;
			if ($total>=$besarpoin) {
				$bagipoin=$poin/$receh;
				$bulatpoin=floor($bagipoin);
				$nilaiakhir=$bulatpoin*$receh;;
				$poinakhir=$nilaiakhir;
			} else {
				$poin=$total/$nilaipoin;
				$poinakhir=$poin;
			}
			//koin tidak boleh lebih besar dari pada total bayar
			if ($total>=$koin) {
				$bagikoin=$koin/$receh;
				$bulatkoin=floor($bagikoin);
				$nilaiakhir=$bulatkoin*$receh;;
				$koinakhir=$nilaiakhir;
			} else {
				$koinakhir=$total;
			}
			//tentukan jumlah koin dan poin
			$bagikoinpoin=$total*50/100;
			if ($koinakhir>=$bagikoinpoin) {
				$data['koin']=$bagikoinpoin;
			} else {
				$data['koin']=$koinakhir;
			}
			if ($poinakhir>=$bagikoinpoin) {
				$data['poin']=$bagikoinpoin;
			} else {
				$data['poin']=$poinakhir;
			}
		}
		$data['member']=$member;
		$data['total']=$total;
		$data['title']='Form Bayar';
		$this->load->view('transaksi/form_bayar',$data);
	}

	public function simpan_penjualan() {
		$kp=$this->session->userdata('kp');
		$total=$this->input->post('total');
		$tunai=$this->input->post('tunai');
		$non=$this->input->post('non');
		$tanggal=date('Y-m-d H:i:s');
		$tglpiutang=date('Y-m-d');
		if ($this->input->post('koin')) {
            $koin=$this->input->post('koin');  
		} else {
		    $koin=0;
		}
		if ($this->input->post('metode')) {
			$metode=$this->input->post('metode');
		} else {
			$metode='';
		}
		if ($this->input->post('referensi')) {
			$referensi=$this->input->post('referensi');
		} else {
			$referensi='';
		}
		if ($this->input->post('poin')) {
			$poin=$this->input->post('poin');
		} else {
			$poin=0;
		}
		if ($this->input->post('tkoin')) {
			$tkoin=$this->input->post('tkoin');
		} else {
			$tkoin=0;
		}
		$kembalian=$this->input->post('kembali');
		$member=$this->input->post('member');
		$kembali=$kembalian-$koin;
		$cashout=0;
		$faktur=date('Ymd-His');
		//ambil pengaturan
		$kunci=array('pengaturan'=>'nilaipoin');
		$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
		$cek=$query->row();
		if ($cek) {
			$nilaipoin=$cek->isi;
		} else {
			$nilaipoin=0;
		}
		$kunci=array('pengaturan'=>'tempopiutang');
		$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
		$cek=$query->row();
		if ($cek) {
			$tempo=$cek->isi;
		} else {
			$tempo=30;
		}
		$tgljatuh=date('Y-m-d',strtotime('+'.$tempo.' day',strtotime($tglpiutang)));
		//cek jumlah bayar
		if ($tunai) {
			$tuna=$tunai;
		} else {
			$tuna=0;
		}
		if ($non) {
			$none=$non;
		} else {
			$none=0;
		}
		$totbayar=$tuna+$none+($poin*$nilaipoin);
		$total=$total+($poin*$nilaipoin);
		if ($non) {
			if ($metode=='' || $referensi=='') {
				$faktur='';
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Metode pembayaran dan nomor referensi tidak boleh kosong!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Metode pembayaran dan nomor referensi tidak boleh kosong!';
				$ikon='error';
				$arr=array('pesan'=>$pesan,'faktur'=>$faktur,'toas'=>$toas,'ikon'=>$ikon);
				echo json_encode($arr);
				die();
			}
		}
		//cek koin
		if ($koin>$kembalian) {
			$faktur='';
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Jumlah deposit koin tidak boleh lebih besar daripada kembalian!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Jumlah deposit koin tidak boleh lebih besar daripada kembalian!';
			$ikon='error';
			$arr=array('pesan'=>$pesan,'faktur'=>$faktur,'toas'=>$toas,'ikon'=>$ikon);
			echo json_encode($arr);
			die();
		}
		$kunci=array('kode_pegawai'=>$kp,'status'=>'jual');
		$query=$this->model_crud->ambil_data($kunci,'tb_keranjang');
		$datakeranjang=$query->result();
		if ($datakeranjang) {
			//cek jumlah bayar
			if ($totbayar<$total && $member) {
				$isi=array('faktur_jual'=>$faktur,'tanggal'=>$tanggal,'kode_member'=>$member,'kembali'=>$kembali,'non_tunai'=>$non,'metode'=>$metode,'referensi'=>$referensi,'tunai'=>$tunai,'poin'=>$poin,'nilaipoin'=>$nilaipoin,'total'=>$total,'cashout'=>$cashout,'kode_pegawai'=>$kp);
				$this->model_crud->tambah_data('tb_penjualan',$isi);
				//masukan ke tabel piutang
				$piutang=$total-$totbayar;
				$isi=array('tanggal'=>$tglpiutang,'faktur_jual'=>$faktur,'piutang'=>$piutang,'sisa'=>$piutang,'tempo'=>$tgljatuh);
				$this->model_crud->tambah_data('tb_piutang',$isi);
			} else if ($totbayar<$total && $member=='') {
				$faktur='';
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Jumlah pembayaran kurang!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Jumlah pembayaran kurang!';
				$ikon='error';
				$arr=array('pesan'=>$pesan,'faktur'=>$faktur,'toas'=>$toas,'ikon'=>$ikon);
				echo json_encode($arr);
				die();
			} else {
				$isi=array('faktur_jual'=>$faktur,'tanggal'=>$tanggal,'kode_member'=>$member,'kembali'=>$kembali,'non_tunai'=>$non,'metode'=>$metode,'referensi'=>$referensi,'tunai'=>$tunai,'poin'=>$poin,'nilaipoin'=>$nilaipoin,'koin'=>$tkoin,'total'=>$total,'cashout'=>$cashout,'kode_pegawai'=>$kp);
				$this->model_crud->tambah_data('tb_penjualan',$isi);
			}
			foreach ($datakeranjang as $hasil) {
				//cek data barang
				$kunci=array('kode_barang'=>$hasil->kode_barang);
				$query=$this->model_crud->ambil_data($kunci,'tb_barang');
				$cek=$query->row();
				if ($cek) {
					$hargabeli=$cek->harga_beli;
					//masukan ke tabel penjualan meta
					$jumjual=($hasil->jumlah+$hasil->bonus)*$hasil->konversi;
					$isi=array('faktur_jual'=>$faktur,'kode_barang'=>$hasil->kode_barang,'jumlah_jual'=>$hasil->jumlah,'bonus'=>$hasil->bonus,'konversi'=>$hasil->konversi,'satuan_jual'=>$hasil->satuan_jual,'potongan'=>$hasil->potongan,'total_harga'=>$hasil->jum_harga,'harga_beli'=>$hargabeli);
					$this->model_crud->tambah_data('tb_penjualanmeta',$isi);
					//mengurangi stok
					$stok=$cek->stok-$jumjual;
					$isi=array('stok'=>$stok);
					$this->model_crud->update_data($kunci,'tb_barang',$isi);
					//masukan ke tabel kartu stok
					$isi=array('tanggal'=>$tanggal,'kode_barang'=>$hasil->kode_barang,'keterangan'=>'Penjualan','keluar'=>$jumjual,'saldo'=>$stok);
					$this->model_crud->tambah_data('tb_kartustok',$isi);
				}
			}
			//masukan poin member
			if ($member) {
				$kunci=array('kode_member'=>$member);
				$query=$this->model_crud->ambil_data($kunci,'tb_member');
				$cek=$query->row();
				if ($cek) {
					//tambahkan koin
					$koinda=$cek->koin;
					if ($koin>0) {
						$isi=array('tanggal'=>$tanggal,'kode_member'=>$member,'transaksi'=>'Pembelian','faktur_jual'=>$faktur,'jumlah_koin'=>$koin);
						$this->model_crud->tambah_data('tb_riwayatkoin',$isi);
						$kointambah=$koinda-$tkoin+$koin;
						$kunci=array('kode_member'=>$member);
						$isi=array('koin'=>$kointambah);
						$this->model_crud->update_data($kunci,'tb_member',$isi);
					}
					if ($tkoin) {
						$isi=array('tanggal'=>$tanggal,'kode_member'=>$member,'transaksi'=>'Penukaran','faktur_jual'=>$faktur,'jumlah_koin'=>'-'.$tkoin);
						$this->model_crud->tambah_data('tb_riwayatkoin',$isi);
					}
				}
				if ($cek->berlaku_poin) {
					$poinada=$cek->poin;
					$kunci=array('pengaturan'=>'dapatpoin');
					$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
					$ceker=$query->row();
					if ($ceker) {
						$minimpoin=$ceker->isi;
						//yang dipoinkan hanya yang bayar tunai dan non tunai
						$bayar=$tuna+$none-$kembali;
						$pointambah=floor($bayar/$minimpoin);
						//masukan ke tabel riwayat poin
						if ($poin) {
							$isi=array('tanggal'=>$tanggal,'kode_member'=>$member,'transaksi'=>'Penukaran','jumlah_poin'=>'-'.$poin);
							$this->model_crud->tambah_data('tb_riwayatpoin',$isi);
						}
						$isi=array('tanggal'=>$tanggal,'kode_member'=>$member,'transaksi'=>'Pembelian','jumlah_poin'=>$pointambah);
						$this->model_crud->tambah_data('tb_riwayatpoin',$isi);
						//tambahan poin
						$tambahpoin=$poinada-$poin+$pointambah;
						$kunci=array('kode_member'=>$member);
						$isi=array('poin'=>$tambahpoin);
						$this->model_crud->update_data($kunci,'tb_member',$isi);
					}
				}
			}
			//hapus data tabel keranjang
			$kunci=array('kode_pegawai'=>$kp,'status'=>'jual');
			$this->model_crud->hapus_data($kunci,'tb_keranjang');
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Transaksi Penjualan berhasil disimpan
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Transaksi Penjualan berhasil disimpan';
			$ikon='success';
		} else {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Keranjang belanja masih kosong! Transaksi tidak bisa disimpan.
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Keranjang belanja masih kosong! Transaksi tidak bisa disimpan.';
			$ikon='error';
			$faktur='';
		}
		$arr=array('pesan'=>$pesan,'faktur'=>$faktur,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function cetak_faktur() {
		$kp=$this->session->userdata('kp');
		if ($this->input->get('no')) {
			$no=$this->input->get('no');
		} else {
			//ambil nomor faktur terakhir
			$kunci=array('kode_pegawai'=>$kp);
			$urut=array('tanggal'=>'DESC');
			$query=$this->model_crud->ambil_data($kunci,'tb_penjualan',$urut);
			$cek=$query->row();
			if ($cek) {
				$no=$cek->faktur_jual;
			} else {
				$no='';
			} 
		}
		//mari kita ambil datanya
		$kunci=array('tb_penjualan.faktur_jual'=>$no);
        $selek='tb_penjualan.faktur_jual,tb_penjualan.tanggal,tb_penjualanmeta.kode_barang,potongan,jumlah_jual,tb_penjualanmeta.bonus,tb_penjualanmeta.konversi,tb_penjualanmeta.satuan_jual,total_harga,barang,pegawai';
        $query=$this->model_laporan->datajualdetail($selek,$kunci);
        $datajual=$query->result();
		foreach ($datajual as $hasil) {
			$data['pegawai']=$hasil->pegawai;
		}
		//ambil data penjualan
		$kunci=array('faktur_jual'=>$no);
		$query=$this->model_crud->ambil_data($kunci,'tb_penjualan');
		$cek=$query->row();
		if ($cek) {
			$data['tanggal']=date('d-m-Y H:i',strtotime($cek->tanggal));
			$data['toha']=$cek->total;
			$data['tunai']=$cek->tunai;
			$data['non']=$cek->non_tunai;
			$data['kurangipoin']=$cek->poin;
			$data['tukarpoin']=$cek->poin*$cek->nilaipoin;
			$data['kembali']=$cek->kembali;
			$data['cashout']=$cek->cashout;
			if ($cek->cashout) {
				$data['kembali']=$cek->kembali-$cek->cashout;
			}
			//ambil data member
			$kunci=array('kode_member'=>$cek->kode_member);
			$query=$this->model_crud->ambil_data($kunci,'tb_member');
			$cek=$query->row();
			if ($cek) {
				$data['kdmember']=$cek->kode_member;
				$data['member']=$cek->member;
				$data['poin']=$cek->poin;
				$data['koin']=$cek->koin;
			}
		}
		//ambil riwayat koin jika ada
		$kunci=array('faktur_jual'=>$no);
		$query=$this->model_crud->ambil_data($kunci,'tb_riwayatkoin');
		$cek=$query->row();
		if ($cek) {
			$data['tukarkoin']=$cek->jumlah_koin;
		}
		//ambil data retur penjualan
		$kunci=array('tb_returpenjualan.faktur_jual'=>$no);
		$selek='tb_returpenjualan.faktur_jual,tb_returpenjualan.tanggal,tb_returpenjualanmeta.kode_barang,jumlah_retur,tb_returpenjualanmeta.konversi,tb_returpenjualanmeta.satuan_ecer,tb_returpenjualanmeta.harga_jual,total_harga,barang,pegawai';
        $query=$this->model_laporan->datareturjualdetail($selek,$kunci);
        $dataretur=$query->result();
		$data['datajual']=$datajual;
		$data['dataretur']=$dataretur;
		$data['invoice']=$no;
		//ambil data pengaturan
		$kunci=array('1'=>'1');
		$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
		$datapengaturan=$query->result();
		foreach ($datapengaturan as $hasil) {
			$data[$hasil->pengaturan]=$hasil->isi;
		}
		$data['title']='Cetak Nota';
		$this->load->view('transaksi/cetak_nota',$data);
	}

	public function returjual() {
		$data['title']='Retur Penjualan';
		$data['template']='transaksi/view_returjual';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_returjual() {
		$this->load->model('model_laporan');
		$nota=$this->input->post('nota');
		//cek sudah melakukan retur apa belum
		$kunci=array('faktur_jual'=>$nota);
		$query=$this->model_crud->ambil_data($kunci,'tb_returpenjualan');
		$cek=$query->num_rows();
		if ($cek) {
			echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Nomor nota '.$nota.' sudah melakukan retur penjualan sebelumnya!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
		} else {
			//ambil data penjualanmeta
			$kunci=array('tb_penjualan.faktur_jual'=>$nota);
			$selek='tb_penjualanmeta.kode_barang,tb_penjualanmeta.faktur_jual,jumlah_jual,barang';
			$query=$this->model_laporan->datajualdetail($selek,$kunci);
			$data['datajual']=$query->result();
			$data['nota']=$nota;
			$this->load->view('transaksi/ajax_returjual',$data);
		}
	}

	public function simpan_returjual() {
		$nota=$this->input->post('nota');
		$kp=$this->session->userdata('kp');
		//ambil data barang
		$kunci=array('faktur_jual'=>$nota);
		$query=$this->model_crud->ambil_data($kunci,'tb_penjualanmeta');
		$databarang=$query->result();
		if ($databarang) {
			$i=1;
			foreach ($databarang as $hasil) {
				$barang=$this->input->post('kdb'.$i);
				$retur=$this->input->post('retur'.$i);
				//mari kita simpan retur
				if ($barang && $retur<>'') {
					//cek sudah ada data retur apa belum
					$kunci=array('faktur_jual'=>$nota);
					$query=$this->model_crud->ambil_data($kunci,'tb_returpenjualan');
					$cek=$query->row();
					if ($cek) {
						$idretur=$cek->id_returpenjualan;
					} else {
						//tambah data
						$isi=array('faktur_jual'=>$nota,'kode_pegawai'=>$kp);
						$this->model_crud->tambah_data('tb_returpenjualan',$isi);
						$idretur=$this->db->insert_id();
					}
					$kunci=array('faktur_jual'=>$nota,'kode_barang'=>$barang);
					$query=$this->model_crud->ambil_data($kunci,'tb_penjualanmeta');
					$cek=$query->row();
					if ($cek) {
						$jmljual=$cek->jumlah_jual;
						$hargasatuan=($cek->total_harga+$cek->potongan)/$cek->jumlah_jual;
						$hargabeli=$cek->harga_beli;
						$konversi=$cek->konversi;
						$satgrosir=$cek->satuan_grosir;
						$satecer=$cek->satuan_ecer;
						$idmeta=$cek->id_penjualanmeta;
						$totharga=$retur*$hargasatuan;
						//baru tambahkan ke tabel retur meta
						if ($jmljual>=$retur) {
							$isi=array('id_returpenjualan'=>$idretur,'kode_barang'=>$barang,'jumlah_retur'=>$retur,'konversi'=>$konversi,'satuan_grosir'=>$satgrosir,'satuan_ecer'=>$satecer,'harga_jual'=>$hargasatuan,'total_harga'=>$totharga,'harga_beli'=>$hargabeli);
							$this->model_crud->tambah_data('tb_returpenjualanmeta',$isi);
							//update tabel penjualan
							$sisa=$jmljual-$retur;
							$totalharga=$sisa*$hargasatuan;
							$kunci=array('id_penjualanmeta'=>$idmeta);
							if ($sisa<=0) {
							    //hapus transaksi
							    $this->model_crud->hapus_data($kunci,'tb_penjualanmeta');
							} else {
							    $isi=array('jumlah_jual'=>$sisa,'total_harga'=>$totalharga);
							    $this->model_crud->update_data($kunci,'tb_penjualanmeta',$isi);
							}
							//baru kita update stok
							$kunci=array('kode_barang'=>$barang);
							$query=$this->model_crud->ambil_data($kunci,'tb_barang');
							$cek=$query->row();
							if ($cek) {
								//menambah stok
								$stok=$cek->stok+$retur;
								$isi=array('stok'=>$stok);
								$this->model_crud->update_data($kunci,'tb_barang',$isi);
								//masukan ke tabel kartu stok
								$tanggal=date('Y-m-d H:i:s');
								$isi=array('tanggal'=>$tanggal,'kode_barang'=>$barang,'keterangan'=>'Retur Penjualan','masuk'=>$retur,'saldo'=>$stok);
								$this->model_crud->tambah_data('tb_kartustok',$isi);
							}
						}
					}
				}
				$i++;
			}
			//sekarang update total penjualan
			$kunci=array('faktur_jual'=>$nota);
			$query=$this->model_crud->ambil_data($kunci,'tb_penjualanmeta');
			$datajual=$query->result();
			$total=0;
			foreach ($datajual as $hasil) {
				$total=$total+$hasil->total_harga;
			}
			$isi=array('total'=>$total);
			$this->model_crud->update_data($kunci,'tb_penjualan',$isi);
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Retur penjualan berhasil disimpan.
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Retur penjualan berhasil disimpan.';
			$ikon='success';
			$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
			echo json_encode($arr);
		}
	}

	public function permintaan() {
		$data['title']='Transaksi Permintaan Barang';
		$data['template']='transaksi/view_permintaan';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datapermintaan() {
		$req=$_REQUEST;
		$total=$this->model_transaksi->datapermintaan($req,'jumlah');
		$datatab=$this->model_transaksi->datapermintaan($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			if ($hasil->status=='Diinput') {
				$status='<span class="badge bg-warning">'.$hasil->status.'</span>';
			} else if ($hasil->status=='Selesai') {
				$status='<span class="badge bg-success">'.$hasil->status.'</span>';
			} else {
				$status='<span class="badge bg-danger">'.$hasil->status.'</span>';
			}
			$datanya[]=date('d-m-Y',strtotime($hasil->tanggal));
			$datanya[]=$hasil->kode_permintaan;
			$datanya[]=$hasil->suplier;
			$datanya[]=$hasil->barang;
			$datanya[]=$hasil->keterangan;
			$datanya[]=$status;
			$datanya[]='<a href="'.base_url('transaksi/cetak_permintaan?id='.$hasil->kode_permintaan).'" class="btn btn-secondary btn-xs" target="_blank" title="Cetak"><i class="fa fa-print"></i></a>';
			$datanya[]='<button type="button" title="Hapus" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->kode_permintaan.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_permintaan() {
		$data['aksi']='Simpan';
		$data['tanggal']=date('Y-m-d');
		//ambil data suplier
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_suplier');
		$data['datasuplier']=$query->result();
		$data['title']='Form Permintaan Barang';
		$data['template']='transaksi/form_permintaan';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_permintaan() {
		$id=$this->input->post('id');
		$this->load->model('model_master');
		//ambil data barang suplier
		$kunci=array('tb_supliermeta.kode_suplier'=>$id);
		$query=$this->model_master->databarangsuplier($kunci);
		$data['databarang']=$query->result();
		$this->load->view('transaksi/ajax_permintaan',$data);
	}

	public function simpan_permintaan() {
		$kp=$this->session->userdata('kp');
		$tgl=date('YmdHis');
		if ($this->input->post('kode')) {
			$kode=$this->input->post('kode');
		} else {
			$kode='PO'.$tgl;
		}
		$suplier=$this->input->post('suplier');
		$tanggal=$this->input->post('tanggal');
		$kdb=$this->input->post('kdb');
		$minta=$this->input->post('minta');
		$aksi=$this->input->post('aksi');
		if ($kdb) {
			//tambah data permintaan
			$isi=array('kode_permintaan'=>$kode,'kode_suplier'=>$suplier,'status'=>'Diinput');
			$this->model_crud->tambah_data('tb_permintaan',$isi);
			foreach ($kdb as $key => $value) {
				//cek stok barang dengan kode
				$kunci=array('kode_barang'=>$value,'aktif'=>1);
				$query=$this->model_crud->ambil_data($kunci,'tb_barang');
				$cek=$query->row();
				if ($cek) {
					$hargabeli=$cek->harga_beli;
					$kdbarang=$cek->kode_barang;
					//ambil satuan barang
					$kunci=array('kode_barang'=>$kdbarang);
					$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
					$ceker=$query->row();
					if ($ceker) {
						$satuan=$ceker->satuan1;
					} else {
						$satuan='';
					}
					$totharga=$hargabeli*$minta[$key];
					$isi=array('kode_permintaan'=>$kode,'kode_barang'=>$kdbarang,'jumlah'=>$minta[$key],'satuan'=>$satuan,'total_harga'=>$totharga,'harga_beli'=>$hargabeli);
					$this->model_crud->tambah_data('tb_permintaanmeta',$isi);
				}
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Transaksi permintaan barang berhasil disimpan.
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Transaksi permintaan barang berhasil disimpan.';
				$ikon='success';
			} 
		} else {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Tidak ada daftar barang yang dimasukan ke daftar permintaan!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Tidak ada daftar barang yang dimasukan ke daftar permintaan!';
			$ikon='error';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function hapus_permintaan() {
		$id=$this->input->post('id');
		$kunci=array('kode_permintaan'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_permintaan');
		$cek=$query->row();
		if ($cek) {
			if ($cek->status=='Diinput') {
				$this->model_crud->hapus_data($kunci,'tb_permintaan');
				$pesan='<div class="alert alert-warning alert-dismissible fade show" role="alert">
							Data permintaan barang berhasil dihapus!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Data permintaan barang berhasil dihapus!';
				$ikon='warning';
			} else {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Permintaan barang sudah tidak bisa dihapus!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Permintaan barang sudah tidak bisa dihapus!';
				$ikon='error';
			}
		} else {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Tidak ada datang permintaan barang yang dihapus!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Tidak ada datang permintaan barang yang dihapus!';
			$ikon='error';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function cetak_permintaan() {
		$id=$this->input->get('id');
		$kunci=array('kode_permintaan'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_permintaan');
		$cek=$query->row();
		if ($cek) {
			$data['kode']=$cek->kode_permintaan;
			$data['tanggal']=date('d-m-Y',strtotime($cek->tanggal));
			//nama toko
			$kunci=array('kode_suplier'=>$cek->kode_suplier);
			$query=$this->model_crud->ambil_data($kunci,'tb_suplier');
			$ceker=$query->row();
			if ($ceker) {
				$data['suplier']=$ceker->suplier;
				$data['alamatsuplier']=$ceker->alamat;
				$data['teleponsuplier']=$ceker->telepon;
			}
			//ambil data barang
			$selek='tb_permintaanmeta.kode_barang,jumlah,tb_permintaanmeta.satuan,tb_permintaanmeta.harga_beli,tb_permintaanmeta.total_harga,barcode,barang';
			$kunci=array('tb_permintaan.kode_permintaan'=>$cek->kode_permintaan);
			$query=$this->model_transaksi->databarangpermintaan($selek,$kunci);
			$data['databarang']=$query->result();
		}
		//ambil data pengaturan
		$kunci=array('1'=>'1');
		$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
		$datapengaturan=$query->result();
		foreach ($datapengaturan as $hasil) {
			$data[$hasil->pengaturan]=$hasil->isi;
		}
		$data['title']='Cetak Permintaan Barang';
		$this->load->view('transaksi/cetak_permintaan',$data);
	}

	public function masuk() {
		$data['tanggal']=date('Y-m-d');
		$data['title']='Transaksi Barang Masuk';
		$data['template']='transaksi/view_masuk';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function ajax_masuk() {
		$kode=$this->input->post('kode');
		//ambil data barang
		$kunci=array('tb_permintaan.kode_permintaan'=>$kode);
		$selek='id_permintaanmeta,tb_permintaanmeta.kode_barang,barang,tb_permintaanmeta.jumlah,tb_permintaanmeta.harga_beli,jumlah_diterima,harga_satuan_diterima';
		$query=$this->model_transaksi->databarangpermintaan($selek,$kunci);
		$data['databarang']=$query->result();
		$this->load->view('transaksi/ajax_masuk',$data);
	}

	public function simpan_masuk() {
		$id=$this->input->post('id');
		$diterima=$this->input->post('diterima');
		$hargabeli=$this->input->post('hargabeli');
		$kp=$this->session->userdata('kp');
		$total=$diterima*$hargabeli;
		//update data dulu
		$kunci=array('id_permintaanmeta'=>$id);
		$isi=array('jumlah_diterima'=>$diterima,'harga_satuan_diterima'=>$hargabeli,'total_harga_diterima'=>$total);
		$this->model_crud->update_data($kunci,'tb_permintaanmeta',$isi);
	}

	public function simpan_ajusmenmasuk() {
		$tanggal=$this->input->post('tanggal');
		$nota=$this->input->post('nota');
		$terbayar=$this->input->post('terbayar');
		$utang=$this->input->post('utang');
		$tempo=$this->input->post('tempo');
		$catatan=$this->input->post('catatan');
		$po=$this->input->post('po');
		$kodemasuk='MSK-'.date('YmdHis');
		$kp=$this->session->userdata('kp');
		//ambil pengaturan receh
		$kunci=array('pengaturan'=>'receh');
		$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
		$cek=$query->row();
		if ($cek) {
			$receh=$cek->isi;
		} else {
			$receh=1;
		}
		//ambil data
		$kunci=array('no_nota'=>$nota);
		$query=$this->model_crud->ambil_data($kunci,'tb_masuk');
		$cek=$query->row();
		if ($cek) {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Nomor nota barang masuk sudah dinputkan!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Nomor nota barang masuk sudah dinputkan!';
			$ikon='error';
		} else {
			//ambil data barang
			$kunci=array('kode_permintaan'=>$po);
			$query=$this->model_crud->ambil_data($kunci,'tb_permintaanmeta');
			$databarang=$query->result();
			$total=0;
			foreach ($databarang as $hasil) {
				//cek data barang
				$kunci=array('kode_barang'=>$hasil->kode_barang);
				$query=$this->model_crud->ambil_data($kunci,'tb_barang');
				$cek=$query->row();
				if ($cek) {
					$jumasuk=$hasil->jumlah_diterima;
					$hargabeli=$hasil->harga_satuan_diterima;
					if ($cek->harga_beli<>0) {
					    $hpp=$cek->harga_beli;
					} else {
					    $hpp=0.1;
					}
					//mari kita update harga jual
					$kunci=array('kode_barang'=>$hasil->kode_barang);
					$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
					$ceker=$query->row();
					if ($ceker) {
						//update harga jual
						$selisih1=$ceker->harga_jual1-$cek->harga_beli;
						$persen1=$selisih1/$hpp*100;
						$margin1=$hargabeli*$persen1/100;
						$jual1=$hargabeli+round($margin1);
						$bagi1=$jual1/$receh;
						$bulat1=round($bagi1);
						$hargajual1=$bulat1*$receh;
						//update harga jual 2
						$selisih2=$ceker->harga_jual2-$cek->harga_beli;
						$persen2=$selisih2/$hpp*100;
						$margin2=$hargabeli*$persen2/100;
						$jual2=$hargabeli+round($margin2);
						$bagi2=$jual2/$receh;
						$bulat2=round($bagi2);
						$hargajual2=$bulat2*$receh;
						//update harga jual 3
						$selisih3=$ceker->harga_jual3-$cek->harga_beli;
						$persen3=$selisih3/$hpp*100;
						$margin3=$hargabeli*$persen3/100;
						$jual3=$hargabeli+round($margin3);
						$bagi3=$jual3/$receh;
						$bulat3=round($bagi3);
						$hargajual3=$bulat3*$receh;
						//update harga jual
						$isi=array('harga_jual1'=>$hargajual1,'harga_jual2'=>$hargajual2,'harga_jual3'=>$hargajual3);
						$this->model_crud->update_data($kunci,'tb_satuanbarang',$isi);
					}

					$stok=$cek->stok+$jumasuk;
					$isi=array('harga_beli'=>$hargabeli,'stok'=>$stok);
					$this->model_crud->update_data($kunci,'tb_barang',$isi);
					//masukan ke tabel kartu stok
					$tanggal=date('Y-m-d H:i:s');
					$isi=array('tanggal'=>$tanggal,'kode_barang'=>$cek->kode_barang,'keterangan'=>'Barang Masuk','masuk'=>$jumasuk,'saldo'=>$stok);
					$this->model_crud->tambah_data('tb_kartustok',$isi);
				}
				$total=$total+$hasil->total_harga_diterima;
			}
			$isi=array('kode_masuk'=>$kodemasuk,'tanggal'=>$tanggal,'no_nota'=>$nota,'kode_permintaan'=>$po,'total'=>$total,'terbayar'=>$terbayar,'kode_pegawai'=>$kp,'catatan'=>$catatan);
			$this->model_crud->tambah_data('tb_masuk',$isi);
			//masukan ke tabel hutang
			if ($utang) {
				$isi=array('kode_masuk'=>$kodemasuk,'tanggal'=>$tanggal,'terbayar'=>$terbayar,'hutang'=>$utang,'sisa'=>$utang,'tempo'=>$tempo);
				$this->model_crud->tambah_data('tb_hutang',$isi);
			}
			//update tabel permintaan
			$kunci=array('kode_permintaan'=>$po);
			$isi=array('status'=>'Selesai');
			$this->model_crud->update_data($kunci,'tb_permintaan',$isi);
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Data barang masuk berhasil disimpan!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Data barang masuk berhasil disimpan!';
			$ikon='success';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function returbeli() {
		$data['tanggal']=date('Y-m-d');
		//ambil data suplier
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_suplier');
		$data['datasuplier']=$query->result();
		$data['title']='Retur Pembelian';
		$data['template']='transaksi/view_returbeli';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datareturbeli() {
		$req=$_REQUEST;
		$total=$this->model_transaksi->datareturbeli($req,'jumlah');
		$datatab=$this->model_transaksi->datareturbeli($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=date('d-m-Y',strtotime($hasil->tanggal));
			$datanya[]=$hasil->suplier;
			$datanya[]=$hasil->jumbarang;
			$datanya[]=number_format($hasil->total,0,',','.');
			$datanya[]='<a href="'.base_url('transaksi/cetak_returbeli?id='.$hasil->id_returpembelian).'" title="Cetak" target="_blank" target="_blank" class="btn btn-secondary btn-xs"><i class="fa fa-print"></i></a>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_returbeli() {
		$data['tanggal']=date('Y-m-d');
		//ambil data suplier
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_suplier');
		$data['datasuplier']=$query->result();
		$data['title']='Retur Pembelian';
		$data['template']='transaksi/form_returbeli';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datakeranjangreturbeli() {
		$kp=$this->session->userdata('kp');
		$req=$_REQUEST;
		$kunci=array('tb_keranjang.kode_pegawai'=>$kp,'status'=>'rb');
		$total=$this->model_transaksi->datakeranjang($kunci);
		$datatab=$this->model_transaksi->datakeranjang($kunci);
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=$hasil->kode_barang;
			$datanya[]=$hasil->barang;
			$datanya[]=$hasil->jumlah;
			$datanya[]=number_format($hasil->beli,0,',','.');
			$datanya[]=number_format($hasil->jum_harga,0,',','.');
			$datanya[]='<button type="button" title="Pilih" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->token.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function simpan_keranjangreturbeli() {
		$kode=$this->input->post('kode');
		$jumlah=$this->input->post('jumlah');
		$kp=$this->session->userdata('kp');
		if ($kode && $jumlah) {
			//cek stok barang dengan kode
			$kunci=array('kode_barang'=>$kode,'aktif'=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_barang');
			$cek=$query->row();
			if ($cek) {
				$stok=$cek->stok;
				$stokmaksimal=$cek->stok_maksimal;
				$kdbarang=$cek->kode_barang;
				$hargabeli=$cek->harga_beli;
			} else {
				//cek stok barang dengan barcode
				$kunci=array('barcode'=>$kode);
				$query=$this->model_crud->ambil_data($kunci,'tb_barang');
				$cek=$query->row();
				if ($cek) {
					$stok=$cek->stok;
					$stokmaksimal=$cek->stok_maksimal;
					$kdbarang=$cek->kode_barang;
					$hargabeli=$cek->harga_beli;
				} else {
					$stok=0;
					$stokmaksimal=0;
					$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
								Data barang tidak ditemukan!
								<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
							</div>';
					$toas='Data barang tidak ditemukan!';
					$ikon='error';
					$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
					echo json_encode($arr);
					die();
				}
			}
			//selanjutnya input transaksi permintaan
			$totharga=$jumlah*$hargabeli;
			//cari satuan
			$kunci=array('kode_barang'=>$kdbarang);
			$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
			$cek=$query->row();
			if ($cek) {
				$satuan=$cek->satuan1;
				$konversi=1;
			} else {
				$satuan='';
				$konversi=1;
			}
			//cek jumlah retur dengan stok yang ada
			//cek data keranjang dulu
			$kunci=array('kode_barang'=>$kdbarang,'status'=>'rb','kode_pegawai'=>$kp);
			$query=$this->model_crud->ambil_data($kunci,'tb_keranjang');
			$cek=$query->row();
			if ($cek) {
				$jumlah=$jumlah+$cek->jumlah;
				$totharga=$hargabeli*$jumlah;
				//update ke tabel keranjang
				$isi=array('jumlah'=>$jumlah,'satuan_jual'=>$satuan,'konversi'=>$konversi,'jum_harga'=>$totharga);
				$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
				$pesan='';
				$toas='Item barang telah ditambahkan';
				$ikon='success';
				$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
			} else {
				$isi=array('token'=>date('YmdHis'),'kode_barang'=>$kdbarang,'jumlah'=>$jumlah,'satuan_jual'=>$satuan,'konversi'=>$konversi,'jum_harga'=>$totharga,'status'=>'rb','kode_pegawai'=>$kp);
				$this->model_crud->tambah_data('tb_keranjang',$isi);
				$pesan='';
				$toas='Item barang telah ditambahkan';
				$ikon='success';
				$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
			}
		} else {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Barang dan jumlah permintaan belum diisi!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Barang dan jumlah permintaan belum diisi!';
			$ikon='error';
			$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		}
		echo json_encode($arr);
	}

	public function simpan_returbeli() {
		$tanggal=$this->input->post('tanggal');
		$suplier=$this->input->post('suplier');
		$kp=$this->session->userdata('kp');
		//ambil data barang di tabel keranjang
		$kunci=array('kode_pegawai'=>$kp,'status'=>'rb');
		$query=$this->model_crud->ambil_data($kunci,'tb_keranjang');
		$databarang=$query->result();
		if ($databarang) {
			foreach ($databarang as $hasil) {
				//mari kita simpan retur
				if ($hasil->kode_barang && $hasil->jumlah>0) {
					//cek sudah ada data retur apa belum
					$kunci=array('tanggal'=>$tanggal,'kode_suplier'=>$suplier,'kode_pegawai'=>$kp);
					$query=$this->model_crud->ambil_data($kunci,'tb_returpembelian');
					$cek=$query->row();
					if ($cek) {
						$idretur=$cek->id_returpembelian;
					} else {
						//tambah data
						$isi=array('tanggal'=>$tanggal,'kode_suplier'=>$suplier,'kode_pegawai'=>$kp);
						$this->model_crud->tambah_data('tb_returpembelian',$isi);
						$idretur=$this->db->insert_id();
					}
					//masukan ke tabel retur pembelian meta
					$hargasatuan=$hasil->jum_harga/$hasil->jumlah;
					$isi=array('id_returpembelian'=>$idretur,'kode_barang'=>$hasil->kode_barang,'jumlah_retur'=>$hasil->jumlah,'konversi'=>$hasil->konversi,'satuan'=>$hasil->satuan_jual,'total_harga'=>$hasil->jum_harga,'harga_beli'=>$hargasatuan);
					$this->model_crud->tambah_data('tb_returpembelianmeta',$isi);
					//baru kita update stok
					$kunci=array('kode_barang'=>$hasil->kode_barang);
					$query=$this->model_crud->ambil_data($kunci,'tb_barang');
					$cek=$query->row();
					if ($cek) {
						//mengurangi stok
						$stok=$cek->stok-$hasil->jumlah;
						$isi=array('stok'=>$stok);
						$this->model_crud->update_data($kunci,'tb_barang',$isi);
						//masukan ke tabel kartu stok
						$tanggal=date('Y-m-d H:i:s');
						$isi=array('tanggal'=>$tanggal,'kode_barang'=>$cek->kode_barang,'keterangan'=>'Retur Pembelian','keluar'=>$hasil->jumlah,'saldo'=>$stok);
						$this->model_crud->tambah_data('tb_kartustok',$isi);
					}
				}
			}
			//hapus data keranjang
			$kunci=array('kode_pegawai'=>$kp,'status'=>'rb');
			$this->model_crud->hapus_data($kunci,'tb_keranjang');
			$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
						Retur pembelian berhasil disimpan
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Retur pembelian berhasil disimpan';
			$ikon='success';
		} else {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Tidak ada barang yang diretur pembelian!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Tidak ada barang yang diretur pembelian!';
			$ikon='error';
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function cetak_returbeli() {
		$id=$this->input->get('id');
		$this->load->helper('umum');
		$kunci=array('id_returpembelian'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_returpembelian');
		$cek=$query->row();
		if ($cek) {
			$data['tanggal']=tanggalindo($cek->tanggal);
			$data['no']=$cek->id_returpembelian;
			//nama toko
			$kunci=array('kode_suplier'=>$cek->kode_suplier);
			$query=$this->model_crud->ambil_data($kunci,'tb_suplier');
			$ceker=$query->row();
			if ($ceker) {
				$data['suplier']=$ceker->suplier;
				$data['alamatsuplier']=$ceker->alamat;
				$data['teleponsuplier']=$ceker->telepon;
			}
			//ambil data barang
			$selek='tb_returpembelianmeta.kode_barang,jumlah_retur,tb_returpembelianmeta.satuan,tb_returpembelianmeta.harga_beli,tb_returpembelianmeta.total_harga,barcode,barang';
			$kunci=array('tb_returpembelian.id_returpembelian'=>$cek->id_returpembelian);
			$query=$this->model_transaksi->databarangreturpembelian($selek,$kunci);
			$data['databarang']=$query->result();
		}
		$kunci=array('1'=>'1');
		$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
		$datapengaturan=$query->result();
		foreach ($datapengaturan as $hasil) {
			$data[$hasil->pengaturan]=$hasil->isi;
		}
		$data['title']='Cetak Retur Pembelian';
		$this->load->view('transaksi/cetak_returbeli',$data);
	}

	public function mutasi() {
		$data['title']='Mutasi Barang';
		$data['template']='transaksi/view_mutasi';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datamutasi() {
		$req=$_REQUEST;
		$total=$this->model_transaksi->datamutasi($req,'jumlah');
		$datatab=$this->model_transaksi->datamutasi($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=date('d-m-Y',strtotime($hasil->tanggal));
			$datanya[]=$hasil->kode_mutasi;
			$datanya[]=$hasil->toko;
			$datanya[]=$hasil->barang;
			$datanya[]='<a href="'.base_url('transaksi/cetak_mutasi?id='.$hasil->kode_mutasi).'" class="btn btn-secondary btn-sm" target="_blank" title="Cetak"><i class="bi bi-printer"></i></a>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_mutasi() {
		$data['aksi']='Simpan';
		//ambil data suplier
		$kunci=array('aktif'=>1);
		$query=$this->model_crud->ambil_data($kunci,'tb_toko');
		$data['datatoko']=$query->result();
		$data['title']='Form Mutasi Barang';
		$data['template']='transaksi/form_mutasi';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datakeranjangmutasi() {
		$kp=$this->session->userdata('kp');
		$req=$_REQUEST;
		$kunci=array('tb_keranjang.kode_pegawai'=>$kp,'status'=>'mutasi');
		$total=$this->model_transaksi->datakeranjang($kunci);
		$datatab=$this->model_transaksi->datakeranjang($kunci);
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=$hasil->kode_barang;
			$datanya[]=$hasil->barang;
			$datanya[]=$hasil->jumlah;
			$datanya[]=number_format($hasil->beli,0,',','.');
			$datanya[]=number_format($hasil->jum_harga,0,',','.');
			$datanya[]='<button type="button" title="Pilih" onclick="konfirhapus(this.value)" class="btn btn-danger btn-sm" value="'.$hasil->token.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function simpan_keranjangmutasi() {
		$kode=$this->input->post('kode');
		$jumlah=$this->input->post('jumlah');
		$kp=$this->session->userdata('kp');
		if ($kode && $jumlah) {
			//cek stok barang dengan kode
			$kunci=array('kode_barang'=>$kode,'aktif'=>1);
			$query=$this->model_crud->ambil_data($kunci,'tb_barang');
			$cek=$query->row();
			if ($cek) {
				$stok=$cek->stok;
				$stokmaksimal=$cek->stok_maksimal;
				$kdbarang=$cek->kode_barang;
				$hargabeli=$cek->harga_beli;
				$satgrosir=$cek->satuan_grosir;
				$konversi=$cek->konversi;
			} else {
				//cek stok barang dengan barcode
				$kunci=array('barcode'=>$kode);
				$query=$this->model_crud->ambil_data($kunci,'tb_barang');
				$cek=$query->row();
				if ($cek) {
					$stok=$cek->stok;
					$stokmaksimal=$cek->stok_maksimal;
					$kdbarang=$cek->kode_barang;
					$hargabeli=$cek->harga_beli;
					$satgrosir=$cek->satuan_grosir;
					$konversi=$cek->konversi;
				} else {
					$stok=0;
					$stokmaksimal=0;
					$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
								Data barang tidak ditemukan!
								<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
							</div>';
					$toas='Data barang tidak ditemukan!';
					$ikon='error';
					$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
					echo json_encode($arr);
					die();
				}
			}
			//selanjutnya input transaksi permintaan
			$totharga=$jumlah*$hargabeli;
			//cek data keranjang dulu
			$kunci=array('kode_barang'=>$kode,'status'=>'mutasi','kode_pegawai'=>$kp);
			$query=$this->model_crud->ambil_data($kunci,'tb_keranjang');
			$cek=$query->row();
			if ($cek) {
				$jumlah=$jumlah+$cek->jumlah;
				$totharga=$hargabeli*$jumlah;
				//update ke tabel keranjang
				$isi=array('jumlah'=>$jumlah,'satuan'=>$satgrosir,'konversi'=>$konversi,'jum_harga'=>$totharga);
				$this->model_crud->update_data($kunci,'tb_keranjang',$isi);
			} else {
				$isi=array('token'=>date('YmdHis'),'kode_barang'=>$kdbarang,'jumlah'=>$jumlah,'satuan'=>$satgrosir,'konversi'=>$konversi,'jum_harga'=>$totharga,'status'=>'mutasi','kode_pegawai'=>$kp);
				$this->model_crud->tambah_data('tb_keranjang',$isi);
				die();
			}
		} else {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Barang dan jumlah mutasi belum diisi!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Barang dan jumlah mutasi belum diisi!';
			$ikon='error';
			$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
			echo json_encode($arr);
		}
	}

	public function simpan_mutasi() {
		$kp=$this->session->userdata('kp');
		$tanggal=date('YmdHis');
		if ($this->input->post('kode')) {
			$kode=$this->input->post('kode');
		} else {
			$kode='MT'.$tanggal;
		}
		$toko=$this->input->post('toko');
		$id=$this->input->post('id');
		$aksi=$this->input->post('aksi');
		if ($aksi=='Simpan') {
			//cek tabel keranjang dulu
			$kunci=array('status'=>'mutasi','kode_pegawai'=>$kp);
			$query=$this->model_crud->ambil_data($kunci,'tb_keranjang');
			$datakeranjang=$query->result();
			if ($datakeranjang) {
				//tambah data mutasi
				$isi=array('kode_mutasi'=>$kode,'kode_toko'=>$toko,'kode_pegawai'=>$kp);
				$this->model_crud->tambah_data('tb_mutasi',$isi);
				//masukan ke tabel permintaan meta
				foreach ($datakeranjang as $hasil) {
					//cek data barang
					$kunci=array('kode_barang'=>$hasil->kode_barang);
					$query=$this->model_crud->ambil_data($kunci,'tb_barang');
					$cek=$query->row();
					if ($cek) {
						//masukan ke tabel pembelian meta
						$isi=array('kode_mutasi'=>$kode,'kode_barang'=>$hasil->kode_barang,'jumlah'=>$hasil->jumlah,'konversi'=>$hasil->konversi,'satuan_ecer'=>$cek->satuan_ecer,'satuan_grosir'=>$cek->satuan_grosir,'total_harga'=>$hasil->jum_harga,'harga_beli'=>$cek->harga_beli);
						$this->model_crud->tambah_data('tb_mutasimeta',$isi);
						//kurangi stok
						$stok=$cek->stok-$hasil->jumlah;
						$isi=array('stok'=>$stok);
						$this->model_crud->update_data($kunci,'tb_barang',$isi);
						//masukan ke tabel kartu stok
						$tanggal=date('Y-m-d H:i:s');
						$isi=array('tanggal'=>$tanggal,'kode_barang'=>$hasil->kode_barang,'keterangan'=>'Mutasi Barang Keluar','keluar'=>$hasil->jumlah,'saldo'=>$stok);
						$this->model_crud->tambah_data('tb_kartustok',$isi);
					}
				}
				//hapus data keranjang
				$kunci=array('kode_pegawai'=>$kp,'status'=>'mutasi');
				$this->model_crud->hapus_data($kunci,'tb_keranjang');
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Transaksi mutasi barang berhasil disimpan
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Transaksi mutasi barang berhasil disimpan';
				$ikon='success';
			} else {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Tidak ada daftar barang yang dimasukan ke daftar mutasi!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Tidak ada daftar barang yang dimasukan ke daftar mutasi!';
				$ikon='error';
			}
			$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
			echo json_encode($arr);
		}
	}

	public function cetak_mutasi() {
		$id=$this->input->get('id');
		$kunci=array('kode_mutasi'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_mutasi');
		$cek=$query->row();
		if ($cek) {
			$data['kode']=$cek->kode_mutasi;
			$data['tanggal']=date('d-m-Y',strtotime($cek->tanggal));
			//nama toko
			$kunci=array('kode_toko'=>$cek->kode_toko);
			$query=$this->model_crud->ambil_data($kunci,'tb_toko');
			$ceker=$query->row();
			if ($ceker) {
				$data['nmtoko']=$ceker->toko;
				$data['alamattoko']=$ceker->alamat;
				$data['telepontoko']=$ceker->telepon;
			}
			//ambil data barang
			$selek='tb_mutasimeta.kode_barang,jumlah,tb_mutasimeta.satuan_ecer,tb_mutasimeta.harga_beli,tb_mutasimeta.total_harga,barcode,barang';
			$kunci=array('tb_mutasi.kode_mutasi'=>$cek->kode_mutasi);
			$query=$this->model_transaksi->databarangmutasi($selek,$kunci);
			$data['databarang']=$query->result();
		}
		//ambil data pengaturan
		$kunci=array('1'=>'1');
		$query=$this->model_crud->ambil_data($kunci,'tb_pengaturan');
		$datapengaturan=$query->result();
		foreach ($datapengaturan as $hasil) {
			$data[$hasil->pengaturan]=$hasil->isi;
		}
		$data['title']='Cetak Mutasi Barang';
		$this->load->view('transaksi/cetak_mutasi',$data);
	}

	public function bayarpiutang() {
		$data['title']='Pembayaran Piutang';
		$data['template']='transaksi/view_bayarpiutang';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function databayarpiutang() {
		$req=$_REQUEST;
		$total=$this->model_transaksi->databayarpiutang($req,'jumlah');
		$datatab=$this->model_transaksi->databayarpiutang($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$terbayar=$hasil->piutang-$hasil->sisa;
			$datanya=array();
			$datanya[]=date('d-m-Y',strtotime($hasil->tanggal));
			$datanya[]='<a href="'.base_url('transaksi/cetak_faktur?no='.$hasil->faktur_jual).'" target="_blank" title="Cetak struk">'.$hasil->faktur_jual.'</a>';
			$datanya[]=$hasil->kode_member;
			$datanya[]=$hasil->member;
			$datanya[]=number_format($hasil->piutang,0,',','.');
			$datanya[]=number_format($hasil->sisa,0,',','.');
			$datanya[]=number_format($terbayar,0,',','.');
			$datanya[]='<button type="button" class="btn btn-success btn-xs" title="Bayar piutang" onclick="tampilform(this.value)" value="'.$hasil->id_piutang.'"><i class="fa fa-credit-card"></i></button>';
			//$datanya[]='<button type="button" title="Hapus" onclick="konfirhapus(this.value)" class="btn btn-danger btn-xs" value="'.$hasil->id_piutang.'"><i class="fa fa-trash"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_bayarpiutang() {
		$id=$this->input->post('id');
		$kunci=array('id_piutang'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_piutang');
		$cek=$query->row();
		if ($cek) {
			$data['faktur']=$cek->faktur_jual;
			$data['piutang']=$cek->piutang;
			$data['sisa']=$cek->sisa;
			$data['id']=$cek->id_piutang;
			//cari kode dan nama member
			$kunci=array('faktur_jual'=>$cek->faktur_jual);
			$query=$this->model_crud->ambil_data($kunci,'tb_penjualan');
			$cekrek=$query->row();
			if ($cekrek) {
				$data['member']=$cekrek->kode_member;
				$kunci=array('kode_member'=>$cekrek->kode_member);
				$query=$this->model_crud->ambil_data($kunci,'tb_member');
				$ceker=$query->row();
				if ($ceker) {
					$data['nama']=$ceker->member;
				}
			}
		}
		$data['tanggal']=date('Y-m-d');
		$data['title']='Form Pembayaran Piutang';
		$this->load->view('transaksi/form_bayarpiutang',$data);
	}

	public function simpan_bayarpiutang() {
		$kp=$this->session->userdata('kp');
		$tanggal=$this->input->post('tanggal');
		$sisa=$this->input->post('sisa');
		$bayar=$this->input->post('bayar');
		$id=$this->input->post('id');
		//cek pembayaran dulu
		$kunci=array('id_piutang'=>$id,'tanggal'=>$tanggal,'bayar'=>$bayar);
		$query=$this->model_crud->ambil_data($kunci,'tb_bayarpiutang');
		$cek=$query->row();
		if ($cek) {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Pembayaran piutang sudah diinput sebelumnya!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Pembayaran piutang sudah diinput sebelumnya!';
			$ikon='error';
		} else {
			if ($bayar<=$sisa) {
				$isi=array('tanggal'=>$tanggal,'id_piutang'=>$id,'bayar'=>$bayar,'kode_pegawai'=>$kp);
				$this->model_crud->tambah_data('tb_bayarpiutang',$isi);
				$sisanya=$sisa-$bayar;
				$kunci=array('id_piutang'=>$id);
				$isi=array('sisa'=>$sisanya);
				$this->model_crud->update_data($kunci,'tb_piutang',$isi);
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Pembayaran piutang berhasil disimpan
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Pembayaran piutang berhasil disimpan';
				$ikon='success';
			} else {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Jumlah pembayaran lebih besar daripada sisa!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Jumlah pembayaran lebih besar daripada sisa!';
				$ikon='error';
			}
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function bayarhutang() {
		$data['title']='Pembayaran Hutang';
		$data['template']='transaksi/view_bayarhutang';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function databayarhutang() {
		$req=$_REQUEST;
		$total=$this->model_transaksi->databayarhutang($req,'jumlah');
		$datatab=$this->model_transaksi->databayarhutang($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$terbayar=$hasil->hutang-$hasil->sisa;
			$datanya=array();
			$datanya[]=date('d-m-Y',strtotime($hasil->tanggal));
			$datanya[]='<a href="'.base_url('transaksi/cetak_masuk?no='.$hasil->kode_masuk).'" target="_blank" title="Cetak struk">'.$hasil->kode_masuk.'</a>';
			$datanya[]=$hasil->no_nota;
			$datanya[]=$hasil->suplier;
			$datanya[]=number_format($hasil->hutang,0,',','.');
			$datanya[]=number_format($hasil->sisa,0,',','.');
			$datanya[]=number_format($terbayar,0,',','.');
			$datanya[]=date('d-m-Y',strtotime($hasil->tempo));
			$datanya[]='<button type="button" class="btn btn-success btn-xs" title="Bayar piutang" onclick="tampilform(this.value)" value="'.$hasil->id_hutang.'"><i class="fa fa-credit-card"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_bayarhutang() {
		$id=$this->input->post('id');
		$kunci=array('id_hutang'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_hutang');
		$cek=$query->row();
		if ($cek) {
			$data['kode']=$cek->kode_masuk;
			$data['hutang']=$cek->hutang;
			$data['sisa']=$cek->sisa;
			$data['id']=$cek->id_hutang;
			//cari nomor nota
			$kunci=array('kode_masuk'=>$cek->kode_masuk);
			$query=$this->model_crud->ambil_data($kunci,'tb_masuk');
			$cekrek=$query->row();
			if ($cekrek) {
				$data['nota']=$cekrek->no_nota;
			}
		}
		$data['tanggal']=date('Y-m-d');
		$data['title']='Form Pembayaran Hutang';
		$this->load->view('transaksi/form_bayarhutang',$data);
	}

	public function simpan_bayarhutang() {
		$kp=$this->session->userdata('kp');
		$tanggal=$this->input->post('tanggal');
		$sisa=$this->input->post('sisa');
		$bayar=$this->input->post('bayar');
		$id=$this->input->post('id');
		//cek pembayaran dulu
		$kunci=array('id_hutang'=>$id,'tanggal'=>$tanggal,'bayar'=>$bayar);
		$query=$this->model_crud->ambil_data($kunci,'tb_bayarhutang');
		$cek=$query->row();
		if ($cek) {
			$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
						Pembayaran hutang sudah diinput sebelumnya!
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					</div>';
			$toas='Pembayaran hutang sudah diinput sebelumnya!';
			$ikon='error';
		} else {
			if ($bayar<=$sisa) {
				$isi=array('tanggal'=>$tanggal,'id_hutang'=>$id,'bayar'=>$bayar,'kode_pegawai'=>$kp);
				$this->model_crud->tambah_data('tb_bayarhutang',$isi);
				$sisanya=$sisa-$bayar;
				$kunci=array('id_hutang'=>$id);
				$isi=array('sisa'=>$sisanya);
				$this->model_crud->update_data($kunci,'tb_hutang',$isi);
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Pembayaran hutang berhasil disimpan
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Pembayaran hutang berhasil disimpan';
				$ikon='success';
			} else {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Jumlah pembayaran lebih besar daripada sisa!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Jumlah pembayaran lebih besar daripada sisa!';
				$ikon='error';
			}
		}
		$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
		echo json_encode($arr);
	}

	public function setoran() {
		$data['title']='Setoran Kasir';
		$data['template']='transaksi/view_setoran';
		$data['footer']='layout/footer';
		$data['footerend']='layout/footerend';
		$this->load->view('layout/wrapper',$data);
	}

	public function datasetoran() {
		$req=$_REQUEST;
		$total=$this->model_transaksi->datasetoran($req,'jumlah');
		$datatab=$this->model_transaksi->datasetoran($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$returan=$this->total_returjual($hasil->tanggal);
			if ($hasil->bayar_nontunai>=$hasil->kembalian) {
				$kembalian=$hasil->kembalian-$hasil->bayar_nontunai;
				$tunai=$hasil->bayar_tunai-$kembalian;
				$non=0;
			} else {
				$kembalian=$hasil->kembalian-$hasil->bayar_tunai;
				$tunai=0;
				$non=$hasil->bayar_nontunai-$kembalian;
			}
			$selisih=$hasil->selisih+$returan;
			$datanya=array();
			$datanya[]=date('d-m-Y',strtotime($hasil->tanggal));
			$datanya[]=number_format($hasil->pendapatan_jual,0,',','.');
			$datanya[]=number_format($hasil->bayar_tunai,0,',','.');
			$datanya[]=number_format($hasil->bayar_nontunai,0,',','.');
			$datanya[]=number_format($hasil->cashout,0,',','.');
			$datanya[]=number_format($hasil->uang_cash,0,',','.');
			$datanya[]=number_format($selisih,0,',','.');
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function form_setoran() {
		$kp=$this->session->userdata('kp');
		$id=$this->input->post('id');
		$tgl=date('Y-m-d');
		$data['tanggal']=$tgl;
		$data['aksi']='Simpan';
		//hitung pendapatan total penjualan
		$kunci=array('kode_pegawai'=>$kp,"DATE_FORMAT(tanggal,'%Y-%m-%d')"=>$tgl);
		$query=$this->model_crud->ambil_data($kunci,'tb_penjualan');
		$datajual=$query->result();
		$totjual=0;
		foreach ($datajual as $hasil) {
			$totjual=$totjual+$hasil->total;
		}
		$data['jual']=$totjual;
		$data['tunai']=$totjual;
		$kunci=array('id_setoran'=>$id);
		$query=$this->model_crud->ambil_data($kunci,'tb_setoran');
		$cek=$query->row();
		if ($cek) {
			$data['tanggal']=$cek->tanggal;
			$data['jual']=$cek->pendapatan_jual;
			$data['tunai']=$cek->bayar_tunai;
			$data['nontunai']=$cek->bayar_nontunai;
			$data['fisik']=$cek->uang_cash;
			$data['id']=$cek->id_setoran;
			$data['aksi']='Ubah';
		}
		$data['title']='Form Setoran';
		$this->load->view('transaksi/form_setoran',$data);
	}

	public function simpan_setoran() {
		$kp=$this->session->userdata('kp');
		$tanggal=$this->input->post('tanggal');
		$cash=$this->input->post('cash');
		$id=$this->input->post('id');
		$aksi=$this->input->post('aksi');
		//cek total penjualan terlebih dahulu
		$kunci=array('kode_pegawai'=>$kp,"DATE_FORMAT(tanggal,'%Y-%m-%d')"=>$tanggal);
		$query=$this->model_crud->ambil_data($kunci,'tb_penjualan');
		$datajual=$query->result();
		$totjual=0;
		$tottunai=0;
		$totnon=0;
		$totcash=0;
		$totbali=0;
		$totpoin=0;
		foreach ($datajual as $hasil) {
			$totjual=$totjual+$hasil->total;
			$totnon=$totnon+$hasil->non_tunai;
			$tottunai=$tottunai+$hasil->tunai;
			$totcash=$totcash+$hasil->cashout;
			$totbali=$totbali+$hasil->kembali;
			$totpoin=$totpoin+($hasil->poin*$hasil->nilaipoin);
		}
		if ($aksi=='Simpan') {
			//tambah data
			$kunci=array('kode_pegawai'=>$kp,'tanggal'=>$tanggal);
			$query=$this->model_crud->ambil_data($kunci,'tb_setoran');
			$cek=$query->num_rows();
			if ($cek) {
				$pesan='<div class="alert alert-danger alert-dismissible fade show" role="alert">
							Anda sudah menginput setoran kasir!
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Anda sudah menginput setoran kasir!';
				$ikon='error';
			} else {
				//baru tambahkan data
				$hitungdapat=$tottunai+$totnon-$totpoin-$totbali;
				$isi=array('pendapatan_jual'=>$totjual,'bayar_tunai'=>$tottunai,'bayar_nontunai'=>$totnon,'bayar_poin'=>$totpoin,'kembalian'=>$totbali,'hitungan_pendapatan'=>$hitungdapat,'cashout'=>$totcash,'uang_cash'=>$cash,'tanggal'=>$tanggal,'kode_pegawai'=>$kp);
				$this->model_crud->tambah_data('tb_setoran',$isi);
				$pesan='<div class="alert alert-success alert-dismissible fade show" role="alert">
							Setoran berhasil ditambahkan
							<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						</div>';
				$toas='Setoran berhasil ditambahkan';
				$ikon='success';
			}
			$arr=array('pesan'=>$pesan,'toas'=>$toas,'ikon'=>$ikon);
			echo json_encode($arr);
		}
	}

	public function total_returjual($tgl) {
		$kp=$this->session->userdata('kp');
		$selek='total_harga,tanggal';
		$kunci=array("DATE_FORMAT(tb_returpenjualan.tanggal,'%Y-%m-%d')"=>$tgl,'tb_returpenjualan.kode_pegawai'=>$kp);
		$query=$this->model_transaksi->databarangreturjual($selek,$kunci);
		$dataretur=$query->result();
		$total=0;
		foreach ($dataretur as $hasil) {
			$total=$total+$hasil->total_harga;
		}
		return $total;

	}

	public function total_jual() {
		$kp=$this->session->userdata('kp');
		$tanggal=$this->input->post('tanggal');
		$kunci=array('kode_pegawai'=>$kp,"DATE_FORMAT(tanggal,'%Y-%m-%d')"=>$tanggal);
		$query=$this->model_crud->ambil_data($kunci,'tb_penjualan');
		$datajual=$query->result();
		$totjual=0;
		foreach ($datajual as $hasil) {
			$totjual=$totjual+$hasil->total;
		}
		echo $totjual;
	}

	public function harga_beli() {
		$kp=$this->session->userdata('kp');
		$status=$this->input->post('status');
		$req=$_REQUEST;
		$kunci=array('tb_keranjang.kode_pegawai'=>$kp,'status'=>$status);
		$datatab=$this->model_transaksi->datakerjang($req,'data',$kunci,$status);
		$total=0;
		foreach ($datatab as $hasil) {
			$total=$total+$hasil->jum_harga;
		}
		echo $total;
	}

	public function databarang() {
		$req=$_REQUEST;
		$total=$this->model_transaksi->databarang($req,'jumlah');
		$datatab=$this->model_transaksi->databarang($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=$hasil->kode_barang;
			$datanya[]=$hasil->barcode;
			$datanya[]=$hasil->barang;
			$datanya[]=number_format($hasil->harga_jual1,0,',','.');
			$datanya[]=$hasil->stok;
			$datanya[]='<button type="button" title="Pilih" onclick="pilihbarang(this.value)" class="btn btn-primary btn-xs" value="'.$hasil->kode_barang.'"><i class="fa fa-pencil-alt"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function datanota() {
		$req=$_REQUEST;
		$total=$this->model_transaksi->datanota($req,'jumlah');
		$datatab=$this->model_transaksi->datanota($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=$hasil->faktur_jual;
			$datanya[]=date('d-m-Y',strtotime($hasil->tanggal));
			$datanya[]=$hasil->jum_barang;
			$datanya[]=number_format($hasil->total,0,',','.');
			$datanya[]='<button type="button" title="Pilih" onclick="pilihnota(this.value)" class="btn btn-primary btn-xs" value="'.$hasil->faktur_jual.'"><i class="fa fa-pencil-alt"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function datanotabeli() {
		$req=$_REQUEST;
		$total=$this->model_transaksi->datanotabeli($req,'jumlah');
		$datatab=$this->model_transaksi->datanotabeli($req,'data');
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$datanya[]=$hasil->no_nota;
			$datanya[]=date('d-m-Y',strtotime($hasil->tanggal));
			$datanya[]=$hasil->kode_permintaan;
			$datanya[]=$hasil->jum_barang;
			$datanya[]=number_format($hasil->total,0,',','.');
			$datanya[]='<button type="button" title="Pilih" onclick="pilihnota(this.value)" class="btn btn-primary btn-xs" value="'.$hasil->no_nota.'"><i class="fa fa-pencil-alt"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function dataminta() {
		$req=$_REQUEST;
		$kunci=array('tb_permintaan.status'=>'Diinput');
		$total=$this->model_transaksi->datapermintaan($req,'jumlah',$kunci);
		$datatab=$this->model_transaksi->datapermintaan($req,'data',$kunci);
		$isinya=array();
		foreach ($datatab as $hasil) {
			$datanya=array();
			$status='<span class="badge bg-warning">'.$hasil->status.'</span>';
			$datanya[]=$hasil->kode_permintaan;
			$datanya[]=$hasil->suplier;
			$datanya[]=$hasil->barang;
			$datanya[]=$status;
			$datanya[]='<button type="button" title="Pilih" onclick="pilihminta(this.value)" class="btn btn-primary btn-xs" value="'.$hasil->kode_permintaan.'"><i class="fa fa-pencil-alt"></i></button>';
			$isinya[]=$datanya;
		}
		$result=array('recordsTotal'=>$total,'recordsFiltered'=>$total,'data'=>$isinya);
		echo json_encode($result);
	}

	public function jbarang() {
		$id=$this->input->post('id');
		//ambil barang berdasarkan yang dicari
		$kunci=array('kode_barang'=>$id,'barcode'=>$id,'barcode'=>$id,'barcode2'=>$id,'barang'=>$id);
		$query=$this->model_transaksi->carimaster($kunci,'tb_barang');
		$databarang=$query->result();
		$arrbrg=array();
		if ($databarang) {
			foreach ($databarang as $hasil) {
				$arrbrg[]=$hasil->barcode.' - '.$hasil->barang;
			}
		}
		echo json_encode($arrbrg);
	}

	public function jsatuanbarang() {
		$id=$this->input->post('id');
		//cari kode barang
		$kunci=array('kode_barang'=>$id,'barcode'=>$id,'barcode2'=>$id,'barcode3'=>$id,'barang'=>$id);
		$query=$this->model_transaksi->carimaster($kunci,'tb_barang');
		$cek=$query->row();
		if ($cek) {
			$kode=$cek->kode_barang;
			if ($id==$cek->barcode2) {
				$sat2='selected';
			} else if ($id==$cek->barcode3) {
				$sat3='selected';
			}
		} else {
			$kode='';
		}
		//ambil barang berdasarkan yang dicari
		$kunci=array('kode_barang'=>$kode);
		$query=$this->model_crud->ambil_data($kunci,'tb_satuanbarang');
		$cek=$query->row();
		if ($cek) {
			if ($cek->satuan1) {
				echo '<option value="'.$cek->satuan1.'">'.$cek->satuan1.'</option>';
			}
			if ($cek->satuan2) {
				echo '<option value="'.$cek->satuan2.'" '.@$sat2.'>'.$cek->satuan2.'</option>';
			}
			if ($cek->satuan3) {
				echo '<option value="'.$cek->satuan3.'" '.@$sat3.'>'.$cek->satuan3.'</option>';
			}
		} else {
			echo '<option value=""></option>';
		}
	}
	
	public function jmember() {
		$id=$this->input->post('id');
		//ambil member berdasarkan yang dicari
		$kunci=array('kode_member'=>$id,'member'=>$id,'telepon'=>$id);
		$query=$this->model_transaksi->carimaster($kunci,'tb_member');
		$datamember=$query->result();
		$arrbrg=array();
		foreach ($datamember as $hasil) {
			$arrbrg[]=$hasil->kode_member.' - '.$hasil->member;
		}
		echo json_encode($arrbrg);
	}

	public function mbuh() {
		$string='[{"value":"11","label":"Abhilash "},{"value":"12","label":"Abhishek"}]';
		$array=json_decode($string);
		print_r($array);
	}

	public function cekkelipatan() {
		echo floor(7/2);
	}
}