<?php
 class Model_master extends CI_Model {
 	public function __construct() {
		
	}

	public function datakategori($req,$tipe) {
		$kolom=array('id_kategori','kategori');
		$this->db->from('tb_kategori');
		$this->db->where('aktif',1);
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('kategori'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function databarang($req,$tipe) {
		$kolom=array('tb_barang.kode_barang','barcode','barang','harga_beli','harga_jual1','(harga_jual-harga_beli)','kategori','stok');
		$this->db->select('tb_barang.kode_barang,barcode,barang,harga_beli,harga_jual1,stok,kategori');
		$this->db->from('tb_barang');
		$this->db->join('tb_kategori','tb_kategori.id_kategori=tb_barang.id_kategori');
		$this->db->join('tb_satuanbarang','tb_satuanbarang.kode_barang=tb_barang.kode_barang','LEFT');
		$this->db->where('tb_barang.aktif',1);
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tb_barang.kode_barang'=>$cari,'barang'=>$cari,'barcode'=>$cari,'kategori'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function dataeditbarang($req,$tipe) {
		$kolom=array('tb_barang.kode_barang','barcode','barang','kategori','satuan1','harga_beli','harga_jual1','harga_jual2','harga_jual3','stok_minimal','stok_maksimal');
		$this->db->select('tb_barang.kode_barang,barcode,barang,harga_beli,harga_jual1,harga_jual2,harga_jual3,satuan1,stok_minimal,stok_maksimal,tb_barang.id_kategori,stok,kategori');
		$this->db->from('tb_barang');
		$this->db->join('tb_kategori','tb_kategori.id_kategori=tb_barang.id_kategori');
		$this->db->join('tb_satuanbarang','tb_satuanbarang.kode_barang=tb_barang.kode_barang','LEFT');
		$this->db->where('tb_barang.aktif',1);
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tb_barang.kode_barang'=>$cari,'barang'=>$cari,'barcode'=>$cari,'kategori'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function datasuplier($req,$tipe) {
		$kolom=array('kode_suplier','suplier','telepon','alamat');
		$this->db->from('tb_suplier');
		$this->db->where('aktif',1);
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('kode_suplier'=>$cari,'suplier'=>$cari,'telepon'=>$cari,'alamat'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function databarangsuplier($kunci) {
		$this->db->from('tb_supliermeta');
		$this->db->join('tb_suplier','tb_suplier.kode_suplier=tb_supliermeta.kode_suplier');
		$this->db->join('tb_barang','tb_barang.kode_barang=tb_supliermeta.kode_barang');
		if ($kunci) {
			$this->db->where($kunci);
		}
		$query=$this->db->get();
		return $query;
	}
	
	public function datarak($req,$tipe) {
		$kolom=array('rak');
		$this->db->from('tb_rak');
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('rak'=>$cari,'id_rak'=>$cari);
			$this->db->or_like($kunci);
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function databarangrak($kunci) {
		$this->db->from('tb_rakmeta');
		$this->db->join('tb_rak','tb_rak.id_rak=tb_rakmeta.id_rak');
		$this->db->join('tb_barang','tb_barang.kode_barang=tb_rakmeta.kode_barang');
		if ($kunci) {
			$this->db->where($kunci);
		}
		$this->db->order_by('id_rakmeta','DESC');
		$query=$this->db->get();
		return $query;
	}

	public function datamember($req,$tipe) {
		$kolom=array('tanggal','kode_member','member','jekel','telepon','poin','koin');
		$this->db->from('tb_member');
		$this->db->where('aktif',1);
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tanggal'=>$cari,'kode_member'=>$cari,'member'=>$cari,'telepon'=>$cari,'alamat'=>$cari,'email'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function datanontunai($req,$tipe) {
		$kolom=array('nontunai');
		$this->db->from('tb_nontunai');
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('nontunai'=>$cari);
			$this->db->or_like($kunci);
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function datapegawai($req,$tipe) {
		$kolom=array('kode_pegawai','pegawai','jekel','telepon','level');
		$this->db->from('tb_pegawai');
		$this->db->where('aktif',1);
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('kode_pegawai'=>$cari,'pegawai'=>$cari,'telepon'=>$cari,'email'=>$cari,'level'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function datalabel($req,$tipe) {
		$kolom=array('tb_label.tanggal,COUNT(tb_labelmeta.kode_barang)','pegawai');
		$this->db->select('tb_label.id_label,COUNT(tb_labelmeta.kode_barang) AS jumlah_barang,tanggal,pegawai');
		$this->db->from('tb_label');
		$this->db->join('tb_labelmeta','tb_labelmeta.id_label=tb_label.id_label');
		$this->db->join('tb_pegawai','tb_pegawai.kode_pegawai=tb_label.kode_pegawai');
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tanggal'=>$cari,'tb_labelmeta.kode_barang'=>$cari,'barang'=>$cari,'pegawai'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		$this->db->group_by('tb_label.id_label');
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function datalabeldetail($req,$tipe,$id) {
		$tgl=date('Y-m-d');
		$kolom=array('tb_labelmeta.id_labelmeta','barang','tb_labelmeta.harga_jual','tb_labelmeta.harga_diskon,tb_labelmeta.jumlah_cetak');
		$this->db->select('tb_labelmeta.kode_barang,barang,tanggal,tb_labelmeta.id_labelmeta,tb_labelmeta.harga_jual,tb_labelmeta.harga_diskon,jumlah_cetak');
		$this->db->from('tb_label');
		$this->db->join('tb_labelmeta','tb_labelmeta.id_label=tb_label.id_label');
		$this->db->join('tb_barang','tb_barang.kode_barang=tb_labelmeta.kode_barang');
		$this->db->join('tb_pegawai','tb_pegawai.kode_pegawai=tb_label.kode_pegawai');
		if ($id) {
			$this->db->where('tb_label.id_label',$id);
		} else {
			$this->db->where('tb_label.tanggal',$tgl);
		}
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tanggal'=>$cari,'tb_labelmeta.kode_barang'=>$cari,'barang'=>$cari,'tb_labelmeta.harga_jual'=>$cari,'tb_labelmeta.harga_diskon'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function labelbarang($selek,$kunci) {
		if ($selek) {
			$this->db->select($selek);
		}
		$this->db->from('tb_label');
		$this->db->join('tb_labelmeta','tb_labelmeta.id_label=tb_label.id_label');
		$this->db->join('tb_barang','tb_barang.kode_barang=tb_labelmeta.kode_barang');
		if ($kunci) {
			$this->db->where($kunci);
		}
		$query=$this->db->get();
		return $query;
	}
}