<?php
 class Model_transaksi extends CI_Model {
 	public function __construct() {
		
	}

	public function databarang($req,$tipe) {
		$kolom=array('kode_barang','barcode','barang','harga_jual1','stok');
		$this->db->select('tb_barang.kode_barang,barcode,barang,harga_jual1,stok');
		$this->db->from('tb_barang');
		$this->db->join('tb_satuanbarang','tb_satuanbarang.kode_barang=tb_barang.kode_barang');
		$this->db->join('tb_kategori','tb_kategori.id_kategori=tb_barang.id_kategori');
		$this->db->where('tb_barang.aktif',1);
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tb_barang.kode_barang'=>$cari,'barang'=>$cari,'barcode'=>$cari,'kategori'=>$cari,'tb_satuanbarang.harga_jual1'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function caripotongan($kunci=array(),$tanggal) {
		$this->db->select('potongan,jumlah_beli');
		$this->db->from('tb_potongan');
		if ($kunci) {
			$this->db->where($kunci);
		}
		$this->db->group_start();
		$this->db->where('mulai<=',$tanggal);
		$this->db->where('selesai>=',$tanggal);
		$this->db->group_end();
		$query=$this->db->get();
		return $query;
	}

	public function caribonus($kunci=array(),$tanggal) {
		$this->db->select('bonus,jumlah_beli');
		$this->db->from('tb_bonus');
		if ($kunci) {
			$this->db->where($kunci);
		}
		$this->db->group_start();
		$this->db->where('mulai<=',$tanggal);
		$this->db->where('selesai>=',$tanggal);
		$this->db->group_end();
		$query=$this->db->get();
		return $query;
	}

	public function carimaster($kunci,$table) {
		$this->db->from($table);
		$this->db->where('aktif',1);
		if ($kunci) {
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		$query=$this->db->get();
		return $query;
	}

	public function datapermintaan($req,$tipe,$kunci=array()) {
		$kolom=array('tb_permintaan.tanggal','suplier','tb_permintaan.kode_permintaan','COUNT(kode_barang)','keterangan','status');
		$this->db->select('tb_permintaan.tanggal,tb_permintaan.kode_permintaan,COUNT(kode_barang) AS barang,keterangan,status,suplier');
		$this->db->from('tb_permintaan');
		$this->db->join('tb_permintaanmeta','tb_permintaanmeta.kode_permintaan=tb_permintaan.kode_permintaan');
		$this->db->join('tb_suplier','tb_suplier.kode_suplier=tb_permintaan.kode_suplier');
		if ($kunci) {
			$this->db->where($kunci);
		}
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tb_permintaan.tanggal'=>$cari,'tb_permintaan.kode_permintaan'=>$cari,'keterangan'=>$cari,'suplier'=>$cari,'status'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		$this->db->group_by('tb_permintaan.kode_permintaan');
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function databarangpermintaan($selek,$kunci) {
		if ($selek) {
			$this->db->select($selek);
		}
		$this->db->from('tb_permintaan');
		$this->db->join('tb_permintaanmeta','tb_permintaanmeta.kode_permintaan=tb_permintaan.kode_permintaan');
		//$this->db->join('tb_pegawai','tb_pegawai.kode_pegawai=tb_permintaan.kode_pegawai');
		$this->db->join('tb_barang','tb_barang.kode_barang=tb_permintaanmeta.kode_barang');
		if ($kunci) {
			$this->db->where($kunci);
		}
		$query=$this->db->get();
		return $query;
	}

	public function datamutasi($req,$tipe) {
		$kolom=array('tb_mutasi.tanggal','toko','tb_mutasi.kode_mutasi','COUNT(kode_barang)');
		$this->db->select('tb_mutasi.tanggal,tb_mutasi.kode_mutasi,COUNT(kode_barang) AS barang,toko');
		$this->db->from('tb_mutasi');
		$this->db->join('tb_mutasimeta','tb_mutasimeta.kode_mutasi=tb_mutasi.kode_mutasi');
		$this->db->join('tb_toko','tb_toko.kode_toko=tb_mutasi.kode_toko');
		$this->db->group_by('tb_mutasi.kode_mutasi');
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tb_mutasi.tanggal'=>$cari,'tb_mutasi.kode_mutasi'=>$cari,'toko'=>$cari,'tb_mutasi.kode_toko'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function databarangmutasi($selek,$kunci) {
		if ($selek) {
			$this->db->select($selek);
		}
		$this->db->from('tb_mutasi');
		$this->db->join('tb_mutasimeta','tb_mutasimeta.kode_mutasi=tb_mutasi.kode_mutasi');
		//$this->db->join('tb_pegawai','tb_pegawai.kode_pegawai=tb_mutasi.kode_pegawai');
		$this->db->join('tb_barang','tb_barang.kode_barang=tb_mutasimeta.kode_barang');
		if ($kunci) {
			$this->db->where($kunci);
		}
		$query=$this->db->get();
		return $query;
	}

	public function datasetoran($req,$tipe) {
		$kp=$this->session->userdata('kp');
		$kolom=array('tanggal','pendapatan_jual','(bayar_tunai-kembalian)','bayar_nontunai','uang_cash','cashout','(uang_cash-(bayar_tunai-kembalian)-cashout)');
		$this->db->select('id_setoran,tanggal,pendapatan_jual,(bayar_tunai-kembalian) AS bayar_tunai,bayar_nontunai,uang_cash,kembalian,cashout,(uang_cash-(bayar_tunai-kembalian)-cashout) AS selisih');
		$this->db->from('tb_setoran');
		$this->db->where('kode_pegawai',$kp);
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tanggal'=>$cari,'pendapatan_jual'=>$cari,'bayar_tunai'=>$cari,'uang_cash'=>$cari,'cashout'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}
	
	public function datareturbeli($req,$tipe) {
		$kolom=array('tb_returpembelian.tanggal','suplier','COUNT(tb_returpembelianmeta.kode_barang)','SUM(total_harga)');
		$this->db->select('tb_returpembelian.id_returpembelian,tb_returpembelian.tanggal,COUNT(tb_returpembelianmeta.kode_barang) AS jumbarang,SUM(total_harga) AS total,suplier');
		$this->db->from('tb_returpembelian');
		$this->db->join('tb_returpembelianmeta','tb_returpembelianmeta.id_returpembelian=tb_returpembelian.id_returpembelian');
		$this->db->join('tb_suplier','tb_suplier.kode_suplier=tb_returpembelian.kode_suplier');
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tb_returpembelian.tanggal'=>$cari,'suplier'=>$cari);
			$this->db->or_like($kunci);
		}
		$this->db->group_by('tb_returpembelian.id_returpembelian');
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function databarangreturpembelian($selek,$kunci) {
		if ($selek) {
			$this->db->select($selek);
		}
		$this->db->from('tb_returpembelian');
		$this->db->join('tb_returpembelianmeta','tb_returpembelianmeta.id_returpembelian=tb_returpembelian.id_returpembelian');
		//$this->db->join('tb_pegawai','tb_pegawai.kode_pegawai=tb_returpembelian.kode_pegawai');
		$this->db->join('tb_barang','tb_barang.kode_barang=tb_returpembelianmeta.kode_barang');
		if ($kunci) {
			$this->db->where($kunci);
		}
		$query=$this->db->get();
		return $query;
	}

	public function databarangreturjual($selek,$kunci) {
		if ($selek) {
			$this->db->select($selek);
		}
		$this->db->from('tb_returpenjualan');
		$this->db->join('tb_returpenjualanmeta','tb_returpenjualanmeta.id_returpenjualan=tb_returpenjualan.id_returpenjualan');
		$this->db->join('tb_pegawai','tb_pegawai.kode_pegawai=tb_returpenjualan.kode_pegawai');
		$this->db->join('tb_barang','tb_barang.kode_barang=tb_returpenjualanmeta.kode_barang');
		if ($kunci) {
			$this->db->where($kunci);
		}
		$query=$this->db->get();
		return $query;
	}

	public function datakerjang($kunci) {
		$kolom=array('tb_keranjang.kode_barang','barcode','barang','jumlah+bonus','jum_harga','');
		$this->db->select('tb_barang.kode_barang,barcode,tb_barang.barang,token,tb_keranjang.jumlah,tb_keranjang.bonus,tb_keranjang.satuan_jual,tb_keranjang.satuan_konversi,tb_keranjang.potongan,tb_keranjang.jum_harga,tb_keranjang.kode_pegawai,pegawai');
		$this->db->from('tb_keranjang');
		$this->db->join('tb_barang','tb_keranjang.kode_barang=tb_barang.kode_barang');
		$this->db->join('tb_pegawai','tb_pegawai.kode_pegawai=tb_keranjang.kode_pegawai');
		$this->db->where($kunci);
		$this->db->order_by('token','DESC');
		$query=$this->db->get();
		return $query->result();
	}

	public function datakeranjang($kunci) {
		$this->db->select('tb_barang.kode_barang,barcode,tb_barang.barang,tb_barang.harga_beli AS beli,token,tb_keranjang.jumlah,tb_keranjang.potongan,tb_keranjang.jum_harga');
		$this->db->from('tb_keranjang');
		$this->db->join('tb_barang','tb_keranjang.kode_barang=tb_barang.kode_barang');
		$this->db->group_by('tb_keranjang.kode_barang');
		$this->db->order_by('tb_keranjang.token','DESC');
		$this->db->where($kunci);
		$query=$this->db->get();
		return $query->result();
	}

	public function databayarpiutang($req,$tipe) {
		$kolom=array('tb_piutang.tanggal','tb_piutang.faktur_jual','tb_penjualan.kode_member','member','tb_piutang.piutang','tb_piutang.sisa','(tb_piutang.piutang-tb_piutang.sisa)');
		$this->db->select('tb_piutang.id_piutang,tb_piutang.tanggal,tb_piutang.faktur_jual,tb_penjualan.kode_member,member,tb_piutang.piutang,tb_piutang.sisa');
		$this->db->from('tb_piutang');
        $this->db->join('tb_penjualan','tb_penjualan.faktur_jual=tb_piutang.faktur_jual');
        $this->db->join('tb_member','tb_member.kode_member=tb_penjualan.kode_member','LEFT');
        $this->db->where('tb_piutang.sisa<>',0);
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tb_piutang.tanggal'=>$cari,'tb_piutang.faktur_jual'=>$cari,'tb_penjualan.kode_member'=>$cari,'member'=>$cari,'piutang'=>$cari,'sisa'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function databayarhutang($req,$tipe) {
		$kolom=array('tb_hutang.tanggal','tb_hutang.kode_masuk','tb_masuk.no_nota','suplier','tb_hutang.hutang','tb_hutang.sisa','(tb_hutang.hutang-tb_hutang.sisa)','tempo');
		$this->db->select('tb_hutang.id_hutang,tb_hutang.tanggal,tb_hutang.kode_masuk,tb_hutang.hutang,tb_hutang.sisa,tb_hutang.tempo,suplier,tb_masuk.no_nota,');
		$this->db->from('tb_hutang');
        $this->db->join('tb_masuk','tb_masuk.kode_masuk=tb_hutang.kode_masuk');
        $this->db->join('tb_permintaan','tb_permintaan.kode_permintaan=tb_masuk.kode_permintaan');
        $this->db->join('tb_suplier','tb_suplier.kode_suplier=tb_permintaan.kode_suplier');
        $this->db->where('tb_hutang.sisa<>',0);
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tb_hutang.tanggal'=>$cari,'tb_hutang.kode_masuk'=>$cari,'tb_permintaan.kode_suplier'=>$cari,'suplier'=>$cari,'hutang'=>$cari,'sisa'=>$cari,'tempo'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function datanota($req,$tipe) {
		$kolom=array('tb_penjualan.faktur_jual','tanggal','COUNT(tb_penjualanmeta.kode_barang)','total');
		$this->db->select('tb_penjualan.faktur_jual,tanggal,COUNT(tb_penjualanmeta.kode_barang) AS jum_barang,total');
		$this->db->from('tb_penjualan');
		$this->db->join('tb_penjualanmeta','tb_penjualanmeta.faktur_jual=tb_penjualan.faktur_jual');
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tb_penjualan.faktur_jual'=>$cari,'tanggal'=>$cari,'total'=>$cari);
			$this->db->group_start();
			$this->db->or_like($kunci);
			$this->db->group_end();
		}
		$this->db->group_by('tb_penjualan.faktur_jual');
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}

	public function datanotabeli($req,$tipe) {
		$kolom=array('tb_masuk.no_nota','tb_masuk.tanggal','tb_masuk.kode_permintaan','COUNT(tb_permintaanmeta.kode_barang)','tb_masuk.total');
		$this->db->select('tb_masuk.no_nota,tb_masuk.kode_masuk,,tb_masuk.kode_permintaan,tb_masuk.tanggal,COUNT(tb_permintaanmeta.kode_barang) AS jum_barang,total');
		$this->db->from('tb_permintaan');
		$this->db->join('tb_permintaanmeta','tb_permintaanmeta.kode_permintaan=tb_permintaan.kode_permintaan');
		$this->db->join('tb_masuk','tb_masuk.kode_permintaan=tb_permintaan.kode_permintaan');
		//pencarian data
		if (@$req['search']['value']) {
			$cari=$req['search']['value'];
			$kunci=array('tb_permintaan.kode_permintaan'=>$cari,'tb_masuk.kode_permintaan'=>$cari,'tb_masuk.tanggal'=>$cari,'tb_masuk.total'=>$cari);
			$this->db->or_like($kunci);
		}
		$this->db->group_by('tb_masuk.no_nota');
		if ($tipe=='jumlah') {
			$query=$this->db->get();
			return $query->num_rows();
		} else {
			//urutan data
			$this->db->order_by($kolom[$req['order'][0]['column']],$req['order'][0]['dir']);
			$this->db->limit($req['length'],$req['start']);
			$query=$this->db->get();
			return $query->result();
		}
	}
}