<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Rekap Penjualan</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item">Laporan</li>
                        <li class="breadcrumb-item active"><a href="#">Rekap Penjualan</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Tanggal Awal</label>
                                        <input type="date" class="form-control" id="awal" name="awal" value="<?php echo @$awal ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Tanggal Akhir</label>
                                        <input type="date" class="form-control" id="akhir" name="akhir" value="<?php echo @$akhir ?>">
                                    </div>
                                </div>
                                <?php
                                if (@$level=='Administrator') {
                                    ?>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Nama Kasir/Pegawai</label>
                                        <select class="form-control" id="pegawai" name="pegawai">
                                            <option value="">-- pilih pegawai --</option>
                                            <?php
                                            foreach ($datapegawai as $hasil) {
                                                ?>
                                                <option value="<?php echo $hasil->kode_pegawai ?>"><?php echo $hasil->pegawai ?></option>
                                                <?php
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                    <?php
                                }
                                ?>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label style="color: white;">&nbsp;</label>
                                        <button type="button" class="btn btn-primary" style="width: 100%;" onclick="tampilkan()"><i class="fa fa-search"></i> Tampilkan</button>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label style="color: white;">&nbsp;</label>
                                        <button type="button" class="btn btn-success" style="width: 100%;" onclick="konfircetak()"><i class="fa fa-print"></i> Cetak</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="konten"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End #main -->
<!-- modal konfirmasi -->
<div class="modal fade" id="modalkonfir">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Cetak Rekapan penjualan</h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <h5>Silahkan pilih format cetak rekapan penjualan.</h5>
            </div>
            <div class="modal-footer">
                <button type="button" value="" class="btn bg-gradient-success" onclick="cetak()"><i class="fa fa-list"></i> Format Biasa</button>
                <button type="button" value="" class="btn bg-gradient-warning" onclick="cetakdetail()"><i class="fa fa-file"></i> Format Detail</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-times"></i> Batal</button>
            </div>
        </div>
    </div>
</div>
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    tampilkan();
});

function tampilkan() {
    var awal=$("#awal").val();
    var akhir=$("#akhir").val();
    var pegawai=$("#pegawai").val();
    $.ajax({
        url:"<?php echo base_url('laporan/ajax_rekapjual') ?>",
        cache:false,
        type:"POST",
        data:{awal:awal,akhir:akhir,pegawai:pegawai},
        beforeSend: function(){
            $("#konten").html('<center><img src="<?php echo base_url('assets/images/loading.gif') ?>"></center>');
        },
        success:function(result){
            $("#konten").html(result);
        }
    });
}

function konfircetak() {
    $("#modalkonfir").modal("show");
}

function cetak() {
    var awal=$("#awal").val();
    var akhir=$("#akhir").val();
    var pegawai=$("#pegawai").val();
    window.open("<?php echo base_url('laporan/xls_rekapjual?') ?>awal="+awal+"&akhir="+akhir+"&pegawai="+pegawai);
}

function cetakdetail() {
    var awal=$("#awal").val();
    var akhir=$("#akhir").val();
    var pegawai=$("#pegawai").val();
    window.open("<?php echo base_url('laporan/xls_rekapjualdetail?') ?>awal="+awal+"&akhir="+akhir+"&pegawai="+pegawai);
}
</script>
<?php @$this->load->view($footerend) ?>
<!-- Page specific script -->