<?php
// Load library phpspreadsheet
require('./vendor/autoload.php');
use PhpOffice\PhpSpreadsheet\Helper\Sample;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
// End load library phpspreadsheet
// Create new Spreadsheet object
$spreadsheet = new Spreadsheet();
// Set document properties
$spreadsheet->getProperties()->setCreator('Aditya Yudhit Irfianto - UNU Purwokerto')
			->setLastModifiedBy('Aditya Yudhit - UNU Purwokerto')
			->setTitle('Office 2007 XLSX Test Document')
			->setSubject('Office 2007 XLSX Test Document')
			->setDescription('Test document for Office 2007 XLSX, generated using PHP classes.')
			->setKeywords('office 2007 openxml php')
			->setCategory('Test result file');
// set size column
$spreadsheet->getActiveSheet(0)->getColumnDimension('A')
			->setAutoSize(true);
$spreadsheet->getActiveSheet(0)->getColumnDimension('B')
			->setAutoSize(true);
$spreadsheet->getActiveSheet(0)->getColumnDimension('C')
			->setAutoSize(true);
$spreadsheet->getActiveSheet(0)->getColumnDimension('D')
			->setAutoSize(true);
$spreadsheet->getActiveSheet(0)->getColumnDimension('E')
			->setAutoSize(true);
$spreadsheet->getActiveSheet(0)->getColumnDimension('F')
			->setAutoSize(true);
$spreadsheet->getActiveSheet(0)->getColumnDimension('G')
			->setAutoSize(true);
$spreadsheet->getActiveSheet(0)->getColumnDimension('H')
			->setAutoSize(true);
$spreadsheet->getActiveSheet(0)->getColumnDimension('I')
			->setAutoSize(true);
$spreadsheet->getActiveSheet(0)->getColumnDimension('J')
			->setAutoSize(true);
$spreadsheet->getActiveSheet(0)->getColumnDimension('K')
			->setAutoSize(true);
$spreadsheet->getActiveSheet(0)->getColumnDimension('L')
			->setAutoSize(true);
// Add some data
$spreadsheet->setActiveSheetIndex(0)
            ->setCellValue('A1','Laporan Penjualan')
            ->setCellValue('A2','Periode Tanggal '.@$awal.' Sampai '.@$akhir);
$spreadsheet->setActiveSheetIndex(0)->mergeCells('A1:L1');
$spreadsheet->setActiveSheetIndex(0)->mergeCells('A2:L2');
//pemberian nama kolom
$spreadsheet->setActiveSheetIndex(0)
            ->setCellValue('A4','No.')
            ->setCellValue('B4','Tanggal')
            ->setCellValue('C4','No. Faktur')
            ->setCellValue('D4','Kode Barang')
			->setCellValue('E4','Nama Barang')
			->setCellValue('F4','Harga Satuan')
			->setCellValue('G4','Satuan')
            ->setCellValue('H4','Jumlah')
            ->setCellValue('I4','Jumlah Bonus')
            ->setCellValue('J4','Potongan Harga')
            ->setCellValue('K4','Total Harga Jual')
            ->setCellValue('L4','Operator');
$spreadsheet->getActiveSheet(0)->getStyle('A4:L4')->getAlignment()->setHorizontal('center');
//tampilkan data di excel
$no=1;
$i=5;
foreach ($datajual as $hasil) {
	if ($hasil->jumlah_jual) {
		$bagi=$hasil->jumlah_jual;
	} else {
		$bagi=1;
	}
    $hargasatuan=($hasil->total_harga+$hasil->potongan)/$bagi;
	$spreadsheet->setActiveSheetIndex(0)
				->setCellValue('A'.$i, $no.'.')
				->setCellValue('B'.$i, date('d-m-Y',strtotime($hasil->tanggal)))
				->setCellValue('C'.$i, $hasil->faktur_jual)
				->setCellValue('D'.$i, $hasil->kode_barang)
                ->setCellValue('E'.$i, $hasil->barang)
				->setCellValue('F'.$i, $hargasatuan)
				->setCellValue('G'.$i, $hasil->satuan_jual)
				->setCellValue('H'.$i, $hasil->jumlah_jual)
                ->setCellValue('I'.$i, $hasil->bonus)
                ->setCellValue('J'.$i, $hasil->potongan)
                ->setCellValue('K'.$i, $hasil->total_harga)
                ->setCellValue('L'.$i, $hasil->pegawai);
	$no++;
	$i++;
}
//untuk border
$x=$i-1;
$border=array();
$border['borders']=array();
$border['borders']['outline']['borderStyle']=\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN;
$border['borders']['allBorders']['borderStyle']=\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN;
$spreadsheet->setActiveSheetIndex(0)->getStyle('A4:L'.$x)->applyFromArray($border);
// Rename worksheet
$spreadsheet->getActiveSheet()->setTitle('Sheet1');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$spreadsheet->setActiveSheetIndex(0);

// Redirect output to a client’s web browser (Xlsx)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="Laporan Penjualan - '.@$awal.'_'.$akhir.'.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header('Pragma: public'); // HTTP/1.0

$writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
$writer->save('php://output');
exit;
?>