<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Cetak Label Barang</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item active"><a href="#">Label Barang</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <div class="card-header">
                            <form method="post" id="formdata">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label>Kode Barang</label>
                                            <div class="input-group mb-3">
                                                <button type="button" class="input-group-text btn btn-secondary" title="Cari barang" onclick="tampilbarang()"><i class="fa fa-search"></i></button>
                                                <input type="text" class="form-control" id="kode" name="kode" autocomplete="0" autofocus>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label class="form-label">Harga Jual</label>
                                            <select class="form-control" id="harga" name="harga">
                                                <option value="h1">Harga Jual 1</option>
                                                <option value="h2">Harga Jual 2</option>
                                                <option value="h3">Harga Jual 3</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label class="form-label">Jumlah Label</label>
                                            <input type="number" class="form-control" id="jumlah" name="jumlah">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label class="form-label" style="color: white;">&nbsp;</label>
                                            <button type="submit" class="btn btn-success" style="width: 100%;" value=""><i class="fa fa-plus"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered datatable dt-responsive" id="tabelkeranjang" style="width: 100%;">
                            <thead>
                            <tr>
                                <th>Kode Barang</th>
                                <th>Nama Barang</th>
                                <th>Harga</th>
                                <th>Harga Diskon</th>
                                <th>Jumlah Cetak</th>
                                <th width="2%"></th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                            </table>
                        </div>
                        <div class="card-footer">
                            <button type="button" class="btn btn-secondary" onclick="cetak()"><i class="fa fa-print"></i> Cetak Label</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- modal utama -->
<div class="modal fade" id="modalbarang">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Transaksi Penjualan</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <table class="table table-hover datatable" style="width: 100%" id="tabelku">
                <thead>
                <tr>
                    <th>Kode Barang</th>
                    <th>Barcode</th>
                    <th>Nama Barang</th>
                    <th>Harga</th>
                    <th>Stok</th>
                    <th width="2%"></th>
                </tr>
                </thead>
                <tbody></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" onclick="represh()"><i class="fa fa-refresh"></i> Refresh</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="fa fa-times"></i> Tutup</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal hapus -->
<div class="modal fade" id="modalhapus">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-body">
                <h4>Apakah akan menghapus cetak label barang ini?</h4>
            </div>
            <div class="modal-footer right-content-between">
                <button type="button" id="hapus" value="" onclick="hapusdata(this.value)" class="btn bg-gradient-danger"><i class="fa fa-trash"></i> Hapus</button>
                <button type="button" class="btn bg-gradient-primary" data-dismiss="modal"><i class="fa fa-times"></i> Batal</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal hapus -->
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    $("#tabelku").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "ajax":{
                url:"<?php echo base_url('transaksi/databarang') ?>",
                type:"post",
        },
    });
});

$(document).ready(function() {
    $("#tabelkeranjang").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "order": [[0, 'desc']],
        "ajax":{
                url:"<?php echo base_url('master/datalabeldetail?id='.@$id) ?>",
                type:"post",
        },
    });
});

$(function(){
    $("#formdata").submit(function(event){
        var jumlah=$("#jumlah").val();
        event.preventDefault();
        if (jumlah==0 || jumlah=='') {
            $("#jumlah").focus();
        } else {
            $.ajax({
                url:"<?php echo base_url('master/simpan_label?id='.@$id) ?>",
                cache: false,
                type:"POST",
                data:$(this).serialize(),
                dataType:"JSON",
                success:function(result) {
                    $("#peringatan").html(result.pesan);
                    if (result.ikon=='success') {
                        toastr.success(result.toas);
                    } else if (result.ikon=='warning') {
                        toastr.warning(result.toas);
                    } else if (result.ikon=='error') {
                        toastr.error(result.toas);
                    }
                    $("#tabelku").DataTable().draw();
                    $("#tabelkeranjang").DataTable().draw();
                    $("#formdata").trigger("reset");
                    $("#kode").focus();
                }
            })
        }
    });
});

function tampilbarang() {
    $("#modalbarang").modal("show");
}

function represh() {
    $("#tabelku").DataTable().draw();
    $("#tabelkeranjang").DataTable().draw();
}

function pilihbarang(i) {
    $("#kode").val(i);
    $("#modalbarang").modal("hide");
    $("#jumlah").focus();
}

function konfirhapus(i) {
    $("#hapus").val(i);
    $("#modalhapus").modal("show");
}

function hapusdata(str) {
    $.ajax({
        url:"<?php echo base_url('master/hapus_labelbarang') ?>",
        cache:false,
        type:"POST",
        data:{id:str},
        dataType:"JSON",
        success:function(result){
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            $("#modalhapus").modal("hide");
            $("#tabelku").DataTable().draw();
            $("#tabelkeranjang").DataTable().draw();
            $("#kode").focus();
        }
    });
}

function cetak() {
    window.open("<?php echo base_url('master/cetak_label?id='.@$id) ?>");
}
</script>
<?php @$this->load->view($footerend) ?>
<!-- Page specific script -->