<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Barang Rak</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item active"><a href="#">Barang Rak</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <div class="card-header">
                            <table class="table table-hover">
                            <tr>
                                <th width="15%">Nama Rak</th>
                                <th width="2%">:</th>
                                <th><?php echo @$rak ?></th>
                            </tr>
                            </table>
                            <form method="post" id="formdata">
                                <div class="row">
                                    <div class="col-md-10">
                                        <div class="form-group">
                                            <label>Kode Barang</label>
                                            <div class="input-group mb-3">
                                                <button type="button" class="input-group-text btn btn-secondary" title="Cari barang" onclick="tampilbarang()"><i class="fa fa-search"></i></button>
                                                <input type="text" class="form-control" id="kode" name="kode" autocomplete="0" autofocus>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label style="color: white;">&nbsp;</label>
                                            <input type="hidden" name="rak" id="rak" value="<?php echo @$id ?>">
                                            <button type="submit" class="btn btn-success" style="width: 100%;"><i class="fa fa-plus"></i> Tambah</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="card-body">
                            <div id="konten"></div>
                        </div>
                        <div class="card-footer">
                            <a href="<?php echo base_url('master/rak') ?>" class="btn btn-danger"><i class="fa fa-times"></i> Kembali</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- modal utama -->
<div class="modal fade" id="modalbarang">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Transaksi Penjualan</h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <table class="table table-hover datatable" style="width: 100%" id="tabelbarang">
                <thead>
                <tr>
                    <th>Kode Barang</th>
                    <th>Barcode</th>
                    <th>Nama Barang</th>
                    <th>Harga</th>
                    <th>Stok</th>
                    <th width="2%"></th>
                </tr>
                </thead>
                <tbody></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" onclick="represh()"><i class="fa fa-refresh"></i> Refresh</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="fa fa-times"></i> Tutup</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal hapus -->
<div class="modal fade" id="modalhapus">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-body">
                <h4>Apakah akan menghapus barang dari rak ini?</h4>
            </div>
            <div class="modal-footer right-content-between">
                <button type="button" id="hapus" value="" onclick="hapusdata(this.value)" class="btn bg-gradient-danger"><i class="fa fa-trash"></i> Hapus</button>
                <button type="button" class="btn bg-gradient-primary" data-dismiss="modal"><i class="fa fa-times"></i> Batal</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- End #main -->
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    tampilkan();
    $("#kode").focus();
    $("#tabelbarang").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "ajax":{
                url:"<?php echo base_url('transaksi/databarang') ?>",
                type:"post",
        },
    });
});

$(function(){
    $("#formdata").submit(function(event){
        event.preventDefault();
        $.ajax({
            url:"<?php echo base_url('master/simpan_barangrak') ?>",
            cache: false,
            type:"POST",
            data:$(this).serialize(),
            dataType:"JSON",
            success:function(result) {
                $("#peringatan").html(result.pesan);
                if (result.ikon=='success') {
                    toastr.success(result.toas);
                } else if (result.ikon=='warning') {
                    toastr.warning(result.toas);
                } else if (result.ikon=='error') {
                    toastr.error(result.toas);
                }
                tampilkan();
                $("#kode").val("");
                $("#kode").focus();
            }
        })
    });
});

function tampilbarang() {
    $("#modalbarang").modal("show");
}

function represh() {
    $("#tabelku").DataTable().draw();
}

function pilihbarang(i) {
    $("#kode").val(i);
    $("#modalbarang").modal("hide");
    $("#kode").focus();
}

function konfirhapus(i) {
    $("#hapus").val(i);
    $("#modalhapus").modal("show");
}

function konfirsimpan() {
    $("#modalkonfir").modal("show");
}

function hapusdata(str) {
    $.ajax({
        url:"<?php echo base_url('master/hapus_barangrak') ?>",
        cache:false,
        type:"POST",
        data:{id:str},
        dataType:"JSON",
        success:function(result){
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            $("#modalhapus").modal("hide");
            tampilkan();
            $("#kode").focus();
        }
    });
}

function tampilkan() {
    $.ajax({
        url:"<?php echo base_url('master/ajax_barangrak') ?>",
        cache:false,
        type:"POST",
        data:{rak:"<?php echo @$id ?>"},
        beforeSend: function(){
            $("#konten").html('<center><img src="<?php echo base_url('assets/img/loading.gif') ?>"></center>');
        },
        success:function(result){
            $("#konten").html(result);
        }
    });
}

function cetak() {
    window.open("<?php echo base_url('master/cetak_barangsuplier') ?>?suplier=<?php echo @$kode ?>");
}
</script>
<?php @$this->load->view($footerend) ?>
<!-- Page specific script -->