<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Form Stok Opname</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item">Manajemen Stok</li>
                        <li class="breadcrumb-item active"><a href="#">Stok Opname</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <div class="card-header">
                            <form method="post" id="formdata">
                                <div class="row">
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Tanggal</label>
                                            <input type="date" class="form-control" id="tanggal" name="tanggal" value="<?php echo @$tanggal ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Rak</label>
                                            <select class="form-control" id="rak" name="rak" onchange="ambilbarang(this.value)" autofocus>
                                                <option value="">-- pilih rak --</option>
                                                <?php
                                                if (@$datarak) {
                                                    foreach ($datarak as $hasil) {
                                                        ?>
                                                        <option value="<?php echo $hasil->rak ?>"><?php echo $hasil->rak ?></option>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <label>Kode Barang</label>
                                            <div class="input-group mb-3">
                                                <button type="button" class="input-group-text btn btn-secondary" title="Cari barang" onclick="tampilbarang()"><i class="fa fa-search"></i></button>
                                                <input type="text" class="form-control" id="kode" name="kode" autocomplete="0" autofocus>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label style="color: white;">&nbsp;</label>
                                            <button type="submit" class="btn btn-success" style="width: 100%;"><i class="fa fa-plus"></i> Tambah</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="card-body">
                            <div id="konten"></div>
                        </div>
                        <div class="card-footer">
                            <a href="<?php echo base_url('stok/opname') ?>" class="btn bg-gradient-danger"><i class="fa fa-times"></i> Batal</a>
                            <a href="<?php echo base_url('stok/cetak_selisihdrafopname') ?>" class="btn bg-gradient-warning" target="_blank"><i class="fa fa-print"></i> Cetak Selisih</a>
                            <a href="<?php echo base_url('stok/form_opname') ?>" class="btn bg-gradient-success"><i class="fa fa-save"></i> Lanjutkan Proses Stok Opname Berikutnya</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End #main -->
<div class="modal fade" id="modalbarang">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Daftar Baarang</h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <table class="table table-hover datatable" style="width: 100%" id="tabelbarang">
                <thead>
                <tr>
                    <th>Kode Barang</th>
                    <th>Barcode</th>
                    <th>Nama Barang</th>
                    <th>Harga</th>
                    <th>Stok</th>
                    <th width="2%"></th>
                </tr>
                </thead>
                <tbody></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" onclick="represh()"><i class="fa fa-sync"></i> Refresh</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-times"></i> Tutup</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal hapus -->
<div class="modal fade" id="modalhapus">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-body">
                <h4>Apakah akan menghapus item barang ini dari daftar stok opname?</h4>
            </div>
            <div class="modal-footer right-content-between">
                <button type="button" id="hapus" value="" onclick="hapusdata(this.value)" class="btn bg-gradient-danger"><i class="fa fa-trash"></i> Hapus</button>
                <button type="button" class="btn bg-gradient-primary" data-dismiss="modal"><i class="fa fa-times"></i> Batal</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal konfirmasi -->
<div class="modal fade" id="modalkonfir">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-body">
                <h4>Apakah yakin akan menyimpan data stok opname ini?</h4>
                <span style="color: red;">Jika sudah disimpan tidak bisa diubah kembali</span>
            </div>
            <div class="modal-footer">
                <button type="button" value="" class="btn btn-danger" onclick="ajusmen()"><i class="fa fa-check"></i> Yakin</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Tidak</button>
            </div>
        </div>
    </div>
</div>
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    tampilkan();
    $("#tabelbarang").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "ajax":{
                url:"<?php echo base_url('transaksi/databarang') ?>",
                type:"post",
        },
    });
});

$(function(){
    $("#formdata").submit(function(event){
        event.preventDefault();
        $.ajax({
            url:"<?php echo base_url('stok/simpan_drafopname') ?>",
            cache: false,
            type:"POST",
            data:$(this).serialize(),
            dataType:"JSON",
            success:function(result) {
                $("#peringatan").html(result.pesan);
                if (result.ikon=='success') {
                    toastr.success(result.toas);
                } else if (result.ikon=='warning') {
                    toastr.warning(result.toas);
                } else if (result.ikon=='error') {
                    toastr.error(result.toas);
                }
                tampilkan();
                $("#kode").val("");
                $("#kode").focus();
            }
        })
    });
});

function simpan(i) {
    var id=$("#id"+i).val();
    var nyata=$("#nyata"+i).val();
    $.ajax({
        url:"<?php echo base_url('stok/update_drafopnamemeta') ?>",
        cache: false,
        type:"POST",
        data:{id:id,nyata:nyata},
        dataType:"JSON",
        success:function(result) {
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
        }
    })
}

function ajusmen() {
    var tanggal=$("#tanggal").val();
    var id=$("#id").val();
    $.ajax({
        url:"<?php echo base_url('stok/ajusmen') ?>",
        cache: false,
        type:"POST",
        data:{tanggal:tanggal,id:id},
        dataType:"JSON",
        beforeSend: function(){
            $("#konten").html('<center><img src="<?php echo base_url('assets/images/loading.gif') ?>"></center>');
        },
        success:function(result) {
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            $("#modalkonfir").modal("hide");
            tampilkan();
            $("#tabelku").DataTable().draw();
        }
    })
}

function tampilbarang() {
    $("#modalbarang").modal("show");
}

function represh() {
    $("#tabelku").DataTable().draw();
}

function pilihbarang(i) {
    $("#kode").val(i);
    $("#modalbarang").modal("hide");
    $("#kode").focus();
}

function konfirhapus(i) {
    $("#hapus").val(i);
    $("#modalhapus").modal("show");
}

function konfirsimpan() {
    $("#modalkonfir").modal("show");
}

function hapusdata(str) {
    $.ajax({
        url:"<?php echo base_url('stok/hapus_opnamemeta') ?>",
        cache:false,
        type:"POST",
        data:{id:str},
        dataType:"JSON",
        success:function(result){
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            $("#modalhapus").modal("hide");
            tampilkan();
            $("#kode").focus();
        }
    });
}

function tampilkan() {
    var rak=$("#rak").val();
    $.ajax({
        url:"<?php echo base_url('stok/ajax_drafopname') ?>",
        cache:false,
        type:"POST",
        data:{rak:rak},
        beforeSend: function(){
            $("#konten").html('<center><img src="<?php echo base_url('assets/images/loading.gif') ?>"></center>');
        },
        success:function(result){
            $("#konten").html(result);
        }
    });
}

function cetak() {
    var tanggal=$("#tanggal").val();
    window.open("<?php echo base_url('stok/cetak_opname') ?>?tanggal="+tanggal);
}

function ambilbarang(str) {
    var tanggal=$("#tanggal").val();
    $.ajax({
        url:"<?php echo base_url('stok/simpan_drafopnamemeta') ?>",
        cache:false,
        type:"POST",
        data:{rak:str,tanggal:tanggal},
        dataType:"JSON",
        beforeSend: function(){
            $("#konten").html('<center><img src="<?php echo base_url('assets/images/loading.gif') ?>"></center>');
        },
        success:function(result) {
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            tampilkan();
        }
    });
}
</script>
<?php @$this->load->view($footerend) ?>
<!-- Page specific script -->