<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Kartu Stok</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item">Manajemen Stok</li>
                        <li class="breadcrumb-item active"><a href="#">Kartu Stok</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Tanggal Awal</label>
                                        <input type="date" class="form-control" id="awal" name="awal" value="<?php echo @$awal ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Tanggal Akhir</label>
                                        <input type="date" class="form-control" id="akhir" name="akhir" value="<?php echo @$akhir ?>">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Kode Barang</label>
                                        <div class="input-group mb-3">
                                            <button type="button" class="input-group-text btn btn-secondary" title="Cari barang" onclick="tampilbarang()"><i class="fa fa-search"></i></button>
                                            <input type="text" class="form-control" id="kode" name="kode" autocomplete="0" autofocus>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label style="color: white;">&nbsp;</label>
                                        <button type="button" class="btn btn-primary" style="width: 100%;" onclick="tampilkan()"><i class="fa fa-search"></i> Tampilkan</button>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label style="color: white;">&nbsp;</label>
                                        <button type="button" class="btn btn-secondary" onclick="cetak()" style="width: 100%;"><i class="fa fa-print"></i> Cetak</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="konten"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- model barang -->
<div class="modal fade" id="modalbarang">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Daftar Baarang</h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <table class="table table-hover datatable" style="width: 100%" id="tabelbarang">
                <thead>
                <tr>
                    <th>Kode Barang</th>
                    <th>Barcode</th>
                    <th>Nama Barang</th>
                    <th>Harga</th>
                    <th>Stok</th>
                    <th width="2%"></th>
                </tr>
                </thead>
                <tbody></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" onclick="represh()"><i class="fa fa-sync"></i> Refresh</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-times"></i> Tutup</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- End #main -->
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    tampilkan();
    $("#tabelbarang").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "ajax":{
                url:"<?php echo base_url('transaksi/databarang') ?>",
                type:"post",
        },
    });
});

function tampilbarang() {
    $("#modalbarang").modal("show");
}

function represh() {
    $("#tabelku").DataTable().draw();
}

function pilihbarang(i) {
    $("#kode").val(i);
    $("#modalbarang").modal("hide");
    $("#kode").focus();
}

function tampilkan() {
    var awal=$("#awal").val();
    var akhir=$("#akhir").val();
    var kode=$("#kode").val();
    $.ajax({
        url:"<?php echo base_url('stok/ajax_kartu') ?>",
        cache:false,
        type:"POST",
        data:{awal:awal,akhir:akhir,kode:kode},
        beforeSend: function(){
            $("#konten").html('<center><img src="<?php echo base_url('assets/images/loading.gif') ?>"></center>');
        },
        success:function(result){
            $("#konten").html(result);
        }
    });
}

function cetak() {
    var awal=$("#awal").val();
    var akhir=$("#akhir").val();
    var kode=$("#kode").val();
    window.open("<?php echo base_url('stok/cetak_kartu') ?>?awal="+awal+"&akhir="+akhir+"&kode="+kode);
}
</script>
<!-- Page specific script -->
<?php @$this->load->view($footerend) ?>