<main id="main" class="main">
    <div class="pagetitle">
        <h1>Form Mutasi Barang</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                <li class="breadcrumb-item">Transaksi</li>
                <li class="breadcrumb-item active">Mutasi Barang</li>
            </ol>
        </nav>
    </div>
    <!-- End Page Title -->

    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div id="peringatan"></div>
                <div class="card">
                    <div class="card-header">
                        <form method="post" id="formdata">
                            <div class="row g-2">
                                <div class="col-md-5">
                                    <label class="form-label">Kode Barang</label>
                                    <div class="input-group mb-3">
                                        <button type="button" class="input-group-text btn btn-secondary" title="Cari barang" onclick="tampilbarang()"><i class="bi bi-search"></i></button>
                                        <input type="text" class="form-control" id="kode" name="kode" value="" autofocus>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <label class="form-label">Jumlah</label>
                                    <input type="number" class="form-control" onfocus="carijumlah()" id="jumlah" name="jumlah" required>
                                    <span style="color: red;"><i>Menggunakan satuan eceran/satuan terkecil</i></span>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label" style="color: white;">&nbsp;</label>
                                    <button type="submit" class="btn btn-success" style="width: 100%;"><i class="bi bi-plus"></i> Tambah</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <form method="post" id="formpo">
                        <div class="card-body">
                            <table class="table table-hover" id="tabelkeranjang">
                            <thead>
                            <tr>
                                <th scope="col">Kode Barang</th>
                                <th scope="col">Nama Barang</th>
                                <th scope="col">Jumlah</th>
                                <th scope="col">Harga Beli</th>
                                <th scope="col">Total Harga</th>
                                <th scope="col" width="2%"></th>
                            </tr>
                            </thead>
                            <tbody></tbody>
                            </table>
                        </div>
                        <div class="card-footer">
                            <div class="row g-2">
                                <div class="col-md-4">
                                    <label class="form-label">Kode Mutasi</label>
                                    <input type="text" class="form-control" id="kode" name="kode" value="<?php echo @$kode ?>" readonly>
                                    <span style="color: red;"><i>Otomatis dari sistem</i></span>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Tujuan Toko</label>
                                    <select class="form-select" id="toko" name="toko" required>
                                        <option value="">-- pilih toko --</option>
                                        <?php
                                        foreach ($datatoko as $hasil) {
                                            ?>
                                            <option value="<?php echo $hasil->kode_toko ?>"><?php echo $hasil->toko ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                                <input type="hidden" name="id" id="id" value="<?php echo @$kode ?>">
                                <input type="hidden" name="aksi" id="aksi" value="<?php echo @$aksi ?>">
                                <div class="col-md-2">
                                    <label class="form-label">&nbsp;</label>
                                    <button type="submit" value="<?php echo @$aksi ?>" class="btn btn-success" style="width: 100%;"><i class="bi bi-save"></i> <?php echo @$aksi ?></button>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label">&nbsp;</label>
                                    <a href="<?php echo base_url('transaksi/mutasi') ?>" style="width: 100%;" class="btn btn-danger"><i class="bi bi-x-circle"></i> Kembali</a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</main>
<!-- End #main -->
<div class="modal fade" id="modalbarang" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Daftar Barang</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <table class="table table-hover datatable" style="width: 100%" id="tabelbarang">
                <thead>
                <tr>
                    <th>Kode Barang</th>
                    <th>Barcode</th>
                    <th>Nama Barang</th>
                    <th>Harga</th>
                    <th>Stok</th>
                    <th width="2%"></th>
                </tr>
                </thead>
                <tbody></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" onclick="represh()"><i class="bi bi-arrow-repeat"></i> Refresh</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bi bi-x-circle"></i> Tutup</button>
            </div>
        </div>
    </div>
</div>
<!-- modal hapus -->
<div class="modal fade" id="modalhapus" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Konfirmasi Hapus</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <h5>Apakah akan menghapus item barang ini dari daftar permintaan barang?</h5>
            </div>
            <div class="modal-footer">
                <button type="button" value="" class="btn btn-danger" name="hapus" id="hapus" onclick="hapusdata(this.value)"><i class="bi bi-trash"></i> Hapus</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="bi bi-x-circle"></i> Batal</button>
            </div>
        </div>
    </div>
</div>
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    $("#tabelbarang").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "ajax":{
                url:"<?php echo base_url('transaksi/databarang') ?>",
                type:"post",
        },
    });

    $("#tabelkeranjang").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "searching": false,
        "paging": false,
        "bInfo" : false,
        "sDom": 't',
        "ajax":{
                url:"<?php echo base_url('transaksi/datakeranjangmutasi') ?>",
                type:"post",
        },
    });
});

$(function(){
    $("#formdata").submit(function(event){
        event.preventDefault();
        $.ajax({
            url:"<?php echo base_url('transaksi/simpan_keranjangmutasi') ?>",
            cache: false,
            type:"POST",
            data:$(this).serialize(),
            success:function(result) {
                $("#peringatan").html(result);
                $("#tabelku").DataTable().draw();
                $("#tabelkeranjang").DataTable().draw();
                $("#formdata").trigger("reset");
                $("#kode").focus();
            }
        })
    });
});

$(function(){
    $("#formpo").submit(function(event){
        event.preventDefault();
        $.ajax({
            url:"<?php echo base_url('transaksi/simpan_mutasi') ?>",
            cache: false,
            type:"POST",
            data:$(this).serialize(),
            success:function(result) {
                $("#peringatan").html(result);
                $("#tabelku").DataTable().draw();
                $("#tabelkeranjang").DataTable().draw();
                $("#formdata").trigger("reset");
                $("#kode").focus();
            }
        })
    });
});

function tampilbarang() {
    $("#modalbarang").modal("show");
}

function represh() {
    $("#tabelku").DataTable().draw();
    $("#tabelkeranjang").DataTable().draw();
}

function pilihbarang(i) {
    $("#kode").val(i);
    $("#modalbarang").modal("hide");
    $("#jumlah").focus();
}

function konfirhapus(i) {
    $("#hapus").val(i);
    $("#modalhapus").modal("show");
}

function hapusdata(str) {
    $.ajax({
        url:"<?php echo base_url('transaksi/hapus_keranjang') ?>",
        cache:false,
        type:"POST",
        data:{id:str},
        success:function(result){
            $("#peringatan").html(result);
            $("#modalhapus").modal("hide");
            $("#tabelku").DataTable().draw();
            $("#tabelkeranjang").DataTable().draw();
            $("#kode").focus();
        }
    });
}
</script>
<?php @$this->load->view($footerend) ?>
<!-- Page specific script -->