<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Pembayaran Piutang</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item">Pembayaran Piutang</li>
                        <li class="breadcrumb-item active"><a href="#">Pembayaran Piutang</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <div class="card-header">
                            <button class="btn btn-primary" onclick="represh()"><i class="fa fa-sync"></i> Refresh</button>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered datatable dt-responsive" id="tabelku" style="width: 100%;">
                            <thead>
                            <tr>
                                <th>Tanggal</th>
                                <th>Faktur Jual</th>
                                <th>Kode Member</th>
                                <th>Nama Member</th>
                                <th>Jumlah Piutang</th>
                                <th>Sisa</th>
                                <th>Terbayar</th>
                                <th width="2%"></th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- modal utama -->
<div class="modal fade" id="modalform">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <form id="formdata" method="post"></form>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal hapus -->
<div class="modal fade" id="modalhapus">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-body">
                <h4>Apakah akan menghapus piutang member ini?</h4>
            </div>
            <div class="modal-footer right-content-between">
                <button type="button" id="hapus" value="" onclick="hapusdata(this.value)" class="btn bg-gradient-danger"><i class="fa fa-trash"></i> Hapus</button>
                <button type="button" class="btn bg-gradient-primary" data-dismiss="modal"><i class="fa fa-times"></i> Batal</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- End #main -->
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    $("#tabelku").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "ajax":{
                url:"<?php echo base_url('transaksi/databayarpiutang') ?>",
                type:"post",
        },
    });
});

$(function(){
    $("#formdata").submit(function(event){
        event.preventDefault();
        $.ajax({
            url:"<?php echo base_url('transaksi/simpan_bayarpiutang') ?>",
            cache: false,
            type:"POST",
            data:$(this).serialize(),
            dataType:"JSON",
            success:function(result) {
                $("#peringatan").html(result.pesan);
                if (result.ikon=='success') {
                    toastr.success(result.toas);
                } else if (result.ikon=='warning') {
                    toastr.warning(result.toas);
                } else if (result.ikon=='error') {
                    toastr.error(result.toas);
                }
                $("#tabelku").DataTable().draw();
                $("#modalform").modal('hide');
            }
        });
    });
});

function tampilform(str) {
    $("#modalform").modal("show");
    $.ajax({
        url:"<?php echo base_url('transaksi/form_bayarpiutang') ?>",
        cache:false,
        type:"POST",
        data:{id:str},
        success:function(result){
            $("#formdata").html(result);
        }
    });
}

function represh() {
    $("#tabelku").DataTable().draw();
}

function konfirhapus(i) {
    $("#hapus").val(i);
    $("#modalhapus").modal("show");
}

function hapusdata(str) {
    $.ajax({
        url:"<?php echo base_url('transaksi/hapus_bayarpiutang') ?>",
        cache:false,
        type:"POST",
        data:{id:str},
        dataType:"JSON",
        success:function(result){
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            $("#modalhapus").modal("hide");
            $("#tabelku").DataTable().draw();
        }
    });
}
</script>
<?php @$this->load->view($footerend) ?>