<main id="main" class="main">
    <div class="pagetitle">
        <h1>Transaksi Pembelian</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                <li class="breadcrumb-item">Transaksi</li>
                <li class="breadcrumb-item active">Pembelian</li>
            </ol>
        </nav>
    </div>
    <!-- End Page Title -->

    <section class="section">
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <form class="row g-2" method="post" id="formdata">
                            <div class="col-md-5">
                                <label class="form-label">Kode Barang</label>
                                <div class="input-group mb-3">
                                    <button type="button" class="input-group-text btn btn-secondary" title="Cari barang" onclick="tampilbarang()"><i class="bi bi-search"></i></button>
                                    <input type="text" class="form-control" id="kode" name="kode" autocomplete="0" autofocus>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <label class="form-label">Jumlah</label>
                                <input type="number" class="form-control" id="jumlah" name="jumlah">
                                <span style="color: red;"><i>dalam satuan grosir</i></span>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label" style="color: white;">&nbsp;</label>
                                <button type="submit" class="btn btn-success" style="width: 100%;" value=""><i class="bi bi-plus"></i></button>
                            </div>
                        </form>
                    </div>
                    <div class="card-body">
                        <div id="peringatan"></div>
                        <!-- Table with stripped rows -->
                        <table class="table table-hover" id="tabelkeranjang">
                        <thead>
                        <tr>
                            <th scope="col">Kode Barang</th>
                            <th scope="col">Nama Barang</th>
                            <th scope="col">Jumlah</th>
                            <th scope="col">Total Harga</th>
                            <th scope="col" width="2%"></th>
                        </tr>
                        </thead>
                        <tbody></tbody>
                        </table>
                        <!-- End Table with stripped rows -->
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <form class="row g-3" method="post" id="formbeli">
                    <div class="card">
                        <div class="card-body">
                            <div class="col-12">
                                <label class="form-label">Tanggal Pembelian</label>
                                <input type="date" class="form-control" id="tanggal" name="tanggal" value="<?php echo date('Y-m-d') ?>" required>
                            </div>
                            <div class="col-12">
                                <label class="form-label">Total Harga Pembelian</label>
                                <input type="number" class="form-control" id="total" name="total" value="" required>
                            </div>
                            <div class="col-12">
                                <label class="form-label">Suplier</label>
                                <select class="form-control" id="suplier" name="suplier">
                                    <option value="">-- pilih suplier --</option>
                                    <?php
                                    foreach ($datasuplier as $hasil) {
                                        ?>
                                        <option value="<?php echo $hasil->kode_suplier ?>"><?php echo $hasil->suplier ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="col-12">
                                <label class="form-label">No. Nota Pembelian</label>
                                <input type="text" class="form-control" id="nota" name="nota" required>
                            </div>
                            <div class="col-12">
                                <label class="form-label">Catatan</label>
                                <textarea class="form-control" id="catatan" name="catatan"></textarea>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" value="Simpan" class="btn btn-success"><i class="bi bi-save"></i> Simpan</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
</main>
<!-- End #main -->
<div class="modal fade" id="modalbarang" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Transaksi Penjualan</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <table class="table table-hover datatable" style="width: 100%" id="tabelku">
                <thead>
                <tr>
                    <th>Kode Barang</th>
                    <th>Barcode</th>
                    <th>Nama Barang</th>
                    <th>Harga</th>
                    <th>Stok</th>
                    <th width="2%"></th>
                </tr>
                </thead>
                <tbody></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" onclick="represh()"><i class="bi bi-arrow-repeat"></i> Refresh</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bi bi-x-circle"></i> Tutup</button>
            </div>
        </div>
    </div>
</div>
<!-- modal form -->
<div class="modal fade" id="modalhapus" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Konfirmasi Hapus</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <h5>Apakah akan menghapus item barang ini dari transaksi?</h5>
            </div>
            <div class="modal-footer">
                <button type="button" value="" class="btn btn-danger" name="hapus" id="hapus" onclick="hapusdata(this.value)"><i class="bi bi-trash"></i> Hapus</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="bi bi-x-circle"></i> Batal</button>
            </div>
        </div>
    </div>
</div>
<!-- modal hapus -->
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    totalharga();
    $("#tabelku").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "ajax":{
                url:"<?php echo base_url('transaksi/databarang') ?>",
                type:"post",
        },
    });
});

$(document).ready(function() {
    totalharga();
    $("#tabelkeranjang").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "searching": false,
        "paging": false,
        "bInfo" : false,
        "sDom": 't',
        "ajax":{
                url:"<?php echo base_url('transaksi/datakeranjangbeli') ?>",
                type:"post",
        },
    });
});

$(function(){
    $("#formdata").submit(function(event){
        event.preventDefault();
        $.ajax({
            url:"<?php echo base_url('transaksi/simpan_keranjangbeli') ?>",
            cache: false,
            type:"POST",
            data:$(this).serialize(),
            success:function(result) {
                $("#peringatan").html(result);
                $("#tabelku").DataTable().draw();
                $("#tabelkeranjang").DataTable().draw();
                $("#formdata").trigger("reset");
                totalharga();
            }
        });
    });
});

$(function(){
    $("#formbeli").submit(function(event){
        event.preventDefault();
        $.ajax({
            url:"<?php echo base_url('transaksi/simpan_pembelian') ?>",
            cache: false,
            type:"POST",
            data:$(this).serialize(),
            success:function(result) {
                $("#peringatan").html(result);
                $("#tabelku").DataTable().draw();
                $("#tabelkeranjang").DataTable().draw();
                $("#formbeli").trigger("reset");
                totalharga();
            }
        });
    });
});

function tampilbarang() {
    $("#modalbarang").modal("show");
}

function represh() {
    $("#tabelku").DataTable().draw();
    $("#tabelkeranjang").DataTable().draw();
    totalharga();
}

function pilihbarang(i) {
    $("#kode").val(i);
    $("#jumlah").focus();
    $("#modalbarang").modal("hide");
}

function konfirhapus(i) {
    $("#hapus").val(i);
    $("#modalhapus").modal("show");
}

function hapusdata(str) {
    $.ajax({
        url:"<?php echo base_url('transaksi/hapus_keranjang') ?>",
        cache:false,
        type:"POST",
        data:{id:str},
        success:function(result){
            $("#peringatan").html(result);
            $("#modalhapus").modal("hide");
            $("#tabelku").DataTable().draw();
            $("#tabelkeranjang").DataTable().draw();
            totalharga();
        }
    });
}

function totalharga() {
    $.ajax({
        url:"<?php echo base_url('transaksi/harga_beli') ?>",
        cache:false,
        type:"POST",
        data:{status:"beli"},
        success:function(result){
            $("#total").val(result);
        }
    });
}
</script>
<?php @$this->load->view($footerend) ?>
<!-- Page specific script -->