<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Transaksi Penjualan</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url('beranda') ?>">Beranda</a></li>
                        <li class="breadcrumb-item">Transaksi</li>
                        <li class="breadcrumb-item active"><a href="#">Penjualan</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div id="peringatan"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card card-success card-outline">
                        <div class="card-header">
                            <form method="post" id="formdata">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Kode Barang</label>
                                            <div class="input-group mb-3">
                                                <button type="button" class="input-group-text btn btn-secondary" title="Cari barang" onclick="tampilbarang()"><i class="fa fa-search"></i></button>
                                                <input type="text" class="form-control" id="kode" name="kode" onblur="ubahbarcode(this.value)" autocomplete="0" autofocus>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Jumlah</label>
                                            <input type="text" name="jumlah" id="jumlah" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Satuan</label>
                                            <select name="satuan" id="satuan" class="form-control"></select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label style="color: white;">&nbsp;</label>
                                            <button type="submit" class="btn btn-success" style="width: 100%;"><i class="fa fa-plus"></i> Tambah</button>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="form-label"><strong>Total Harga</strong></label>
                                            <h3 id="toha" style="color: black; font-weight: bold; text-align: right;">-</h3>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="card-body">
                            <table class="table table-hover" id="tabelkeranjang" style="width: 100%;">
                            <thead>
                            <tr>
                                <th>Kode Barang</th>
                                <th>Barcode</th>
                                <th>Nama Barang</th>
                                <th>Jumlah</th>
                                <th>Total Harga</th>
                                <th width="2%"></th>
                            </tr>
                            </thead>
                            <tbody></tbody>
                            </table>
                        </div>
                        <div class="card-footer">
                            <form method="post" id="formmemb">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Member [F7]</label>
                                            <div class="input-group mb-3">
                                                <button type="button" class="input-group-text btn btn-secondary" title="Cari member" onclick="tampilmember()"><i class="fa fa-search"></i></button>
                                                <input type="text" class="form-control" id="member" name="member" onblur="pilihmember(this.value); ubahmember(this.value)" autocomplete="0">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Total Harga</label>
                                            <input type="text" name="total" id="total" class="form-control" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="button" class="btn btn-secondary" style="width: 100%;" id="btnbayar" value="" onclick="tampilform()" title="F8"><i class="fa fa-credit-card"></i> Bayar [F8]</button>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <a href="<?php echo base_url('transaksi/cetak_faktur') ?>" style="width: 100%;" target="_blank" class="btn btn-danger"><i class="fa fa-print"></i> Re-print Nota</a>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- form bayar -->
<div class="modal fade" id="modalform">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <form method="post" id="formjual"></form>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal utama -->
<div class="modal fade" id="modalbarang">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Transaksi Penjualan</h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <table class="table table-hover datatable" style="width: 100%" id="tabelbarang">
                <thead>
                <tr>
                    <th>Kode Barang</th>
                    <th>Barcode</th>
                    <th>Nama Barang</th>
                    <th>Harga</th>
                    <th>Stok</th>
                    <th width="2%"></th>
                </tr>
                </thead>
                <tbody></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" onclick="represh()"><i class="fa fa-refresh"></i> Refresh</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-times"></i> Tutup</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal member -->
<div class="modal fade" id="modalmember">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">Member</h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <table class="table table-hover datatable" style="width: 100%" id="tabelmember">
                <thead>
                <tr>
                    <th>Kode Member</th>
                    <th>Nama</th>
                    <th width="2%">L/P</th>
                    <th>Telepon</th>
                    <th>Alamat</th>
                    <th width="2%"></th>
                </tr>
                </thead>
                <tbody>
                <?php
                foreach ($datamember as $hasil) {
                    ?>
                    <tr>
                        <td><?php echo $hasil->kode_member ?></td>
                        <td><?php echo $hasil->member ?></td>
                        <td><?php echo $hasil->jekel ?></td>
                        <td><?php echo $hasil->telepon ?></td>
                        <td><?php echo $hasil->alamat ?></td>
                        <td><button type="button" title="Pilih" onclick="pilihmember(this.value)" class="btn btn-primary btn-xs" value="<?php echo $hasil->kode_member ?>"><i class="fa fa-pencil-alt"></i></button></td>
                    </tr>
                    <?php
                }
                ?>
                </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-times"></i> Tutup</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal hapus -->
<div class="modal fade" id="modalhapus">
    <div class="modal-dialog modal-lg">
        <!-- modal-content -->
        <div class="modal-content">
            <div class="modal-body">
                <h4>Apakah akan menghapus barang dari daftar transaksi?</h4>
            </div>
            <div class="modal-footer right-content-between">
                <button type="button" id="hapus" value="" onclick="hapusdata(this.value)" class="btn bg-gradient-danger"><i class="fa fa-trash"></i> Hapus</button>
                <button type="button" class="btn bg-gradient-primary" data-dismiss="modal"><i class="fa fa-times"></i> Batal</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- End #main -->
<?php @$this->load->view($footer) ?>
<!-- Page specific script -->
<script type="text/javascript">
$(document).ready(function() {
    totalharga();
    hidupmati();
    var member=$("#member").val();
    $("#tabelbarang").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "ajax":{
                url:"<?php echo base_url('transaksi/databarang') ?>",
                type:"post",
        },
    });

    $("#tabelmember").DataTable({
        "processing":true,
        "serverSide":false,
        "responsive":true,
    });

    $("#tabelkeranjang").DataTable({
        "processing":true,
        "serverSide":true,
        "responsive":true,
        "searching": false,
        "paging": false,
        "bInfo" : false,
        "sDom": 't',
        "ajax":{
                url:"<?php echo base_url('transaksi/datakeranjangjual') ?>?member="+member,
                type:"post",
        },
    });

    //tombol keyboard
    $(document).keydown(function(e){
        if (e.which==119) {
            tampilform();
            $("#tunai").focus();
        } else if (e.which==118) {
            tampilmember();
        }
    });
    
    //tombol keyboard untuk pindah satuan
    $("#jumlah").keydown(function(e){
        if (e.which==39) {
           $("#satuan").focus();
        } else if (e.which==37) {
            $("#kode").focus();
        }
    });
    
    $("#kode").keydown(function(e){
        if (e.which==39 || e.which==13) {
           $("#jumlah").focus();
           ubahbarcode(this);
        }
    });
    
    $("#satuan").keypress(function(e){
        if (e.which==13) {
            event.preventDefault();
            $("#formdata").submit();
        } else if (e.which==37) {
            $("#jumlah").focus();
        }
    });
    
    $("#satuan").keydown(function(e){
        if (e.which==37) {
           $("#jumlah").focus();
        }
    });

    $("#modalform").on("shown.bs.modal", function() {
        $("#tunai").focus();
    });
});

$(function(){
    $("#formdata").submit(function(event){
        var jumlah=$("#jumlah").val();
        event.preventDefault();
        if (jumlah==0 || jumlah=='') {
            $("#jumlah").focus();
        } else {
            $.ajax({
                url:"<?php echo base_url('transaksi/simpan_keranjang') ?>",
                cache: false,
                type:"POST",
                data:$(this).serialize(),
                success:function(result) {
                    $("#peringatan").html(result);
                    $("#tabelku").DataTable().draw();
                    $("#tabelkeranjang").DataTable().draw();
                    $("#formdata").trigger("reset");
                    $("#kode").focus();
                    $("#satuan").html("");
                    totalharga();
                }
            })
        }
    });
});

$(function(){
    $("#formjual").submit(function(event){
        event.preventDefault();
        $.ajax({
            url:"<?php echo base_url('transaksi/simpan_penjualan') ?>",
            cache: false,
            type:"POST",
            data:$(this).serialize(),
            dataType:"JSON",
            success:function(result) {
                $("#peringatan").html(result.pesan);
                if (result.ikon=='success') {
                    toastr.success(result.toas);
                } else if (result.ikon=='warning') {
                    toastr.warning(result.toas);
                } else if (result.ikon=='error') {
                    toastr.error(result.toas);
                }
                $("#tabelku").DataTable().draw();
                $("#tabelkeranjang").DataTable().draw();
                $("#modalform").modal("hide");
                $("#member").val("");
                $("#kode").focus();
                if (result.faktur) {
                    window.open("<?php echo base_url('transaksi/cetak_faktur?no=') ?>"+result.faktur)
                }
                totalharga();
                hidupmati();
            }
        });
    });
});

$(function() { 
    $("#kode").autocomplete({
        source: function(request,response) {
            $.ajax({
                url:"<?php echo base_url('transaksi/jbarang') ?>",
                dataType:"JSON",
                data:{id:request.term},
                type:"POST",
                success: function(data) {
                    response(data);
                }
            });
        },
        minLength:3
    });
});

$(function() { 
    $("#member").autocomplete({
        source: function(request,response) {
            $.ajax({
                url:"<?php echo base_url('transaksi/jmember') ?>",
                dataType:"JSON",
                data:{id:request.term},
                type:"POST",
                success: function(data) {
                    response(data);
                }
            });
        },
        minLength:2
    });
});

$(".modal").on("shown.bs.modal", function(e) {
   $("div.dataTables_filter input").focus();
})

function carisatuan() {
    var kode=$("#kode").val();
    $.ajax({
        url:"<?php echo base_url('transaksi/jsatuanbarang') ?>",
        cache:false,
        type:"POST",
        data:{id:kode},
        success:function(result){
            $("#satuan").html(result);
        }
    });
}

function tampilform() {
    $("#modalform").modal("show");
    $("#tunai").focus();
    var member=$("#member").val();
    $.ajax({
        url:"<?php echo base_url('transaksi/form_bayar') ?>",
        cache:false,
        type:"POST",
        data:{member:member},
        success:function(result){
            $("#formjual").html(result);
        }
    });
}

function tampilbarang() {
    $("#modalbarang").modal("show");
}

function tampilmember() {
    $("#modalmember").modal("show");
}

function represh() {
    $("#tabelku").DataTable().draw();
    $("#tabelkeranjang").DataTable().draw();
    $("#tabelmember").DataTable().draw();
    totalharga();
}

function pilihbarang(i) {
    $("#kode").val(i);
    $("#modalbarang").modal("hide");
    $("#jumlah").focus();
}

function pilihmember(i) {
    //pecah string dulu
    kdm=i.split(" - ");
    $("#member").val(kdm[0]);
    
    var table=$("#tabelkeranjang").DataTable();
    $("#member").val(kdm[0]);
    $("#modalmember").modal("hide");
    //$("#btnbayar").focus();
    table.ajax.url("<?php echo base_url('transaksi/datakeranjangjual') ?>?member="+kdm[0]).load();
    totalharga();
}

function konfirhapus(i) {
    $("#hapus").val(i);
    $("#modalhapus").modal("show");
}

function hapusdata(str) {
    $.ajax({
        url:"<?php echo base_url('transaksi/hapus_keranjang') ?>",
        cache:false,
        type:"POST",
        data:{id:str},
        dataType:"JSON",
        success:function(result){
            $("#peringatan").html(result.pesan);
            if (result.ikon=='success') {
                toastr.success(result.toas);
            } else if (result.ikon=='warning') {
                toastr.warning(result.toas);
            } else if (result.ikon=='error') {
                toastr.error(result.toas);
            }
            $("#modalhapus").modal("hide");
            $("#tabelku").DataTable().draw();
            $("#tabelkeranjang").DataTable().draw();
            $("#kode").focus();
            totalharga();
        }
    });
}

function totalharga() {
    var member=$("#member").val();
    $.ajax({
        url:"<?php echo base_url('transaksi/harga_jual') ?>",
        cache:false,
        type:"POST",
        data:{member:member},
        success:function(result){
            rupiah=new Intl.NumberFormat("id-ID",{
                        style:"decimal",
                        currency:"IDR"
                    }).format(result);
            $("#total").val(result);
            $("#toha").html("Rp "+rupiah);
        }
    });
}

function hitungkembali() {
    var total=$("#totall").val();
    var tunai=$("#tunai").val();
    var non=$("#non").val();
    kembali=(Number(tunai)+Number(non))-Number(total);
    /*if (kembali<0) {
        $("#kembali").val(0);
    } else {
        $("#kembali").val(kembali);
    }*/
    $("#kembali").val(kembali);
}

function tukarpoin() {
    var tot=$("#tot").val();
    var a=$("#poin").val();
    var b=$("#tkoin").val();
    var nilaipoin=<?php echo @$nilaipoin ?>;
    if ($("#tkoin").prop("checked")==true) {
        b=$("#tkoin").val();
    } else {
        b=0;
    }
    if ($("#poin").prop("checked")==true) {
        a=$("#poin").val();
    } else {
        a=0;
    }
    if ($("#poin").prop("checked")==true || $("#tkoin").prop("checked")==true) {
        potong=Number(tot)-Number(b)-(Number(a)*Number(nilaipoin));
    } else {
        potong=Number(tot);
    }
    $("#totall").val(potong);
    hitungkembali();
}

function hidupmati() {
    var non=$("#non").val();
    if (non) {
        $("#metode").attr("disabled",false);
        $("#referensi").attr("disabled",false);
    } else {
        $("#metode").attr("disabled",true);
        $("#referensi").attr("disabled",true);
    }
}

function ubahbarcode(i) {
    brcd=i.split(" - ");
    $("#kode").val(brcd[0]);
    carisatuan();
}

function ubahmember(i) {
    brcd=i.split(" - ");
    $("#member").val(brcd[0]);
}
</script>
<?php @$this->load->view($footerend) ?>